/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.hadoop;

import cascading.flow.FlowProcess;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.scheme.FileFormat;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;

public class TextLine
extends Scheme<Configuration, RecordReader, OutputCollector, Object[], Object[]>
implements FileFormat {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final long serialVersionUID = 1L;
    public static final Fields DEFAULT_SOURCE_FIELDS = new Fields(new Comparable[]{"offset", "line"}).applyTypes(new Type[]{Long.TYPE, String.class});
    private static final Pattern zipPattern = Pattern.compile("\\.[zZ][iI][pP]([ ,]|$)");
    Compress sinkCompression = Compress.DISABLE;
    String charsetName = "UTF-8";

    public TextLine() {
        super(DEFAULT_SOURCE_FIELDS);
    }

    @ConstructorProperties(value={"numSinkParts"})
    public TextLine(int numSinkParts) {
        super(DEFAULT_SOURCE_FIELDS, numSinkParts);
    }

    @ConstructorProperties(value={"sinkCompression"})
    public TextLine(Compress sinkCompression) {
        super(DEFAULT_SOURCE_FIELDS);
        this.setSinkCompression(sinkCompression);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields"})
    public TextLine(Fields sourceFields, Fields sinkFields) {
        super(sourceFields, sinkFields);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "charsetName"})
    public TextLine(Fields sourceFields, Fields sinkFields, String charsetName) {
        super(sourceFields, sinkFields);
        this.setCharsetName(charsetName);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "numSinkParts"})
    public TextLine(Fields sourceFields, Fields sinkFields, int numSinkParts) {
        super(sourceFields, sinkFields, numSinkParts);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "sinkCompression"})
    public TextLine(Fields sourceFields, Fields sinkFields, Compress sinkCompression) {
        super(sourceFields, sinkFields);
        this.setSinkCompression(sinkCompression);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "sinkCompression", "charsetName"})
    public TextLine(Fields sourceFields, Fields sinkFields, Compress sinkCompression, String charsetName) {
        super(sourceFields, sinkFields);
        this.setSinkCompression(sinkCompression);
        this.setCharsetName(charsetName);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "sinkCompression", "numSinkParts"})
    public TextLine(Fields sourceFields, Fields sinkFields, Compress sinkCompression, int numSinkParts) {
        super(sourceFields, sinkFields, numSinkParts);
        this.setSinkCompression(sinkCompression);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "sinkFields", "sinkCompression", "numSinkParts", "charsetName"})
    public TextLine(Fields sourceFields, Fields sinkFields, Compress sinkCompression, int numSinkParts, String charsetName) {
        super(sourceFields, sinkFields, numSinkParts);
        this.setSinkCompression(sinkCompression);
        this.setCharsetName(charsetName);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields"})
    public TextLine(Fields sourceFields) {
        super(sourceFields);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "charsetName"})
    public TextLine(Fields sourceFields, String charsetName) {
        super(sourceFields);
        this.setCharsetName(charsetName);
        this.verify(sourceFields);
    }

    @ConstructorProperties(value={"sourceFields", "numSinkParts"})
    public TextLine(Fields sourceFields, int numSinkParts) {
        super(sourceFields, numSinkParts);
        this.verify(sourceFields);
    }

    protected void setCharsetName(String charsetName) {
        if (charsetName != null) {
            this.charsetName = charsetName;
        }
        Charset.forName(this.charsetName);
    }

    @Property(name="charset", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="character set used in this scheme.")
    public String getCharsetName() {
        return this.charsetName;
    }

    protected void verify(Fields sourceFields) {
        if (sourceFields.size() < 1 || sourceFields.size() > 2) {
            throw new IllegalArgumentException("this scheme requires either one or two source fields, given [" + sourceFields + "]");
        }
    }

    @Property(name="sinkCompression", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The compression of the scheme when used in a sink.")
    public Compress getSinkCompression() {
        return this.sinkCompression;
    }

    public void setSinkCompression(Compress sinkCompression) {
        if (sinkCompression != null) {
            this.sinkCompression = sinkCompression;
        }
    }

    public void sourceConfInit(FlowProcess<? extends Configuration> flowProcess, Tap<Configuration, RecordReader, OutputCollector> tap, Configuration conf) {
        JobConf jobConf = HadoopUtil.asJobConfInstance(conf);
        String paths = jobConf.get("mapred.input.dir", "");
        if (this.hasZippedFiles(paths)) {
            throw new IllegalStateException("cannot read zip files: " + paths);
        }
        conf.setBoolean("mapred.mapper.new-api", false);
        conf.setClass("mapred.input.format.class", TextInputFormat.class, InputFormat.class);
    }

    private boolean hasZippedFiles(String paths) {
        if (paths == null || paths.length() == 0) {
            return false;
        }
        return zipPattern.matcher(paths).find();
    }

    public void presentSourceFields(FlowProcess<? extends Configuration> flowProcess, Tap tap, Fields fields) {
    }

    public void presentSinkFields(FlowProcess<? extends Configuration> flowProcess, Tap tap, Fields fields) {
    }

    public void sinkConfInit(FlowProcess<? extends Configuration> flowProcess, Tap<Configuration, RecordReader, OutputCollector> tap, Configuration conf) {
        if (tap.getFullIdentifier((Object)conf).endsWith(".zip")) {
            throw new IllegalStateException("cannot write zip files: " + HadoopUtil.getOutputPath(conf));
        }
        conf.setBoolean("mapred.mapper.new-api", false);
        if (this.getSinkCompression() == Compress.DISABLE) {
            conf.setBoolean("mapred.output.compress", false);
        } else if (this.getSinkCompression() == Compress.ENABLE) {
            conf.setBoolean("mapred.output.compress", true);
        }
        conf.setClass("mapred.output.key.class", Text.class, Object.class);
        conf.setClass("mapred.output.value.class", Text.class, Object.class);
        conf.setClass("mapred.output.format.class", TextOutputFormat.class, OutputFormat.class);
    }

    public void sourcePrepare(FlowProcess<? extends Configuration> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        if (sourceCall.getContext() == null) {
            sourceCall.setContext((Object)new Object[3]);
        }
        ((Object[])sourceCall.getContext())[0] = ((RecordReader)sourceCall.getInput()).createKey();
        ((Object[])sourceCall.getContext())[1] = ((RecordReader)sourceCall.getInput()).createValue();
        ((Object[])sourceCall.getContext())[2] = Charset.forName(this.charsetName);
    }

    public boolean source(FlowProcess<? extends Configuration> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        if (!this.sourceReadInput(sourceCall)) {
            return false;
        }
        this.sourceHandleInput(sourceCall);
        return true;
    }

    private boolean sourceReadInput(SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Object[] context = (Object[])sourceCall.getContext();
        return ((RecordReader)sourceCall.getInput()).next(context[0], context[1]);
    }

    protected void sourceHandleInput(SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        TupleEntry result = sourceCall.getIncomingEntry();
        int index = 0;
        Object[] context = (Object[])sourceCall.getContext();
        if (this.getSourceFields().size() == 2) {
            result.setLong((Comparable)Integer.valueOf(index++), ((LongWritable)context[0]).get());
        }
        result.setString((Comparable)Integer.valueOf(index), this.makeEncodedString(context));
    }

    protected String makeEncodedString(Object[] context) {
        Text text = (Text)context[1];
        return new String(text.getBytes(), 0, text.getLength(), (Charset)context[2]);
    }

    public void sourceCleanup(FlowProcess<? extends Configuration> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        sourceCall.setContext(null);
    }

    public void sinkPrepare(FlowProcess<? extends Configuration> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        sinkCall.setContext((Object)new Object[2]);
        ((Object[])sinkCall.getContext())[0] = new Text();
        ((Object[])sinkCall.getContext())[1] = Charset.forName(this.charsetName);
    }

    public void sink(FlowProcess<? extends Configuration> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        Text text = (Text)((Object[])sinkCall.getContext())[0];
        Charset charset = (Charset)((Object[])sinkCall.getContext())[1];
        String line = sinkCall.getOutgoingEntry().getTuple().toString();
        text.set(line.getBytes(charset));
        ((OutputCollector)sinkCall.getOutput()).collect(null, (Object)text);
    }

    public String getExtension() {
        return "txt";
    }

    public static enum Compress {
        DEFAULT,
        ENABLE,
        DISABLE;

    }
}

