/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.tuple.hadoop.SerializationToken;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

@SerializationToken(tokens={125}, classNames={"java.math.BigDecimal"})
public class BigDecimalSerialization
extends Configured
implements Serialization<BigDecimal> {
    public boolean accept(Class<?> c) {
        return BigDecimal.class == c;
    }

    public Serializer<BigDecimal> getSerializer(Class<BigDecimal> c) {
        return new BigDecimalSerializer();
    }

    public Deserializer<BigDecimal> getDeserializer(Class<BigDecimal> c) {
        return new BigDecimalDeserializer();
    }

    public static class BigDecimalSerializer
    implements Serializer<BigDecimal> {
        private DataOutputStream out;

        public void open(OutputStream out) throws IOException {
            this.out = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        }

        public void serialize(BigDecimal bigDecimal) throws IOException {
            BigInteger value = bigDecimal.unscaledValue();
            byte[] valueBytes = value.toByteArray();
            this.out.writeInt(valueBytes.length);
            this.out.write(valueBytes);
            this.out.writeInt(bigDecimal.scale());
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    public static class BigDecimalDeserializer
    implements Deserializer<BigDecimal> {
        private DataInputStream in;

        public void open(InputStream in) throws IOException {
            this.in = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        }

        public BigDecimal deserialize(BigDecimal existing) throws IOException {
            int len = this.in.readInt();
            byte[] valueBytes = new byte[len];
            this.in.readFully(valueBytes);
            BigInteger value = new BigInteger(valueBytes);
            return new BigDecimal(value, this.in.readInt());
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

