/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.util;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.scheme.hadoop.SequenceFile;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.lib.NullOutputFormat;

public class TempHfs
extends Hfs {
    final String name;
    private Class<? extends Scheme> schemeClass;

    public TempHfs(Configuration conf, String name, boolean isNull) {
        super(isNull ? new NullScheme() : new SequenceFile(){});
        this.name = name;
        this.stringPath = this.initTemporaryPath(conf, true);
    }

    public TempHfs(Configuration conf, String name, Class<? extends Scheme> schemeClass) {
        this(conf, name, schemeClass, true);
    }

    public TempHfs(Configuration conf, String name, Class<? extends Scheme> schemeClass, boolean unique) {
        this.name = name;
        this.schemeClass = schemeClass == null ? SequenceFile.class : schemeClass;
        this.stringPath = this.initTemporaryPath(conf, unique);
    }

    public Class<? extends Scheme> getSchemeClass() {
        return this.schemeClass;
    }

    private String initTemporaryPath(Configuration conf, boolean unique) {
        String child = unique ? this.makeTemporaryPathDirString(this.name) : this.name;
        return new Path(TempHfs.getTempPath(conf), child).toString();
    }

    public Scope outgoingScopeFor(Set<Scope> incomingScopes) {
        Fields fields = incomingScopes.iterator().next().getIncomingTapFields();
        this.setSchemeUsing(fields);
        return new Scope(fields);
    }

    private void setSchemeUsing(Fields fields) {
        try {
            this.setScheme(this.schemeClass.getConstructor(Fields.class).newInstance(fields));
        }
        catch (Exception exception) {
            throw new CascadingException("unable to create specified scheme: " + this.schemeClass.getName(), (Throwable)exception);
        }
    }

    public boolean isTemporary() {
        return true;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[\"" + this.getScheme() + "\"][" + this.name + "]";
    }

    private static class NullScheme
    extends Scheme<Configuration, RecordReader, OutputCollector, Object, Object> {
        private NullScheme() {
        }

        public void sourceConfInit(FlowProcess<? extends Configuration> flowProcess, Tap<Configuration, RecordReader, OutputCollector> tap, Configuration conf) {
        }

        public void sinkConfInit(FlowProcess<? extends Configuration> flowProcess, Tap<Configuration, RecordReader, OutputCollector> tap, Configuration conf) {
            conf.setClass("mapred.output.key.class", Tuple.class, Object.class);
            conf.setClass("mapred.output.value.class", Tuple.class, Object.class);
            conf.setClass("mapred.output.format.class", NullOutputFormat.class, OutputFormat.class);
        }

        public boolean source(FlowProcess<? extends Configuration> flowProcess, SourceCall<Object, RecordReader> sourceCall) throws IOException {
            return false;
        }

        public void sink(FlowProcess<? extends Configuration> flowProcess, SinkCall<Object, OutputCollector> sinkCall) throws IOException {
        }
    }
}

