/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.util;

import cascading.flow.hadoop.util.HadoopUtil;
import cascading.tap.Tap;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hadoop18TapUtil {
    private static final Logger LOG = LoggerFactory.getLogger(Hadoop18TapUtil.class);
    public static final String TEMPORARY_PATH = "_temporary";
    private static final Map<String, AtomicInteger> pathCounts = new HashMap<String, AtomicInteger>();

    public static void setupJob(Configuration conf) throws IOException {
        Path outputPath = FileOutputFormat.getOutputPath((JobConf)HadoopUtil.asJobConfInstance(conf));
        if (outputPath == null) {
            return;
        }
        if (Hadoop18TapUtil.getFSSafe(conf, outputPath) == null) {
            return;
        }
        String taskID = conf.get("mapred.task.id", conf.get("mapreduce.task.id"));
        if (taskID == null) {
            String mapper = conf.getBoolean("mapred.task.is.map", conf.getBoolean("mapreduce.task.is.map", true)) ? "m" : "r";
            String value = String.format("attempt_%012d_0000_%s_000000_0", (int)Math.rint(System.currentTimeMillis()), mapper);
            conf.set("mapred.task.id", value);
            conf.set("mapreduce.task.id", value);
        }
        Hadoop18TapUtil.makeTempPath(conf);
        if (Hadoop18TapUtil.writeDirectlyToWorkingPath(conf, outputPath)) {
            LOG.info("writing directly to output path: {}", (Object)outputPath);
            Hadoop18TapUtil.setWorkOutputPath(conf, outputPath);
            return;
        }
        Path taskOutputPath = Hadoop18TapUtil.getTaskOutputPath(conf);
        Hadoop18TapUtil.setWorkOutputPath(conf, taskOutputPath);
    }

    public static synchronized void setupTask(Configuration conf) throws IOException {
        String workpath = conf.get("mapred.work.output.dir");
        if (workpath == null) {
            return;
        }
        FileSystem fs = Hadoop18TapUtil.getFSSafe(conf, new Path(workpath));
        if (fs == null) {
            return;
        }
        String taskId = conf.get("mapred.task.id", conf.get("mapreduce.task.id"));
        LOG.info("setting up task: '{}' - {}", (Object)taskId, (Object)workpath);
        AtomicInteger integer = pathCounts.get(workpath);
        if (integer == null) {
            integer = new AtomicInteger();
            pathCounts.put(workpath, integer);
        }
        integer.incrementAndGet();
    }

    public static boolean needsTaskCommit(Configuration conf) throws IOException {
        String workpath = conf.get("mapred.work.output.dir");
        if (workpath == null) {
            return false;
        }
        Path taskOutputPath = new Path(workpath);
        if (taskOutputPath != null) {
            FileSystem fs = Hadoop18TapUtil.getFSSafe(conf, taskOutputPath);
            if (fs == null) {
                return false;
            }
            if (fs.exists(taskOutputPath)) {
                return true;
            }
        }
        return false;
    }

    public static boolean commitTask(Configuration conf) throws IOException {
        Path taskOutputPath = new Path(conf.get("mapred.work.output.dir"));
        FileSystem fs = Hadoop18TapUtil.getFSSafe(conf, taskOutputPath);
        if (fs == null) {
            return false;
        }
        AtomicInteger integer = pathCounts.get(taskOutputPath.toString());
        if (integer.decrementAndGet() != 0) {
            return false;
        }
        String taskId = conf.get("mapred.task.id", conf.get("mapreduce.task.id"));
        LOG.info("committing task: '{}' - {}", (Object)taskId, (Object)taskOutputPath);
        if (taskOutputPath != null) {
            if (Hadoop18TapUtil.writeDirectlyToWorkingPath(conf, taskOutputPath)) {
                return true;
            }
            if (fs.exists(taskOutputPath)) {
                Path jobOutputPath = taskOutputPath.getParent().getParent();
                Hadoop18TapUtil.moveTaskOutputs(conf, fs, jobOutputPath, taskOutputPath);
                if (!fs.delete(taskOutputPath, true)) {
                    LOG.info("failed to delete the temporary output directory of task: '{}' - {}", (Object)taskId, (Object)taskOutputPath);
                }
                LOG.info("saved output of task '{}' to {}", (Object)taskId, (Object)jobOutputPath);
            }
        }
        return true;
    }

    public static void cleanupTapMetaData(Configuration conf, Tap tap) throws IOException {
        Hadoop18TapUtil.cleanTempPath(conf, new Path(tap.getIdentifier()));
    }

    public static void writeSuccessMarker(Configuration conf) throws IOException {
        Hadoop18TapUtil.writeSuccessMarker(conf, FileOutputFormat.getOutputPath((JobConf)HadoopUtil.asJobConfInstance(conf)));
    }

    public static void writeSuccessMarker(Configuration conf, Path outputPath) throws IOException {
        if (conf.getBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", true)) {
            LOG.info("writing success marker to {}", (Object)outputPath);
            Path markerPath = new Path(outputPath, "_SUCCESS");
            FileSystem fs = markerPath.getFileSystem(conf);
            fs.create(markerPath).close();
        }
    }

    public static void cleanupJob(Configuration conf) throws IOException {
        if (HadoopUtil.isInflow(conf)) {
            return;
        }
        Path outputPath = FileOutputFormat.getOutputPath((JobConf)HadoopUtil.asJobConfInstance(conf));
        Hadoop18TapUtil.cleanTempPath(conf, outputPath);
    }

    private static synchronized void cleanTempPath(Configuration conf, Path outputPath) throws IOException {
        if (outputPath != null) {
            FileSystem fileSys = Hadoop18TapUtil.getFSSafe(conf, outputPath);
            if (fileSys == null) {
                return;
            }
            if (!fileSys.exists(outputPath)) {
                return;
            }
            Path tmpDir = new Path(outputPath, TEMPORARY_PATH);
            LOG.info("deleting temp path {}", (Object)tmpDir);
            if (fileSys.exists(tmpDir)) {
                fileSys.delete(tmpDir, true);
            }
        }
    }

    private static FileSystem getFSSafe(Configuration conf, Path tmpDir) {
        try {
            return tmpDir.getFileSystem(conf);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Path getTaskOutputPath(Configuration conf) {
        String taskId = conf.get("mapred.task.id", conf.get("mapreduce.task.id"));
        Path p = new Path(FileOutputFormat.getOutputPath((JobConf)HadoopUtil.asJobConfInstance(conf)), "_temporary/_" + taskId);
        try {
            FileSystem fs = p.getFileSystem(conf);
            return p.makeQualified(fs);
        }
        catch (IOException ie) {
            return p;
        }
    }

    static void setWorkOutputPath(Configuration conf, Path outputDir) {
        outputDir = new Path(HadoopUtil.asJobConfInstance(conf).getWorkingDirectory(), outputDir);
        conf.set("mapred.work.output.dir", outputDir.toString());
    }

    public static void makeTempPath(Configuration conf) throws IOException {
        Path tmpDir;
        FileSystem fileSys;
        Path outputPath = FileOutputFormat.getOutputPath((JobConf)HadoopUtil.asJobConfInstance(conf));
        if (outputPath != null && !(fileSys = (tmpDir = new Path(outputPath, TEMPORARY_PATH)).getFileSystem(conf)).exists(tmpDir) && !fileSys.mkdirs(tmpDir)) {
            LOG.error("mkdirs failed to create {}", (Object)tmpDir);
        }
    }

    private static void moveTaskOutputs(Configuration conf, FileSystem fs, Path jobOutputDir, Path taskOutput) throws IOException {
        String taskId = conf.get("mapred.task.id", conf.get("mapreduce.task.id"));
        if (fs.isFile(taskOutput)) {
            Path finalOutputPath = Hadoop18TapUtil.getFinalPath(jobOutputDir, taskOutput, Hadoop18TapUtil.getTaskOutputPath(conf));
            if (!fs.rename(taskOutput, finalOutputPath)) {
                if (!fs.delete(finalOutputPath, true)) {
                    throw new IOException("Failed to delete earlier output of task: " + taskId);
                }
                if (!fs.rename(taskOutput, finalOutputPath)) {
                    throw new IOException("Failed to save output of task: " + taskId);
                }
            }
            LOG.debug("Moved {} to {}", (Object)taskOutput, (Object)finalOutputPath);
        } else if (fs.getFileStatus(taskOutput).isDir()) {
            FileStatus[] paths = fs.listStatus(taskOutput);
            Path finalOutputPath = Hadoop18TapUtil.getFinalPath(jobOutputDir, taskOutput, Hadoop18TapUtil.getTaskOutputPath(conf));
            fs.mkdirs(finalOutputPath);
            if (paths != null) {
                for (FileStatus path : paths) {
                    Hadoop18TapUtil.moveTaskOutputs(conf, fs, jobOutputDir, path.getPath());
                }
            }
        }
    }

    private static Path getFinalPath(Path jobOutputDir, Path taskOutput, Path taskOutputPath) throws IOException {
        URI relativePath;
        URI taskOutputUri = taskOutput.toUri();
        if (taskOutputUri == (relativePath = taskOutputPath.toUri().relativize(taskOutputUri))) {
            throw new IOException("Can not get the relative path: base = " + taskOutputPath + " child = " + taskOutput);
        }
        if (relativePath.getPath().length() > 0) {
            return new Path(jobOutputDir, relativePath.getPath());
        }
        return jobOutputDir;
    }

    private static boolean writeDirectlyToWorkingPath(Configuration conf, Path path) {
        FileSystem fs = Hadoop18TapUtil.getFSSafe(conf, path);
        if (fs == null) {
            return false;
        }
        boolean result = conf.getBoolean("mapred.output.direct." + fs.getClass().getSimpleName(), false);
        if (result) {
            LOG.info("output direct is enabled for this fs: " + fs.getName());
        }
        return result;
    }
}

