/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.scheme.Scheme;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.hadoop.io.CombineFileRecordReaderWrapper;
import cascading.tap.hadoop.io.HadoopTupleEntrySchemeCollector;
import cascading.tap.hadoop.io.HadoopTupleEntrySchemeIterator;
import cascading.tap.type.FileType;
import cascading.tap.type.TapWith;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.util.LazyIterable;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileInputFormat;
import org.apache.hadoop.mapred.lib.CombineFileRecordReader;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hfs
extends Tap<Configuration, RecordReader, OutputCollector>
implements FileType<Configuration>,
TapWith<Configuration, RecordReader, OutputCollector> {
    private static final Logger LOG = LoggerFactory.getLogger(Hfs.class);
    protected String stringPath;
    transient URI uriScheme;
    transient Path path;
    private transient FileStatus[] statuses;
    private transient String cachedPath = null;
    private static final PathFilter HIDDEN_FILES_FILTER = path -> {
        String name = path.getName();
        if (name.isEmpty()) {
            return true;
        }
        char first = name.charAt(0);
        return first != '_' && first != '.';
    };

    protected static String getLocalModeScheme(Configuration conf, String defaultValue) {
        return conf.get("cascading.hadoop.localmode.scheme", defaultValue);
    }

    protected static boolean getUseCombinedInput(Configuration conf) {
        String platform;
        boolean combineEnabled = conf.getBoolean("cascading.hadoop.hfs.combine.files", false);
        if (conf.get("cascading.flow.runtime.splits.combine") == null && !combineEnabled) {
            return false;
        }
        if (!combineEnabled) {
            combineEnabled = conf.getBoolean("cascading.flow.runtime.splits.combine", false);
        }
        if ((platform = conf.get("cascading.flow.platform", "")).equals("hadoop") || platform.equals("hadoop2-mr1")) {
            return combineEnabled;
        }
        if (conf.get("cascading.flow.runtime.splits.combine") != null) {
            return false;
        }
        if (combineEnabled && !Boolean.getBoolean("cascading.hadoop.hfs.combine.files.warned")) {
            LOG.warn("'cascading.hadoop.hfs.combine.files' has been set to true, but is unsupported by this platform: {}, will be ignored to prevent failures", (Object)platform);
            System.setProperty("cascading.hadoop.hfs.combine.files.warned", "true");
        }
        return false;
    }

    protected static boolean getCombinedInputSafeMode(Configuration conf) {
        return conf.getBoolean("cascading.hadoop.hfs.combine.safemode", true);
    }

    protected Hfs() {
    }

    @ConstructorProperties(value={"scheme"})
    protected Hfs(Scheme<Configuration, RecordReader, OutputCollector, ?, ?> scheme) {
        super(scheme);
    }

    @ConstructorProperties(value={"scheme", "stringPath"})
    public Hfs(Scheme<Configuration, RecordReader, OutputCollector, ?, ?> scheme, String stringPath) {
        super(scheme);
        this.setStringPath(stringPath);
    }

    @ConstructorProperties(value={"scheme", "stringPath", "sinkMode"})
    public Hfs(Scheme<Configuration, RecordReader, OutputCollector, ?, ?> scheme, String stringPath, SinkMode sinkMode) {
        super(scheme, sinkMode);
        this.setStringPath(stringPath);
    }

    @ConstructorProperties(value={"scheme", "path"})
    public Hfs(Scheme<Configuration, RecordReader, OutputCollector, ?, ?> scheme, Path path) {
        super(scheme);
        this.setStringPath(path.toString());
    }

    @ConstructorProperties(value={"scheme", "path", "sinkMode"})
    public Hfs(Scheme<Configuration, RecordReader, OutputCollector, ?, ?> scheme, Path path, SinkMode sinkMode) {
        super(scheme, sinkMode);
        this.setStringPath(path.toString());
    }

    public TapWith<Configuration, RecordReader, OutputCollector> withChildIdentifier(String identifier) {
        Path path = new Path(identifier);
        if (!path.toString().startsWith(this.getPath().toString())) {
            path = new Path(this.getPath(), path);
        }
        return this.create(this.getScheme(), path, this.getSinkMode());
    }

    public TapWith<Configuration, RecordReader, OutputCollector> withScheme(Scheme<Configuration, RecordReader, OutputCollector, ?, ?> scheme) {
        return this.create(scheme, this.getPath(), this.getSinkMode());
    }

    public TapWith<Configuration, RecordReader, OutputCollector> withSinkMode(SinkMode sinkMode) {
        return this.create(this.getScheme(), this.getPath(), sinkMode);
    }

    protected TapWith<Configuration, RecordReader, OutputCollector> create(Scheme<Configuration, RecordReader, OutputCollector, ?, ?> scheme, Path path, SinkMode sinkMode) {
        try {
            return (TapWith)Util.newInstance(((Object)((Object)this)).getClass(), (Object[])new Object[]{scheme, path, sinkMode});
        }
        catch (CascadingException exception) {
            throw new TapException("unable to create a new instance of: " + ((Object)((Object)this)).getClass().getName(), (Throwable)exception);
        }
    }

    protected void setStringPath(String stringPath) {
        this.stringPath = Util.normalizeUrl((String)stringPath);
    }

    protected void setUriScheme(URI uriScheme) {
        this.uriScheme = uriScheme;
    }

    public URI getURIScheme(Configuration jobConf) {
        if (this.uriScheme != null) {
            return this.uriScheme;
        }
        this.uriScheme = this.makeURIScheme(jobConf);
        return this.uriScheme;
    }

    protected URI makeURIScheme(Configuration configuration) {
        try {
            LOG.debug("handling path: {}", (Object)this.stringPath);
            URI uri = new Path(this.stringPath).toUri();
            String schemeString = uri.getScheme();
            String authority = uri.getAuthority();
            LOG.debug("found scheme: {}, authority: {}", (Object)schemeString, (Object)authority);
            URI uriScheme = schemeString != null && authority != null ? new URI(schemeString + "://" + uri.getAuthority()) : (schemeString != null ? new URI(schemeString + ":///") : this.getDefaultFileSystemURIScheme(configuration));
            LOG.debug("using uri scheme: {}", (Object)uriScheme);
            return uriScheme;
        }
        catch (URISyntaxException exception) {
            throw new TapException("could not determine scheme from path: " + this.getPath(), (Throwable)exception);
        }
    }

    public URI getDefaultFileSystemURIScheme(Configuration configuration) {
        return this.getDefaultFileSystem(configuration).getUri();
    }

    protected FileSystem getDefaultFileSystem(Configuration configuration) {
        try {
            return FileSystem.get((Configuration)configuration);
        }
        catch (IOException exception) {
            throw new TapException("unable to get handle to underlying filesystem", (Throwable)exception);
        }
    }

    protected FileSystem getFileSystem(Configuration configuration) {
        URI scheme = this.getURIScheme(configuration);
        try {
            return FileSystem.get((URI)scheme, (Configuration)configuration);
        }
        catch (IOException exception) {
            throw new TapException("unable to get handle to get filesystem for: " + scheme.getScheme(), (Throwable)exception);
        }
    }

    public String getIdentifier() {
        if (this.cachedPath == null) {
            this.cachedPath = this.getPath().toString();
        }
        return this.cachedPath;
    }

    public Path getPath() {
        if (this.path != null) {
            return this.path;
        }
        if (this.stringPath == null) {
            throw new IllegalStateException("path not initialized");
        }
        this.path = new Path(this.stringPath);
        return this.path;
    }

    public String getFullIdentifier(Configuration conf) {
        return this.getPath().makeQualified(this.getFileSystem(conf)).toString();
    }

    public void sourceConfInit(FlowProcess<? extends Configuration> process, Configuration conf) {
        String fullIdentifier = this.getFullIdentifier(conf);
        this.applySourceConfInitIdentifiers(process, conf, fullIdentifier);
        Hfs.verifyNoDuplicates(conf);
    }

    protected static void verifyNoDuplicates(Configuration conf) {
        Path[] inputPaths = FileInputFormat.getInputPaths((JobConf)HadoopUtil.asJobConfInstance(conf));
        HashSet<Path> paths = new HashSet<Path>((int)((float)inputPaths.length / 0.75f));
        for (Path inputPath : inputPaths) {
            if (paths.add(inputPath)) continue;
            throw new TapException("may not add duplicate paths, found: " + inputPath);
        }
    }

    protected void applySourceConfInitIdentifiers(FlowProcess<? extends Configuration> process, Configuration conf, String ... fullIdentifiers) {
        this.sourceConfInitAddInputPaths(conf, (Iterable<Path>)new LazyIterable<String, Path>(fullIdentifiers){

            protected Path convert(String next) {
                return new Path(next);
            }
        });
        this.sourceConfInitComplete(process, conf);
    }

    protected void sourceConfInitAddInputPaths(Configuration conf, Iterable<Path> qualifiedPaths) {
        Path qualifiedPath;
        boolean stop;
        HadoopUtil.addInputPaths(conf, qualifiedPaths);
        Iterator<Path> iterator = qualifiedPaths.iterator();
        while (iterator.hasNext() && !(stop = !this.makeLocal(conf, qualifiedPath = iterator.next(), "forcing job to stand-alone mode, via source: "))) {
        }
    }

    @Deprecated
    protected void sourceConfInitAddInputPath(Configuration conf, Path qualifiedPath) {
        HadoopUtil.addInputPath(conf, qualifiedPath);
        this.makeLocal(conf, qualifiedPath, "forcing job to stand-alone mode, via source: ");
    }

    protected void sourceConfInitComplete(FlowProcess<? extends Configuration> process, Configuration conf) {
        super.sourceConfInit(process, (Object)conf);
        TupleSerialization.setSerializations(conf);
        this.handleCombineFileInputFormat(conf);
    }

    private void handleCombineFileInputFormat(Configuration conf) {
        if (!Hfs.getUseCombinedInput(conf)) {
            return;
        }
        String individualInputFormat = conf.get("mapred.input.format.class");
        if (individualInputFormat == null) {
            throw new TapException("input format is missing from the underlying scheme");
        }
        if (individualInputFormat.equals(CombinedInputFormat.class.getName()) && conf.get("cascading.individual.input.format") == null) {
            throw new TapException("the input format class is already the combined input format but the underlying input format is missing");
        }
        boolean safeMode = Hfs.getCombinedInputSafeMode(conf);
        if (!FileInputFormat.class.isAssignableFrom(conf.getClass("mapred.input.format.class", null))) {
            if (safeMode) {
                throw new TapException("input format must be of type org.apache.hadoop.mapred.FileInputFormat, got: " + individualInputFormat);
            }
            LOG.warn("not combining input splits with CombineFileInputFormat, {} is not of type org.apache.hadoop.mapred.FileInputFormat.", (Object)individualInputFormat);
        } else {
            conf.set("cascading.individual.input.format", individualInputFormat);
            conf.setClass("mapred.input.format.class", CombinedInputFormat.class, InputFormat.class);
        }
    }

    public void sinkConfInit(FlowProcess<? extends Configuration> process, Configuration conf) {
        Path qualifiedPath = new Path(this.getFullIdentifier(conf));
        HadoopUtil.setOutputPath(conf, qualifiedPath);
        super.sinkConfInit(process, (Object)conf);
        this.makeLocal(conf, qualifiedPath, "forcing job to stand-alone mode, via sink: ");
        TupleSerialization.setSerializations(conf);
    }

    private boolean makeLocal(Configuration conf, Path qualifiedPath, String infoMessage) {
        if (HadoopUtil.isInflow(conf)) {
            return false;
        }
        String scheme = Hfs.getLocalModeScheme(conf, "file");
        if (!HadoopUtil.isLocal(conf) && qualifiedPath.toUri().getScheme().equalsIgnoreCase(scheme)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(infoMessage + this.toString());
            }
            HadoopUtil.setLocal(conf);
            return false;
        }
        return true;
    }

    public TupleEntryIterator openForRead(FlowProcess<? extends Configuration> flowProcess, RecordReader input) throws IOException {
        return new HadoopTupleEntrySchemeIterator(flowProcess, this, input);
    }

    public TupleEntryCollector openForWrite(FlowProcess<? extends Configuration> flowProcess, OutputCollector output) throws IOException {
        this.resetFileStatuses();
        return new HadoopTupleEntrySchemeCollector(flowProcess, this, output);
    }

    public boolean createResource(Configuration conf) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("making dirs: {}", (Object)this.getFullIdentifier(conf));
        }
        return this.getFileSystem(conf).mkdirs(this.getPath());
    }

    public boolean deleteResource(Configuration conf) throws IOException {
        String fullIdentifier = this.getFullIdentifier(conf);
        return this.deleteFullIdentifier(conf, fullIdentifier);
    }

    private boolean deleteFullIdentifier(Configuration conf, String fullIdentifier) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("deleting: {}", (Object)fullIdentifier);
        }
        this.resetFileStatuses();
        Path fullPath = new Path(fullIdentifier);
        if (fullPath.depth() == 0) {
            return true;
        }
        FileSystem fileSystem = this.getFileSystem(conf);
        try {
            return fileSystem.delete(fullPath, true);
        }
        catch (NullPointerException exception) {
            if (!fileSystem.getClass().getSimpleName().equals("NativeS3FileSystem")) {
                throw exception;
            }
            return true;
        }
    }

    public boolean deleteChildResource(FlowProcess<? extends Configuration> flowProcess, String childIdentifier) throws IOException {
        return this.deleteChildResource((Configuration)flowProcess.getConfig(), childIdentifier);
    }

    public boolean deleteChildResource(Configuration conf, String childIdentifier) throws IOException {
        this.resetFileStatuses();
        Path childPath = new Path(childIdentifier).makeQualified(this.getFileSystem(conf));
        if (!childPath.toString().startsWith(this.getFullIdentifier(conf))) {
            return false;
        }
        return this.deleteFullIdentifier(conf, childPath.toString());
    }

    public boolean resourceExists(Configuration conf) throws IOException {
        FileStatus[] fileStatuses = this.getFileSystem(conf).globStatus(this.getPath());
        return fileStatuses != null && fileStatuses.length > 0;
    }

    public boolean isDirectory(FlowProcess<? extends Configuration> flowProcess) throws IOException {
        return this.isDirectory((Configuration)flowProcess.getConfig());
    }

    public boolean isDirectory(Configuration conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return false;
        }
        return this.getFileSystem(conf).getFileStatus(this.getPath()).isDir();
    }

    public long getSize(FlowProcess<? extends Configuration> flowProcess) throws IOException {
        return this.getSize((Configuration)flowProcess.getConfig());
    }

    public long getSize(Configuration conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return 0L;
        }
        FileStatus fileStatus = this.getFileStatus(conf);
        if (fileStatus.isDir()) {
            return 0L;
        }
        return this.getFileSystem(conf).getFileStatus(this.getPath()).getLen();
    }

    public long getBlockSize(FlowProcess<? extends Configuration> flowProcess) throws IOException {
        return this.getBlockSize((Configuration)flowProcess.getConfig());
    }

    public long getBlockSize(Configuration conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return 0L;
        }
        FileStatus fileStatus = this.getFileStatus(conf);
        if (fileStatus.isDir()) {
            return 0L;
        }
        return fileStatus.getBlockSize();
    }

    public int getReplication(FlowProcess<? extends Configuration> flowProcess) throws IOException {
        return this.getReplication((Configuration)flowProcess.getConfig());
    }

    public int getReplication(Configuration conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return 0;
        }
        FileStatus fileStatus = this.getFileStatus(conf);
        if (fileStatus.isDir()) {
            return 0;
        }
        return fileStatus.getReplication();
    }

    public String[] getChildIdentifiers(FlowProcess<? extends Configuration> flowProcess) throws IOException {
        return this.getChildIdentifiers((Configuration)flowProcess.getConfig(), 1, false);
    }

    public String[] getChildIdentifiers(Configuration conf) throws IOException {
        return this.getChildIdentifiers(conf, 1, false);
    }

    public String[] getChildIdentifiers(FlowProcess<? extends Configuration> flowProcess, int depth, boolean fullyQualified) throws IOException {
        return this.getChildIdentifiers((Configuration)flowProcess.getConfig(), depth, fullyQualified);
    }

    public String[] getChildIdentifiers(Configuration conf, int depth, boolean fullyQualified) throws IOException {
        if (!this.resourceExists(conf)) {
            return new String[0];
        }
        if (depth == 0 && !fullyQualified) {
            return new String[]{this.getIdentifier()};
        }
        String fullIdentifier = this.getFullIdentifier(conf);
        int trim = fullyQualified ? 0 : fullIdentifier.length() + 1;
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        this.getChildPaths(conf, results, trim, new Path(fullIdentifier), depth);
        return results.toArray(new String[results.size()]);
    }

    private void getChildPaths(Configuration conf, Set<String> results, int trim, Path path, int depth) throws IOException {
        if (depth == 0) {
            String substring = path.toString().substring(trim);
            String identifier = this.getIdentifier();
            if (identifier == null || identifier.isEmpty()) {
                results.add(new Path(substring).toString());
            } else {
                results.add(new Path(identifier, substring).toString());
            }
            return;
        }
        FileStatus[] statuses = this.getFileSystem(conf).listStatus(path, HIDDEN_FILES_FILTER);
        if (statuses == null) {
            return;
        }
        for (FileStatus fileStatus : statuses) {
            this.getChildPaths(conf, results, trim, fileStatus.getPath(), depth - 1);
        }
    }

    public long getModifiedTime(Configuration conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return 0L;
        }
        FileStatus fileStatus = this.getFileStatus(conf);
        if (!fileStatus.isDir()) {
            return fileStatus.getModificationTime();
        }
        this.makeStatuses(conf);
        if (this.statuses == null || this.statuses.length == 0) {
            return 0L;
        }
        long date = 0L;
        for (FileStatus status : this.statuses) {
            if (status.isDir()) continue;
            date = Math.max(date, status.getModificationTime());
        }
        return date;
    }

    public FileStatus getFileStatus(Configuration conf) throws IOException {
        return this.getFileSystem(conf).getFileStatus(this.getPath());
    }

    public static Path getTempPath(Configuration conf) {
        String tempDir = conf.get("cascading.tmp.dir");
        if (tempDir == null) {
            tempDir = conf.get("hadoop.tmp.dir");
        }
        return new Path(tempDir);
    }

    protected String makeTemporaryPathDirString(String name) {
        if ((name = name.replaceAll("^[_\\W\\s]+", "")).isEmpty()) {
            name = "temp-path";
        }
        return name.replaceAll("[\\W\\s]+", "_") + Util.createUniqueID();
    }

    private void makeStatuses(Configuration conf) throws IOException {
        if (this.statuses != null) {
            return;
        }
        this.statuses = this.getFileSystem(conf).listStatus(this.getPath());
    }

    public void resetFileStatuses() {
        this.statuses = null;
    }

    static class CombinedInputFormat
    extends CombineFileInputFormat
    implements Configurable {
        private Configuration conf;

        CombinedInputFormat() {
        }

        public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return new CombineFileRecordReader(job, (CombineFileSplit)split, reporter, CombineFileRecordReaderWrapper.class);
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
            this.setMaxSplitSize(conf.getLong("cascading.hadoop.hfs.combine.max.size", 0L));
        }

        public Configuration getConf() {
            return this.conf;
        }
    }
}

