/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.util;

import cascading.tuple.Hasher;
import cascading.tuple.Tuple;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.util.DeserializerComparator;
import cascading.tuple.util.TupleHasher;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;

public class HasherPartitioner
extends TupleHasher
implements Configurable {
    public static final String HASHER_PARTITIONER_USE_LEGACY_HASH = "cascading.tuple.hadoop.util.hasherpartitioner.uselegacyhash";
    private static Comparator defaultComparator;
    private Comparator[] comparators;
    private Configuration conf;

    public void setConf(Configuration conf) {
        if (this.conf != null) {
            return;
        }
        this.conf = conf;
        defaultComparator = TupleSerialization.getDefaultComparator((Comparator)defaultComparator, (Configuration)conf);
        this.comparators = DeserializerComparator.getFieldComparatorsFrom(conf, "cascading.group.comparator");
        if (conf.getBoolean(HASHER_PARTITIONER_USE_LEGACY_HASH, false)) {
            this.hashFunction = new LegacyHashFunction();
        }
        this.initialize(defaultComparator, this.comparators);
    }

    public Configuration getConf() {
        return this.conf;
    }

    static class LegacyHashFunction
    extends TupleHasher.HashFunction {
        LegacyHashFunction() {
        }

        public int hash(Tuple tuple, Hasher[] hashers) {
            int hash = 1;
            List elements = Tuple.elements((Tuple)tuple);
            for (int i = 0; i < elements.size(); ++i) {
                Object element = elements.get(i);
                hash = 31 * hash + (element != null ? hashers[i % hashers.length].hashCode(element) : 0);
            }
            return hash;
        }
    }
}

