/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.util;

import cascading.CascadingException;
import cascading.tuple.hadoop.util.DeserializerComparator;
import cascading.tuple.io.TuplePair;
import java.io.IOException;
import java.util.Comparator;
import org.apache.hadoop.conf.Configuration;

public class GroupingSortingComparator
extends DeserializerComparator<TuplePair> {
    Class[] sortTypes;
    Comparator[] sortComparators;

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        this.sortTypes = this.tupleSerialization.getSortTypes();
        this.sortComparators = this.deserializeComparatorsFor("cascading.sort.comparator");
        this.sortComparators = this.delegatingComparatorsFor(this.sortTypes, this.sortComparators);
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        try {
            this.lhsBuffer.reset(b1, s1, l1);
            this.rhsBuffer.reset(b2, s2, l2);
            int c = this.compareTuples(this.keyTypes, this.groupComparators);
            if (c != 0) {
                int n = c;
                return n;
            }
            int n = this.compareTuples(this.sortTypes, this.sortComparators);
            return n;
        }
        catch (IOException exception) {
            throw new CascadingException((Throwable)exception);
        }
        finally {
            this.lhsBuffer.clear();
            this.rhsBuffer.clear();
        }
    }

    public int compare(TuplePair lhs, TuplePair rhs) {
        int c = this.compareTuples(this.groupComparators, lhs.getLhs(), rhs.getLhs());
        if (c != 0) {
            return c;
        }
        return this.compareTuples(this.sortComparators, lhs.getRhs(), rhs.getRhs());
    }
}

