/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.PlatformTestCase;
import cascading.tuple.Tuple;
import cascading.tuple.hadoop.TestSerialization;
import cascading.tuple.hadoop.TestText;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.io.HadoopTupleInputStream;
import cascading.tuple.hadoop.io.HadoopTupleOutputStream;
import cascading.tuple.io.TupleInputStream;
import cascading.tuple.io.TupleOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.serializer.WritableSerialization;
import org.junit.Test;

public class HadoopSerializationPlatformTest
extends PlatformTestCase {
    @Test
    public void testInputOutputSerialization() throws IOException {
        long time = System.currentTimeMillis();
        Configuration jobConf = new Configuration();
        jobConf.set("io.serializations", TestSerialization.class.getName() + "," + WritableSerialization.class.getName());
        jobConf.set("cascading.serialization.tokens", "1000=" + BooleanWritable.class.getName() + ",10001=" + Text.class.getName());
        TupleSerialization tupleSerialization = new TupleSerialization(jobConf);
        File file = new File(this.getOutputPath("serialization"));
        file.mkdirs();
        file = new File(file, "/test.bytes");
        HadoopTupleOutputStream output = new HadoopTupleOutputStream((OutputStream)new FileOutputStream(file, false), (TupleOutputStream.ElementWriter)tupleSerialization.getElementWriter());
        for (int i = 0; i < 501; ++i) {
            String aString = "string number " + i;
            double random = Math.random();
            output.writeTuple(new Tuple(new Object[]{i, aString, random, new TestText(aString), new Tuple(new Object[]{"inner tuple", new BytesWritable("some string".getBytes())}), new BytesWritable(Integer.toString(i).getBytes("UTF-8")), new BooleanWritable(false)}));
        }
        output.close();
        HadoopSerializationPlatformTest.assertEquals((String)"wrong size", (long)89967L, (long)file.length());
        HadoopTupleInputStream input = new HadoopTupleInputStream((InputStream)new FileInputStream(file), (TupleInputStream.ElementReader)tupleSerialization.getElementReader());
        int k = -1;
        for (int i = 0; i < 501; ++i) {
            Tuple tuple = input.readTuple();
            int value = tuple.getInteger(0);
            HadoopSerializationPlatformTest.assertTrue((String)"wrong diff", (value - k == 1 ? 1 : 0) != 0);
            HadoopSerializationPlatformTest.assertTrue((String)"wrong type", (boolean)(tuple.getObject(3) instanceof TestText));
            HadoopSerializationPlatformTest.assertTrue((String)"wrong type", (boolean)(tuple.getObject(4) instanceof Tuple));
            HadoopSerializationPlatformTest.assertTrue((String)"wrong type", (boolean)(tuple.getObject(5) instanceof BytesWritable));
            byte[] bytes = ((BytesWritable)tuple.getObject(5)).getBytes();
            String string = new String(bytes, 0, bytes.length > 1 ? bytes.length - 1 : bytes.length, "UTF-8");
            HadoopSerializationPlatformTest.assertEquals((String)"wrong value", (int)Integer.parseInt(string), (int)i);
            HadoopSerializationPlatformTest.assertTrue((String)"wrong type", (boolean)(tuple.getObject(6) instanceof BooleanWritable));
            k = value;
        }
        input.close();
        System.out.println("time = " + (System.currentTimeMillis() - time));
    }
}

