/*
 * Decompiled with CFR 0.152.
 */
package cascading.platform.hadoop;

import cascading.CascadingException;
import cascading.tuple.Hasher;
import cascading.tuple.StreamComparator;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.io.BufferedInputStream;
import cascading.tuple.hadoop.io.HadoopTupleInputStream;
import cascading.tuple.io.TupleInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Comparator;

public class TestLongComparator
implements Hasher<Long>,
StreamComparator<BufferedInputStream>,
Comparator<Long>,
Serializable {
    boolean reverse = true;

    public TestLongComparator() {
    }

    public TestLongComparator(boolean reverse) {
        this.reverse = reverse;
    }

    @Override
    public int compare(Long lhs, Long rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null) {
            return !this.reverse ? -1 : 1;
        }
        if (rhs == null) {
            return !this.reverse ? 1 : -1;
        }
        return this.reverse ? rhs.compareTo(lhs) : lhs.compareTo(rhs);
    }

    @Override
    public int compare(BufferedInputStream lhsStream, BufferedInputStream rhsStream) {
        if (lhsStream == null && rhsStream == null) {
            return 0;
        }
        if (lhsStream == null) {
            return !this.reverse ? -1 : 1;
        }
        if (rhsStream == null) {
            return !this.reverse ? 1 : -1;
        }
        HadoopTupleInputStream lhsInput = new HadoopTupleInputStream((InputStream)lhsStream, (TupleInputStream.ElementReader)new TupleSerialization().getElementReader());
        HadoopTupleInputStream rhsInput = new HadoopTupleInputStream((InputStream)rhsStream, (TupleInputStream.ElementReader)new TupleSerialization().getElementReader());
        try {
            Long l1 = lhsInput.readVLong();
            Long l2 = rhsInput.readVLong();
            return this.reverse ? l2.compareTo(l1) : l1.compareTo(l2);
        }
        catch (Exception exception) {
            throw new CascadingException((Throwable)exception);
        }
    }

    public int hashCode(Long value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }
}

