/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.expression;

import cascading.CascadingTestCase;
import cascading.flow.FlowProcess;
import cascading.operation.ConcreteCall;
import cascading.operation.OperationCall;
import cascading.operation.expression.ScriptOperation;
import cascading.operation.expression.ScriptTupleFunction;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.lang.reflect.Type;
import org.junit.Test;

public class ScriptTupleTest
extends CascadingTestCase {
    @Test
    public void testSimpleScript() {
        String[] names = new String[]{"a", "b"};
        Class[] types = new Class[]{Long.TYPE, Integer.TYPE};
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{3L}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple(a + b);", names, types, this.getEntry(Integer.valueOf(1), Integer.valueOf(2))));
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{3L}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple(a + b);", names, types, this.getEntry(Double.valueOf(1.0), Double.valueOf(2.0))));
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{3L}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple(a + b);", names, types, this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        types = new Class[]{Double.TYPE, Integer.TYPE};
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{3.0}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple(a + b);", names, types, this.getEntry(Integer.valueOf(1), Integer.valueOf(2))));
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{3.0}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple(a + b);", names, types, this.getEntry(Double.valueOf(1.0), Double.valueOf(2.0))));
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{3.0}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple(a + b);", names, types, this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        names = new String[]{"a", "b"};
        types = new Class[]{String.class, Integer.TYPE};
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{true}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple((a != null) && (b > 0));", names, types, this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        names = new String[]{"$0", "$1"};
        types = new Class[]{String.class, Integer.TYPE};
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{true}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple(($0 != null) && ($1 > 0));", names, types, this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        names = new String[]{"a", "b", "c"};
        types = new Class[]{Float.TYPE, String.class, String.class};
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{true}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple(b.equals(\"1\") && (a == 2.0) && c.equals(\"2\"));", names, types, this.getEntry(Double.valueOf(2.0), (Comparable)((Object)"1"), (Comparable)((Object)"2"))));
        names = new String[]{"a", "b", "$2"};
        types = new Class[]{Float.TYPE, String.class, String.class};
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{true}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple(b.equals(\"1\") && (a == 2.0) && $2.equals(\"2\"));", names, types, this.getEntry(Double.valueOf(2.0), (Comparable)((Object)"1"), (Comparable)((Object)"2"))));
        String script = "";
        script = script + "boolean first = b.equals(\"1\");\n";
        script = script + "return cascading.tuple.Tuples.tuple(first && (a == 2.0) && $2.equals(\"2\"));\n";
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{true}), (Object)this.evaluate(script, names, types, this.getEntry(Double.valueOf(2.0), (Comparable)((Object)"1"), (Comparable)((Object)"2"))));
    }

    @Test
    public void testSimpleScriptTyped() {
        Class returnType = Long.class;
        String[] names = new String[]{"a", "b"};
        Class[] types = new Class[]{Long.TYPE, Integer.TYPE};
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{3L}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple(a + b);", returnType, this.getEntry(names, types, 1L, 2)));
        returnType = Double.class;
        types = new Class[]{Double.TYPE, Integer.TYPE};
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{3.0}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple(a + b);", returnType, this.getEntry(names, types, 1.0, 2)));
        returnType = Boolean.TYPE;
        names = new String[]{"a", "b"};
        types = new Class[]{String.class, Float.TYPE};
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{true}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple((a != null) && (b > 0));", returnType, this.getEntry(names, types, "1", 2.0)));
        names = new String[]{"$0", "$1"};
        types = new Class[]{String.class, Float.TYPE};
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{true}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple(($0 != null) && ($1 > 0));", returnType, this.getEntry(names, types, "1", 2.0)));
        names = new String[]{"a", "b", "c"};
        types = new Class[]{Float.TYPE, String.class, String.class};
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{true}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple(b.equals(\"1\") && (a == 2.0) && c.equals(\"2\"));", returnType, this.getEntry(names, types, 2.0, "1", "2")));
        names = new String[]{"a", "b", "$2"};
        types = new Class[]{Float.TYPE, String.class, String.class};
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{true}), (Object)this.evaluate("return cascading.tuple.Tuples.tuple(b.equals(\"1\") && (a == 2.0) && $2.equals(\"2\"));", returnType, this.getEntry(names, types, 2.0, "1", "2")));
        String script = "";
        script = script + "boolean first = b.equals(\"1\");\n";
        script = script + "return cascading.tuple.Tuples.tuple(first && (a == 2.0) && $2.equals(\"2\"));\n";
        ScriptTupleTest.assertEquals((Object)new Tuple(new Object[]{true}), (Object)this.evaluate(script, returnType, this.getEntry(names, types, 2.0, "1", "2")));
    }

    private Object evaluate(String expression, String[] names, Class[] types, TupleEntry tupleEntry) {
        ScriptTupleFunction function = new ScriptTupleFunction(new Fields(new Comparable[]{"result"}), expression, names, types);
        ConcreteCall call = new ConcreteCall(tupleEntry.getFields(), function.getFieldDeclaration());
        function.prepare(FlowProcess.NULL, (OperationCall)call);
        return function.evaluate((ScriptOperation.Context)call.getContext(), tupleEntry);
    }

    private Object evaluate(String expression, Class returnType, TupleEntry tupleEntry) {
        ScriptTupleFunction function = new ScriptTupleFunction(new Fields((Comparable)((Object)"result"), (Type)returnType), expression);
        ConcreteCall call = new ConcreteCall(tupleEntry.getFields(), function.getFieldDeclaration());
        function.prepare(FlowProcess.NULL, (OperationCall)call);
        return function.evaluate((ScriptOperation.Context)call.getContext(), tupleEntry);
    }

    private TupleEntry getEntry(Comparable lhs, Comparable rhs) {
        Fields fields = new Fields(new Comparable[]{"a", "b"});
        Tuple parameters = new Tuple(new Object[]{lhs, rhs});
        return new TupleEntry(fields, parameters);
    }

    private TupleEntry getEntry(String[] names, Class[] types, Object ... values) {
        Fields fields = new Fields((Comparable[])names).applyTypes((Type[])types);
        Tuple parameters = new Tuple(values);
        return new TupleEntry(fields, parameters);
    }

    private TupleEntry getEntry(Comparable f, Comparable s, Comparable t) {
        Fields fields = new Fields(new Comparable[]{"a", "b", "c"});
        Tuple parameters = new Tuple(new Object[]{f, s, t});
        return new TupleEntry(fields, parameters);
    }
}

