/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.expression;

import cascading.CascadingTestCase;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.operation.expression.ExpressionFilter;
import cascading.operation.expression.ExpressionFunction;
import cascading.operation.expression.Extended;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleListCollector;
import java.lang.reflect.Type;
import org.junit.Test;

public class ExpressionTest
extends CascadingTestCase {
    @Test
    public void testExpressionFunction() {
        ExpressionTest.assertEquals((Object)3, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "a + b", Integer.TYPE), this.getEntry(Integer.valueOf(1), Integer.valueOf(2))));
        ExpressionTest.assertEquals((Object)3, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "a + b", Integer.TYPE), this.getEntry(Double.valueOf(1.0), Double.valueOf(2.0))));
        ExpressionTest.assertEquals((Object)3, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "a + b", Integer.TYPE), this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        String[] names = new String[]{"a", "b"};
        Type[] types = new Class[]{Long.TYPE, Integer.TYPE};
        ExpressionTest.assertEquals((Object)3L, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "a + b", names, (Class[])types), this.getEntry(Integer.valueOf(1), Integer.valueOf(2))));
        ExpressionTest.assertEquals((Object)3L, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "a + b", names, (Class[])types), this.getEntry(Double.valueOf(1.0), Double.valueOf(2.0))));
        ExpressionTest.assertEquals((Object)3L, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "a + b", names, (Class[])types), this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        types = new Class[]{Double.TYPE, Integer.TYPE};
        ExpressionTest.assertEquals((Object)3.0, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "a + b", names, (Class[])types), this.getEntry(Integer.valueOf(1), Integer.valueOf(2))));
        ExpressionTest.assertEquals((Object)3.0, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "a + b", names, (Class[])types), this.getEntry(Double.valueOf(1.0), Double.valueOf(2.0))));
        ExpressionTest.assertEquals((Object)3.0, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "a + b", names, (Class[])types), this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        Fields arguments = new Fields((Comparable[])names).applyTypes(types);
        ExpressionTest.assertEquals((Object)3.0, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "a + b"), this.getEntry(arguments, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2))));
        ExpressionTest.assertEquals((Object)3.0, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "a + b"), this.getEntry(arguments, (Comparable)Double.valueOf(1.0), (Comparable)Double.valueOf(2.0))));
        ExpressionTest.assertEquals((Object)3.0, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "a + b"), this.getEntry(arguments, (Comparable)((Object)"1"), (Comparable)Double.valueOf(2.0))));
        ExpressionTest.assertEquals((Object)3, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "$0 + $1", Integer.TYPE), this.getEntry(Integer.valueOf(1), Integer.valueOf(2))));
        ExpressionTest.assertEquals((Object)3, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "$0 + $1", Integer.TYPE), this.getEntry(Double.valueOf(1.0), Double.valueOf(2.0))));
        ExpressionTest.assertEquals((Object)3, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "$0 + $1", Integer.TYPE), this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        names = new String[]{"a", "b"};
        types = new Class[]{String.class, Integer.TYPE};
        ExpressionTest.assertEquals((Object)true, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "(a != null) && (b > 0)", names, (Class[])types), this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        names = new String[]{"$0", "$1"};
        types = new Class[]{String.class, Integer.TYPE};
        ExpressionTest.assertEquals((Object)true, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "($0 != null) && ($1 > 0)", names, (Class[])types), this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        names = new String[]{"a", "b", "c"};
        types = new Class[]{Float.TYPE, String.class, String.class};
        ExpressionTest.assertEquals((Object)true, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "b.equals(\"1\") && (a == 2.0) && c.equals(\"2\")", names, (Class[])types), this.getEntry(Double.valueOf(2.0), (Comparable)((Object)"1"), (Comparable)((Object)"2"))));
        names = new String[]{"a", "b", "$2"};
        types = new Class[]{Float.TYPE, String.class, String.class};
        ExpressionTest.assertEquals((Object)true, (Object)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "b.equals(\"1\") && (a == 2.0) && $2.equals(\"2\")", names, (Class[])types), this.getEntry(Double.valueOf(2.0), (Comparable)((Object)"1"), (Comparable)((Object)"2"))));
    }

    @Test
    public void testExpressionFilter() {
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("a < b", Integer.TYPE), (TupleEntry)this.getEntry(Integer.valueOf(1), Integer.valueOf(2))));
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("a < b", Integer.TYPE), (TupleEntry)this.getEntry(Double.valueOf(1.0), Double.valueOf(2.0))));
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("a < b", Integer.TYPE), (TupleEntry)this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        String[] names = new String[]{"a", "b"};
        Type[] types = new Class[]{Long.TYPE, Integer.TYPE};
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("a < b", names, (Class[])types), (TupleEntry)this.getEntry(Integer.valueOf(1), Integer.valueOf(2))));
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("a < b", names, (Class[])types), (TupleEntry)this.getEntry(Double.valueOf(1.0), Double.valueOf(2.0))));
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("a < b", names, (Class[])types), (TupleEntry)this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        types = new Class[]{Double.TYPE, Integer.TYPE};
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("a < b", names, (Class[])types), (TupleEntry)this.getEntry(Integer.valueOf(1), Integer.valueOf(2))));
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("a < b", names, (Class[])types), (TupleEntry)this.getEntry(Double.valueOf(1.0), Double.valueOf(2.0))));
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("a < b", names, (Class[])types), (TupleEntry)this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        Fields arguments = new Fields((Comparable[])names).applyTypes(types);
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("a < b"), (TupleEntry)this.getEntry(arguments, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2))));
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("a < b"), (TupleEntry)this.getEntry(arguments, (Comparable)Double.valueOf(1.0), (Comparable)Double.valueOf(2.0))));
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("a < b"), (TupleEntry)this.getEntry(arguments, (Comparable)((Object)"1"), (Comparable)Double.valueOf(2.0))));
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("$0 < $1", Integer.TYPE), (TupleEntry)this.getEntry(Integer.valueOf(1), Integer.valueOf(2))));
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("$0 < $1", Integer.TYPE), (TupleEntry)this.getEntry(Double.valueOf(1.0), Double.valueOf(2.0))));
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("$0 < $1", Integer.TYPE), (TupleEntry)this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        names = new String[]{"a", "b"};
        types = new Class[]{String.class, Integer.TYPE};
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("(a != null) && (b > 0)", names, (Class[])types), (TupleEntry)this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        names = new String[]{"$0", "$1"};
        types = new Class[]{String.class, Integer.TYPE};
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("($0 != null) && ($1 > 0)", names, (Class[])types), (TupleEntry)this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        names = new String[]{"a", "b", "c"};
        types = new Class[]{Float.TYPE, String.class, String.class};
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("b.equals(\"1\") && (a == 2.0) && c.equals(\"2\")", names, (Class[])types), (TupleEntry)this.getEntry(Double.valueOf(2.0), (Comparable)((Object)"1"), (Comparable)((Object)"2"))));
        names = new String[]{"a", "b", "$2"};
        types = new Class[]{Float.TYPE, String.class, String.class};
        ExpressionTest.assertEquals((boolean)true, (boolean)ExpressionTest.invokeFilter((Filter)new ExpressionFilter("b.equals(\"1\") && (a == 2.0) && $2.equals(\"2\")", names, (Class[])types), (TupleEntry)this.getEntry(Double.valueOf(2.0), (Comparable)((Object)"1"), (Comparable)((Object)"2"))));
    }

    @Test
    public void testNoParamExpression() {
        Fields fields = new Fields(new Comparable[]{"a", "b"}).applyTypes(new Type[]{String.class, Double.TYPE});
        String expression = "(int) (Math.random() * Integer.MAX_VALUE)";
        Number integer = (Number)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), expression), this.getEntry(fields, (Comparable)((Object)"1"), (Comparable)Double.valueOf(2.0)));
        ExpressionTest.assertNotNull((Object)integer);
        integer = (Number)this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), expression), TupleEntry.NULL);
        ExpressionTest.assertNotNull((Object)integer);
        try {
            this.evaluate(new ExpressionFunction(new Fields(new Comparable[]{"result"}), "(int) (Math.random() * Integer.MAX_VALUE) + parameter"), this.getEntry(fields, (Comparable)((Object)"1"), (Comparable)Double.valueOf(2.0)));
            ExpressionTest.fail((String)"should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testExtendedClassExpression() {
        Fields fields = new Fields(new Comparable[]{"a", "b"}).applyTypes(new Type[]{String.class, Double.TYPE});
        String expression = "returnValue(\"value\")";
        ExpressionFunction result = new ExpressionFunction(new Fields(new Comparable[]{"result"}), expression){

            public Class<?> getExtendedClass() {
                return Extended.class;
            }
        };
        String value = (String)this.evaluate(result, this.getEntry(fields, (Comparable)((Object)"1"), (Comparable)Double.valueOf(2.0)));
        ExpressionTest.assertNotNull((Object)value);
        value = (String)this.evaluate(result, TupleEntry.NULL);
        ExpressionTest.assertNotNull((Object)value);
    }

    private Object evaluate(ExpressionFunction function, TupleEntry tupleEntry) {
        TupleListCollector tuples = ExpressionTest.invokeFunction((Function)function, (TupleEntry)tupleEntry, (Fields)function.getFieldDeclaration());
        return ((TupleEntry)tuples.entryIterator().next()).getObject(0);
    }

    private TupleEntry getEntry(Fields fields, Comparable lhs, Comparable rhs) {
        Tuple parameters = new Tuple(new Object[]{lhs, rhs});
        return new TupleEntry(fields, parameters);
    }

    private TupleEntry getEntry(Comparable lhs, Comparable rhs) {
        Fields fields = new Fields(new Comparable[]{"a", "b"});
        Tuple parameters = new Tuple(new Object[]{lhs, rhs});
        return new TupleEntry(fields, parameters);
    }

    private TupleEntry getEntry(Comparable f, Comparable s, Comparable t) {
        Fields fields = new Fields(new Comparable[]{"a", "b", "c"});
        Tuple parameters = new Tuple(new Object[]{f, s, t});
        return new TupleEntry(fields, parameters);
    }
}

