/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.expression;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.operation.BaseOperation;
import cascading.operation.OperationCall;
import cascading.operation.OperationException;
import cascading.operation.expression.ExpressionOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.Tuples;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import cascading.tuple.util.TupleViews;
import cascading.util.Util;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ScriptEvaluator;

public abstract class ScriptOperation
extends BaseOperation<Context> {
    protected final String block;
    protected Class[] parameterTypes;
    protected String[] parameterNames;
    protected Class returnType = Object.class;

    public ScriptOperation(int numArgs, Fields fieldDeclaration, String block) {
        super(numArgs, fieldDeclaration);
        this.block = block;
        this.returnType = fieldDeclaration.getTypeClass(0) == null ? this.returnType : fieldDeclaration.getTypeClass(0);
    }

    public ScriptOperation(int numArgs, Fields fieldDeclaration, String block, Class returnType) {
        super(numArgs, fieldDeclaration);
        this.block = block;
        this.returnType = returnType == null ? this.returnType : returnType;
    }

    public ScriptOperation(int numArgs, Fields fieldDeclaration, String block, Class returnType, Class[] expectedTypes) {
        super(numArgs, fieldDeclaration);
        this.block = block;
        Class clazz = this.returnType = returnType == null ? this.returnType : returnType;
        if (expectedTypes == null) {
            throw new IllegalArgumentException("expectedTypes may not be null");
        }
        this.parameterTypes = Arrays.copyOf(expectedTypes, expectedTypes.length);
    }

    public ScriptOperation(int numArgs, Fields fieldDeclaration, String block, Class returnType, String[] parameterNames, Class[] parameterTypes) {
        super(numArgs, fieldDeclaration);
        this.parameterNames = parameterNames == null ? null : Arrays.copyOf(parameterNames, parameterNames.length);
        this.block = block;
        this.returnType = returnType == null ? this.returnType : returnType;
        this.parameterTypes = Arrays.copyOf(parameterTypes, parameterTypes.length);
        if (this.getParameterNamesInternal().length != this.getParameterTypesInternal().length) {
            throw new IllegalArgumentException("parameterNames must be same length as parameterTypes");
        }
    }

    public ScriptOperation(int numArgs, String block, Class returnType) {
        super(numArgs);
        this.block = block;
        this.returnType = returnType == null ? this.returnType : returnType;
    }

    public ScriptOperation(int numArgs, String block, Class returnType, Class[] expectedTypes) {
        super(numArgs);
        this.block = block;
        Class clazz = this.returnType = returnType == null ? this.returnType : returnType;
        if (expectedTypes == null || expectedTypes.length == 0) {
            throw new IllegalArgumentException("expectedTypes may not be null or empty");
        }
        this.parameterTypes = Arrays.copyOf(expectedTypes, expectedTypes.length);
    }

    public ScriptOperation(int numArgs, String block, Class returnType, String[] parameterNames, Class[] parameterTypes) {
        super(numArgs);
        this.parameterNames = parameterNames == null ? null : Arrays.copyOf(parameterNames, parameterNames.length);
        this.block = block;
        this.returnType = returnType == null ? this.returnType : returnType;
        this.parameterTypes = Arrays.copyOf(parameterTypes, parameterTypes.length);
        if (this.getParameterNamesInternal().length != this.getParameterTypesInternal().length) {
            throw new IllegalArgumentException("parameterNames must be same length as parameterTypes");
        }
    }

    @Property(name="source", visibility=Visibility.PRIVATE)
    @PropertyDescription(value="The Java source to execute.")
    public String getBlock() {
        return this.block;
    }

    private boolean hasParameterNames() {
        return this.parameterNames != null;
    }

    @Property(name="parameterNames", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The declared parameter names.")
    public String[] getParameterNames() {
        return (String[])Util.copy((Object[])this.parameterNames);
    }

    private String[] getParameterNamesInternal() {
        if (this.parameterNames != null) {
            return this.parameterNames;
        }
        try {
            this.parameterNames = this.guessParameterNames();
        }
        catch (IOException exception) {
            throw new OperationException("could not read expression: " + this.block, (Throwable)exception);
        }
        catch (CompileException exception) {
            throw new OperationException("could not compile expression: " + this.block, (Throwable)exception);
        }
        return this.parameterNames;
    }

    protected String[] guessParameterNames() throws CompileException, IOException {
        throw new OperationException("parameter names are required");
    }

    private Fields getParameterFields() {
        return this.makeFields(this.getParameterNamesInternal());
    }

    private boolean hasParameterTypes() {
        return this.parameterTypes != null;
    }

    @Property(name="parameterTypes", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The declared parameter types.")
    public Class[] getParameterTypes() {
        return (Class[])Util.copy((Object[])this.parameterTypes);
    }

    private Class[] getParameterTypesInternal() {
        if (!this.hasParameterNames()) {
            return this.parameterTypes;
        }
        if (this.parameterNames.length == this.parameterTypes.length) {
            return this.parameterTypes;
        }
        if (this.parameterNames.length > 0 && this.parameterTypes.length != 1) {
            throw new IllegalStateException("wrong number of parameter types, expects: " + this.parameterNames.length);
        }
        Object[] types = new Class[this.parameterNames.length];
        Arrays.fill(types, this.parameterTypes[0]);
        this.parameterTypes = types;
        return this.parameterTypes;
    }

    public Class<?> getExtendedClass() {
        return null;
    }

    protected Evaluator getEvaluator(Class returnType, String[] parameterNames, Class[] parameterTypes) {
        try {
            ScriptEvaluator evaluator = new ScriptEvaluator();
            evaluator.setReturnType(returnType);
            evaluator.setParameters(parameterNames, parameterTypes);
            evaluator.setExtendedClass(this.getExtendedClass());
            evaluator.cook(this.block);
            return arg_0 -> ((ScriptEvaluator)evaluator).evaluate(arg_0);
        }
        catch (CompileException exception) {
            throw new OperationException("could not compile script: " + this.block, (Throwable)exception);
        }
    }

    private Fields makeFields(String[] parameters) {
        Comparable[] fields = new Comparable[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String parameter = parameters[i];
            fields[i] = parameter.startsWith("$") ? this.parse(parameter) : parameter;
        }
        return new Fields(fields);
    }

    private Comparable parse(String parameter) {
        try {
            return Integer.valueOf(Integer.parseInt(parameter.substring(1)));
        }
        catch (NumberFormatException exception) {
            return parameter;
        }
    }

    public void prepare(FlowProcess flowProcess, OperationCall<Context> operationCall) {
        if (operationCall.getContext() == null) {
            operationCall.setContext((Object)new Context());
        }
        Context context = (Context)operationCall.getContext();
        Fields argumentFields = operationCall.getArgumentFields();
        if (this.hasParameterNames() && this.hasParameterTypes()) {
            Context.access$002(context, this.getParameterNamesInternal());
            context.parameterFields = argumentFields.select(this.getParameterFields());
            Context.access$202(context, this.getParameterTypesInternal());
        } else if (this.hasParameterTypes()) {
            Context.access$002(context, this.toNames(argumentFields));
            context.parameterFields = argumentFields.applyTypes((Type[])this.getParameterTypesInternal());
            Context.access$202(context, this.getParameterTypesInternal());
        } else {
            Context.access$002(context, this.toNames(argumentFields));
            context.parameterFields = argumentFields;
            Context.access$202(context, argumentFields.getTypesClasses());
            if (argumentFields.isNone()) {
                Context.access$202(context, new Class[0]);
            }
            if (context.parameterTypes == null) {
                throw new IllegalArgumentException("field types may not be empty, incoming tuple stream should declare field types");
            }
        }
        Context.access$302(context, Coercions.coercibleArray((Fields)context.parameterFields));
        Context.access$402(context, new Object[context.parameterTypes.length]);
        context.scriptEvaluator = this.getEvaluator(this.getReturnType(), context.parameterNames, context.parameterTypes);
        context.intermediate = TupleViews.createNarrow((int[])argumentFields.getPos(context.parameterFields));
        context.result = Tuple.size((int)1);
    }

    private String[] toNames(Fields argumentFields) {
        String[] names = new String[argumentFields.size()];
        for (int i = 0; i < names.length; ++i) {
            Comparable comparable = argumentFields.get(i);
            names[i] = comparable instanceof String ? (String)((Object)comparable) : "$" + comparable;
        }
        return names;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    protected Object evaluate(Context context, TupleEntry input) {
        try {
            if (context.parameterTypes.length == 0) {
                return context.scriptEvaluator.evaluate(null);
            }
            Tuple parameterTuple = TupleViews.reset((Tuple)context.intermediate, (Object[])new Tuple[]{input.getTuple()});
            Object[] arguments = Tuples.asArray((Tuple)parameterTuple, (CoercibleType[])context.parameterCoercions, (Class[])context.parameterTypes, (Object[])context.parameterArray);
            return context.scriptEvaluator.evaluate(arguments);
        }
        catch (IllegalArgumentException exception) {
            throw new OperationException("could not evaluate expression: " + this.block + ", typed: " + Arrays.toString(context.parameterTypes) + " coerced by: " + Arrays.toString(context.parameterCoercions), (Throwable)exception);
        }
        catch (InvocationTargetException exception) {
            throw new OperationException("could not evaluate expression: " + this.block + ", typed: " + Arrays.toString(context.parameterTypes) + " coerced by: " + Arrays.toString(context.parameterCoercions), exception.getTargetException());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExpressionOperation)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ExpressionOperation that = (ExpressionOperation)((Object)object);
        if (this.block != null ? !this.block.equals(that.block) : that.block != null) {
            return false;
        }
        if (!Arrays.equals(this.parameterNames, that.parameterNames)) {
            return false;
        }
        return Arrays.equals(this.parameterTypes, that.parameterTypes);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.block != null ? this.block.hashCode() : 0);
        result = 31 * result + (this.parameterTypes != null ? Arrays.hashCode(this.parameterTypes) : 0);
        result = 31 * result + (this.parameterNames != null ? Arrays.hashCode(this.parameterNames) : 0);
        return result;
    }

    public static class Context {
        protected Tuple result;
        private Class[] parameterTypes;
        private Evaluator scriptEvaluator;
        private Fields parameterFields;
        private CoercibleType[] parameterCoercions;
        private String[] parameterNames;
        private Object[] parameterArray;
        private Tuple intermediate;

        static /* synthetic */ String[] access$002(Context x0, String[] x1) {
            x0.parameterNames = x1;
            return x1;
        }

        static /* synthetic */ Class[] access$202(Context x0, Class[] x1) {
            x0.parameterTypes = x1;
            return x1;
        }

        static /* synthetic */ CoercibleType[] access$302(Context x0, CoercibleType[] x1) {
            x0.parameterCoercions = x1;
            return x1;
        }

        static /* synthetic */ Object[] access$402(Context x0, Object[] x1) {
            x0.parameterArray = x1;
            return x1;
        }
    }

    protected static interface Evaluator {
        public Object evaluate(Object[] var1) throws InvocationTargetException;
    }
}

