/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.expression;

import cascading.CascadingTestCase;
import cascading.operation.Filter;
import cascading.operation.expression.ExpressionFilter;
import cascading.operation.filter.And;
import cascading.operation.filter.Or;
import cascading.operation.filter.Xor;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import org.junit.Test;

public class FilterTest
extends CascadingTestCase {
    @Test
    public void testOrExpression() {
        Fields inputFields = new Fields(new Comparable[]{"a", "b"});
        ExpressionFilter f1 = new ExpressionFilter("( 100f < a )", new String[]{"a"}, new Class[]{Float.TYPE});
        ExpressionFilter f2 = new ExpressionFilter("( 100f < b )", new String[]{"b"}, new Class[]{Float.TYPE});
        Or logic = new Or(new Fields(new Comparable[]{"a"}), (Filter)f1, new Fields(new Comparable[]{"b"}), (Filter)f2);
        boolean[] results = FilterTest.invokeFilter((Filter)logic, (TupleEntry[])new TupleEntry[]{new TupleEntry(inputFields, new Tuple(new Object[]{"1", "10"})), new TupleEntry(inputFields, new Tuple(new Object[]{"2", "20"}))});
        FilterTest.assertFalse((boolean)results[0]);
        FilterTest.assertFalse((boolean)results[1]);
    }

    @Test
    public void testXorExpression() {
        Fields inputFields = new Fields(new Comparable[]{"a", "b"});
        ExpressionFilter f1 = new ExpressionFilter("( 100f < a )", new String[]{"a"}, new Class[]{Float.TYPE});
        ExpressionFilter f2 = new ExpressionFilter("( 100f < b )", new String[]{"b"}, new Class[]{Float.TYPE});
        Xor logic = new Xor(new Fields(new Comparable[]{"a"}), (Filter)f1, new Fields(new Comparable[]{"b"}), (Filter)f2);
        boolean[] results = FilterTest.invokeFilter((Filter)logic, (TupleEntry[])new TupleEntry[]{new TupleEntry(inputFields, new Tuple(new Object[]{"1", "10"})), new TupleEntry(inputFields, new Tuple(new Object[]{"2", "20"}))});
        FilterTest.assertFalse((boolean)results[0]);
        FilterTest.assertFalse((boolean)results[1]);
    }

    @Test
    public void testAndExpression() {
        Fields inputFields = new Fields(new Comparable[]{"a", "b"});
        ExpressionFilter f1 = new ExpressionFilter("( 100f < a )", new String[]{"a"}, new Class[]{Float.TYPE});
        ExpressionFilter f2 = new ExpressionFilter("( 100f < b )", new String[]{"b"}, new Class[]{Float.TYPE});
        And logic = new And(new Fields(new Comparable[]{"a"}), (Filter)f1, new Fields(new Comparable[]{"b"}), (Filter)f2);
        boolean[] results = FilterTest.invokeFilter((Filter)logic, (TupleEntry[])new TupleEntry[]{new TupleEntry(inputFields, new Tuple(new Object[]{"1", "10"})), new TupleEntry(inputFields, new Tuple(new Object[]{"2", "20"}))});
        FilterTest.assertFalse((boolean)results[0]);
        FilterTest.assertFalse((boolean)results[1]);
    }
}

