/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.expression;

import cascading.CascadingTestCase;
import cascading.flow.FlowProcess;
import cascading.operation.AssertionException;
import cascading.operation.ConcreteCall;
import cascading.operation.OperationCall;
import cascading.operation.ValueAssertion;
import cascading.operation.ValueAssertionCall;
import cascading.operation.assertion.AssertExpression;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import org.junit.Test;

public class ValueAssertionsTest
extends CascadingTestCase {
    private TupleEntry getEntry(Tuple tuple) {
        return new TupleEntry(Fields.size((int)tuple.size()), tuple);
    }

    private ConcreteCall getOperationCall(TupleEntry tupleEntry) {
        ConcreteCall operationCall = new ConcreteCall(tupleEntry.getFields());
        operationCall.setArguments(tupleEntry);
        return operationCall;
    }

    private void assertFail(ValueAssertion assertion, TupleEntry tupleEntry) {
        ConcreteCall concreteCall = this.getOperationCall(tupleEntry);
        assertion.prepare(FlowProcess.NULL, (OperationCall)concreteCall);
        try {
            assertion.doAssert(FlowProcess.NULL, (ValueAssertionCall)concreteCall);
            ValueAssertionsTest.fail();
        }
        catch (AssertionException assertionException) {
            // empty catch block
        }
    }

    private void assertPass(ValueAssertion assertion, TupleEntry tupleEntry) {
        ConcreteCall concreteCall = this.getOperationCall(tupleEntry);
        assertion.prepare(FlowProcess.NULL, (OperationCall)concreteCall);
        assertion.doAssert(FlowProcess.NULL, (ValueAssertionCall)concreteCall);
    }

    @Test
    public void testExpression() {
        AssertExpression assertion = new AssertExpression("$0 == 1", Integer.TYPE);
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{1})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{null})));
        this.assertPass((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"1", 0})));
        this.assertFail((ValueAssertion)assertion, this.getEntry(new Tuple(new Object[]{"0", null})));
    }
}

