/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.expression;

import cascading.CascadingTestCase;
import cascading.flow.FlowProcess;
import cascading.operation.ConcreteCall;
import cascading.operation.OperationCall;
import cascading.operation.expression.ScriptFunction;
import cascading.operation.expression.ScriptOperation;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.lang.reflect.Type;
import org.junit.Test;

public class ScriptTest
extends CascadingTestCase {
    @Test
    public void testSimpleScript() {
        Class returnType = Long.class;
        String[] names = new String[]{"a", "b"};
        Class[] types = new Class[]{Long.TYPE, Integer.TYPE};
        ScriptTest.assertEquals((Object)3L, (Object)this.evaluate("return a + b;", returnType, names, types, this.getEntry(Integer.valueOf(1), Integer.valueOf(2))));
        ScriptTest.assertEquals((Object)3L, (Object)this.evaluate("return a + b;", returnType, names, types, this.getEntry(Double.valueOf(1.0), Double.valueOf(2.0))));
        ScriptTest.assertEquals((Object)3L, (Object)this.evaluate("return a + b;", returnType, names, types, this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        returnType = Double.class;
        types = new Class[]{Double.TYPE, Integer.TYPE};
        ScriptTest.assertEquals((Object)3.0, (Object)this.evaluate("return a + b;", returnType, names, types, this.getEntry(Integer.valueOf(1), Integer.valueOf(2))));
        ScriptTest.assertEquals((Object)3.0, (Object)this.evaluate("return a + b;", returnType, names, types, this.getEntry(Double.valueOf(1.0), Double.valueOf(2.0))));
        ScriptTest.assertEquals((Object)3.0, (Object)this.evaluate("return a + b;", returnType, names, types, this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        returnType = Boolean.TYPE;
        names = new String[]{"a", "b"};
        types = new Class[]{String.class, Integer.TYPE};
        ScriptTest.assertEquals((Object)true, (Object)this.evaluate("return (a != null) && (b > 0);", returnType, names, types, this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        names = new String[]{"$0", "$1"};
        types = new Class[]{String.class, Integer.TYPE};
        ScriptTest.assertEquals((Object)true, (Object)this.evaluate("return ($0 != null) && ($1 > 0);", returnType, names, types, this.getEntry((Comparable)((Object)"1"), Double.valueOf(2.0))));
        names = new String[]{"a", "b", "c"};
        types = new Class[]{Float.TYPE, String.class, String.class};
        ScriptTest.assertEquals((Object)true, (Object)this.evaluate("return b.equals(\"1\") && (a == 2.0) && c.equals(\"2\");", returnType, names, types, this.getEntry(Double.valueOf(2.0), (Comparable)((Object)"1"), (Comparable)((Object)"2"))));
        names = new String[]{"a", "b", "$2"};
        types = new Class[]{Float.TYPE, String.class, String.class};
        ScriptTest.assertEquals((Object)true, (Object)this.evaluate("return b.equals(\"1\") && (a == 2.0) && $2.equals(\"2\");", returnType, names, types, this.getEntry(Double.valueOf(2.0), (Comparable)((Object)"1"), (Comparable)((Object)"2"))));
        String script = "";
        script = script + "boolean first = b.equals(\"1\");\n";
        script = script + "return first && (a == 2.0) && $2.equals(\"2\");\n";
        ScriptTest.assertEquals((Object)true, (Object)this.evaluate(script, returnType, names, types, this.getEntry(Double.valueOf(2.0), (Comparable)((Object)"1"), (Comparable)((Object)"2"))));
    }

    @Test
    public void testSimpleScriptTyped() {
        Class returnType = Long.class;
        String[] names = new String[]{"a", "b"};
        Class[] types = new Class[]{Long.TYPE, Integer.TYPE};
        ScriptTest.assertEquals((Object)3L, (Object)this.evaluate("return a + b;", returnType, this.getEntry(names, types, 1L, 2)));
        returnType = Double.class;
        types = new Class[]{Double.TYPE, Integer.TYPE};
        ScriptTest.assertEquals((Object)3.0, (Object)this.evaluate("return a + b;", returnType, this.getEntry(names, types, 1.0, 2)));
        returnType = Boolean.TYPE;
        names = new String[]{"a", "b"};
        types = new Class[]{String.class, Float.TYPE};
        ScriptTest.assertEquals((Object)true, (Object)this.evaluate("return (a != null) && (b > 0);", returnType, this.getEntry(names, types, "1", 2.0)));
        names = new String[]{"$0", "$1"};
        types = new Class[]{String.class, Float.TYPE};
        ScriptTest.assertEquals((Object)true, (Object)this.evaluate("return ($0 != null) && ($1 > 0);", returnType, this.getEntry(names, types, "1", 2.0)));
        names = new String[]{"a", "b", "c"};
        types = new Class[]{Float.TYPE, String.class, String.class};
        ScriptTest.assertEquals((Object)true, (Object)this.evaluate("return b.equals(\"1\") && (a == 2.0) && c.equals(\"2\");", returnType, this.getEntry(names, types, 2.0, "1", "2")));
        names = new String[]{"a", "b", "$2"};
        types = new Class[]{Float.TYPE, String.class, String.class};
        ScriptTest.assertEquals((Object)true, (Object)this.evaluate("return b.equals(\"1\") && (a == 2.0) && $2.equals(\"2\");", returnType, this.getEntry(names, types, 2.0, "1", "2")));
        String script = "";
        script = script + "boolean first = b.equals(\"1\");\n";
        script = script + "return first && (a == 2.0) && $2.equals(\"2\");\n";
        ScriptTest.assertEquals((Object)true, (Object)this.evaluate(script, returnType, this.getEntry(names, types, 2.0, "1", "2")));
    }

    private Object evaluate(String expression, Class returnType, String[] names, Class[] types, TupleEntry tupleEntry) {
        ScriptFunction function = new ScriptFunction(new Fields(new Comparable[]{"result"}), expression, returnType, names, types);
        ConcreteCall call = new ConcreteCall(tupleEntry.getFields(), function.getFieldDeclaration());
        function.prepare(FlowProcess.NULL, (OperationCall)call);
        return function.evaluate((ScriptOperation.Context)call.getContext(), tupleEntry);
    }

    private Object evaluate(String expression, Class returnType, TupleEntry tupleEntry) {
        ScriptFunction function = new ScriptFunction(new Fields(new Comparable[]{"result"}), expression, returnType);
        ConcreteCall call = new ConcreteCall(tupleEntry.getFields(), function.getFieldDeclaration());
        function.prepare(FlowProcess.NULL, (OperationCall)call);
        return function.evaluate((ScriptOperation.Context)call.getContext(), tupleEntry);
    }

    private TupleEntry getEntry(Comparable lhs, Comparable rhs) {
        Fields fields = new Fields(new Comparable[]{"a", "b"});
        Tuple parameters = new Tuple(new Object[]{lhs, rhs});
        return new TupleEntry(fields, parameters);
    }

    private TupleEntry getEntry(String[] names, Class[] types, Object ... values) {
        Fields fields = new Fields((Comparable[])names).applyTypes((Type[])types);
        Tuple parameters = new Tuple(values);
        return new TupleEntry(fields, parameters);
    }

    private TupleEntry getEntry(Comparable f, Comparable s, Comparable t) {
        Fields fields = new Fields(new Comparable[]{"a", "b", "c"});
        Tuple parameters = new Tuple(new Object[]{f, s, t});
        return new TupleEntry(fields, parameters);
    }
}

