/*
 * Decompiled with CFR 0.152.
 */
package cascading.util.cache;

import cascading.util.cache.CacheEvictionCallback;
import cascading.util.cache.CascadingCache;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUHashMapCache<Key, Value>
implements CascadingCache<Key, Value> {
    private static final Logger LOG = LoggerFactory.getLogger(LRUHashMapCache.class);
    private int capacity;
    private CacheEvictionCallback callback = CacheEvictionCallback.NULL;
    private long flushes = 0L;
    private LinkedHashMap<Key, Value> backingMap;

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void setCacheEvictionCallback(CacheEvictionCallback cacheEvictionCallback) {
        this.callback = cacheEvictionCallback;
    }

    @Override
    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public void initialize() {
        this.backingMap = new LinkedHashMap<Key, Value>(this.capacity, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Key, Value> eldest) {
                boolean doRemove;
                boolean bl = doRemove = this.size() > LRUHashMapCache.this.capacity;
                if (doRemove) {
                    LRUHashMapCache.this.callback.evict(eldest);
                    if (LRUHashMapCache.this.flushes % (long)LRUHashMapCache.this.getCapacity() == 0L) {
                        Runtime runtime = Runtime.getRuntime();
                        long freeMem = runtime.freeMemory() / 1024L / 1024L;
                        long maxMem = runtime.maxMemory() / 1024L / 1024L;
                        long totalMem = runtime.totalMemory() / 1024L / 1024L;
                        LOG.info("flushed keys num times: {}, with capacity: {}", (Object)(LRUHashMapCache.this.flushes + 1L), (Object)LRUHashMapCache.this.capacity);
                        LOG.info("mem on flush (mb), free: " + freeMem + ", total: " + totalMem + ", max: " + maxMem);
                        float percent = (float)totalMem / (float)maxMem;
                        if (percent < 0.8f) {
                            LOG.info("total mem is {}% of max mem, to better utilize unused memory consider increasing the cache size", (Object)((int)(percent * 100.0f)));
                        }
                    }
                    LRUHashMapCache.this.flushes++;
                }
                return doRemove;
            }
        };
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    public Value get(Object key) {
        return this.backingMap.get(key);
    }

    @Override
    public Value put(Key key, Value value) {
        return this.backingMap.put(key, value);
    }

    @Override
    public Value remove(Object key) {
        return (Value)this.backingMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Value> m) {
        this.backingMap.putAll(m);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public Set<Key> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public Collection<Value> values() {
        return this.backingMap.values();
    }

    @Override
    public Set<Map.Entry<Key, Value>> entrySet() {
        return this.backingMap.entrySet();
    }
}

