/*
 * Decompiled with CFR 0.152.
 */
package cascading.util.cache;

import cascading.util.cache.CacheEvictionCallback;
import cascading.util.cache.CascadingCache;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectMappedCache<Key, Value>
implements CascadingCache<Key, Value> {
    private static final Logger LOG = LoggerFactory.getLogger(DirectMappedCache.class);
    private int capacity;
    private int actualSize = 0;
    private Map.Entry<Key, Value>[] elements;
    private long collisions = 0L;
    private long putCalls = 0L;
    public boolean initialized = false;
    private CacheEvictionCallback evictionCallBack = CacheEvictionCallback.NULL;

    @Override
    public int size() {
        return this.actualSize;
    }

    @Override
    public boolean isEmpty() {
        return this.actualSize < 1;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("null keys are not permitted");
        }
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        Iter<Map.Entry<Key, Value>> iter = new Iter<Map.Entry<Key, Value>>(this.elements);
        while (iter.hasNext()) {
            Value current = iter.next().getValue();
            if (!current.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Value get(Object key) {
        int index = this.index(key);
        Map.Entry<Key, Value> existing = this.elements[index];
        if (existing == null || !key.equals(existing.getKey())) {
            return null;
        }
        return existing.getValue();
    }

    @Override
    public Value put(Key key, Value value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        ++this.putCalls;
        Value previous = null;
        int index = this.index(key);
        Map.Entry<Key, Value> existing = this.elements[index];
        if (existing != null) {
            previous = existing.getValue();
            ++this.collisions;
            this.evictionCallBack.evict(existing);
        } else {
            ++this.actualSize;
        }
        this.elements[index] = new CacheEntry<Key, Value>(key, value);
        if (this.putCalls % (long)this.getCapacity() == 0L) {
            Runtime runtime = Runtime.getRuntime();
            long freeMem = runtime.freeMemory() / 1024L / 1024L;
            long maxMem = runtime.maxMemory() / 1024L / 1024L;
            long totalMem = runtime.totalMemory() / 1024L / 1024L;
            LOG.info("mem on flush (mb), free: " + freeMem + ", total: " + totalMem + ", max: " + maxMem);
            LOG.info("capacity={}, puts={}, collisions={}, fill factor={}%", new Object[]{this.getCapacity(), this.putCalls, this.collisions, (double)this.getCapacity() / (double)this.actualSize * 100.0});
            float percent = (float)totalMem / (float)maxMem;
            if (percent < 0.8f) {
                LOG.info("total mem is {}% of max mem, to better utilize unused memory consider increasing the cache size", (Object)((int)(percent * 100.0f)));
            }
        }
        return previous;
    }

    private int index(Object key) {
        return Math.abs(key.hashCode() % this.capacity);
    }

    @Override
    public Value remove(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        int index = this.index(key);
        Map.Entry<Key, Value> existing = this.elements[index];
        if (existing == null || !existing.getKey().equals(key)) {
            return null;
        }
        this.elements[index] = null;
        --this.actualSize;
        this.evictionCallBack.evict(existing);
        return existing.getValue();
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Value> m) {
        for (Map.Entry<Key, Value> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.elements = new CacheEntry[this.capacity];
        this.actualSize = 0;
    }

    @Override
    public Set<Key> keySet() {
        return new KeySetView(new SetView(this.elements, this.actualSize));
    }

    @Override
    public Collection<Value> values() {
        return new ValueCollection(new SetView(this.elements, this.actualSize));
    }

    @Override
    public Set<Map.Entry<Key, Value>> entrySet() {
        return new SetView<Map.Entry<Key, Value>>(this.elements, this.actualSize);
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void setCacheEvictionCallback(CacheEvictionCallback cacheEvictionCallback) {
        if (this.initialized) {
            throw new IllegalStateException("cannot set callback after initialization");
        }
        this.evictionCallBack = cacheEvictionCallback;
    }

    @Override
    public void setCapacity(int capacity) {
        if (this.initialized) {
            throw new IllegalArgumentException("cannot set size after initialization");
        }
        this.capacity = capacity;
    }

    @Override
    public void initialize() {
        if (this.capacity < 1) {
            throw new IllegalStateException("capacity must be larger than 0");
        }
        if (this.evictionCallBack == null) {
            throw new IllegalStateException("evictionCallback cannot be null");
        }
        this.elements = new CacheEntry[this.capacity];
        this.initialized = true;
    }

    static class ValueIterator<Value>
    implements Iterator<Value> {
        private final Iterator<Map.Entry<?, Value>> parent;

        public ValueIterator(Iterator<Map.Entry<?, Value>> parent) {
            this.parent = parent;
        }

        @Override
        public Value next() {
            return this.parent.next().getValue();
        }

        @Override
        public boolean hasNext() {
            return this.parent.hasNext();
        }

        @Override
        public void remove() {
            this.parent.remove();
        }
    }

    static class KeyIterator<Key>
    implements Iterator<Key> {
        private final Iterator<Map.Entry<Key, ?>> parent;

        public KeyIterator(Iterator<Map.Entry<Key, ?>> parent) {
            this.parent = parent;
        }

        @Override
        public Key next() {
            return this.parent.next().getKey();
        }

        @Override
        public boolean hasNext() {
            return this.parent.hasNext();
        }

        @Override
        public void remove() {
            this.parent.remove();
        }
    }

    static class ValueCollection<Value>
    extends AbstractCollection<Value> {
        private Set<Map.Entry<?, Value>> parent;

        ValueCollection(Set<Map.Entry<?, Value>> parent) {
            this.parent = parent;
        }

        @Override
        public Iterator<Value> iterator() {
            return new ValueIterator<Value>(this.parent.iterator());
        }

        @Override
        public int size() {
            return this.parent.size();
        }
    }

    static class KeySetView<Key>
    extends AbstractSet<Key> {
        private final Set<Map.Entry<Key, ?>> parent;

        public KeySetView(Set<Map.Entry<Key, ?>> parent) {
            this.parent = parent;
        }

        @Override
        public Iterator<Key> iterator() {
            return new KeyIterator<Key>(this.parent.iterator());
        }

        @Override
        public int size() {
            return this.parent.size();
        }
    }

    static class Iter<T>
    implements Iterator<T> {
        private final T[] elements;
        private T nextElement;
        int currentIndex = -1;

        public Iter(T[] elements) {
            this.elements = elements;
            this.nextElement = this.findNext();
        }

        private T findNext() {
            while (this.currentIndex < this.elements.length - 1) {
                ++this.currentIndex;
                if (this.elements[this.currentIndex] == null) continue;
                return this.elements[this.currentIndex];
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T current = this.nextElement;
            this.nextElement = this.findNext();
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextElement = this.findNext();
        }
    }

    class SetView<T>
    extends AbstractSet<T> {
        private final T[] elements;
        private final int size;
        private final Iter<T> iter;

        SetView(T[] elements, int size) {
            this.elements = elements;
            this.size = size;
            this.iter = new Iter<T>(elements);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iter<T>(this.elements);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object object : c) {
                if (this.contains(object)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException("SetView is read only.");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("SetView is read only.");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("SetView is read only.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("SetView is read only.");
        }
    }

    static class CacheEntry<Key, Value>
    implements Map.Entry<Key, Value> {
        private final Key key;
        private Value value;

        CacheEntry(Key key, Value value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Key getKey() {
            return this.key;
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        @Override
        public Value setValue(Value value) {
            Value oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Map.Entry that = (Map.Entry)object;
            if (this.key != null ? !this.key.equals(that.getKey()) : that.getKey() != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.getValue()) : that.getValue() != null);
        }

        @Override
        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "CacheEntry{key=" + this.key + ", value=" + this.value + '}';
        }
    }
}

