/*
 * Decompiled with CFR 0.152.
 */
package cascading.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Trie<V extends Serializable>
implements Serializable {
    Entry<V> entry;
    char key;
    Map<Character, Trie<V>> children = new HashMap<Character, Trie<V>>();

    public Trie() {
        this.entry = new Entry();
    }

    Trie(char key) {
        this.key = key;
        this.entry = new Entry();
    }

    public void put(String key, V value) {
        this.put(new StringBuffer(key), new StringBuffer(""), value);
    }

    void put(StringBuffer remainder, StringBuffer prefix, V value) {
        if (remainder.length() <= 0) {
            this.entry.value = value;
            this.entry.prefix = prefix.toString();
            return;
        }
        char keyElement = remainder.charAt(0);
        Trie<V> trie = null;
        try {
            trie = this.children.get(Character.valueOf(keyElement));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (trie == null) {
            trie = new Trie<V>(keyElement);
            this.children.put(Character.valueOf(keyElement), trie);
        }
        prefix.append(remainder.charAt(0));
        trie.put(remainder.deleteCharAt(0), prefix, value);
    }

    public V get(String key) {
        return this.get(new StringBuffer(key), 0);
    }

    public boolean hasPrefix(String key) {
        return this.get(key) != null;
    }

    V get(StringBuffer key, int level) {
        if (key.length() <= 0) {
            return (V)((Serializable)this.entry.value);
        }
        Trie<V> trie = this.children.get(Character.valueOf(key.charAt(0)));
        if (trie != null) {
            return trie.get(key.deleteCharAt(0), ++level);
        }
        return (V)(level > 0 ? (Serializable)this.entry.value : null);
    }

    public String getCommonPrefix() {
        StringBuffer buffer = new StringBuffer();
        if (this.children.size() != 1) {
            return buffer.toString();
        }
        this.buildPrefix(buffer, this);
        return buffer.toString();
    }

    private void buildPrefix(StringBuffer buffer, Trie<V> current) {
        if (current.children.size() != 1) {
            return;
        }
        for (Map.Entry<Character, Trie<V>> entry : current.children.entrySet()) {
            buffer.append(entry.getKey());
            this.buildPrefix(buffer, entry.getValue());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Trie{");
        sb.append("entry=").append(this.entry);
        sb.append(", key=").append(this.key);
        sb.append(", children=").append(this.children);
        sb.append('}');
        return sb.toString();
    }

    public static class Entry<V>
    implements Serializable {
        String prefix;
        V value;

        public Entry() {
        }

        public Entry(String p, V v) {
            this.prefix = p;
            this.value = v;
        }

        public String prefix() {
            return this.prefix;
        }

        public V value() {
            return this.value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Entry{");
            sb.append("prefix='").append(this.prefix).append('\'');
            sb.append(", value=").append(this.value);
            sb.append('}');
            return sb.toString();
        }
    }
}

