/*
 * Decompiled with CFR 0.152.
 */
package cascading.util;

import cascading.util.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SortedListMultiMap<K, V>
extends MultiMap<List<V>, K, V> {
    Comparator<K> comparator = null;
    int initialListSize = 10;

    public SortedListMultiMap() {
    }

    public SortedListMultiMap(int initialListSize) {
        this.initialListSize = initialListSize;
    }

    public SortedListMultiMap(Comparator<K> comparator, int initialListSize) {
        this.comparator = comparator;
        this.initialListSize = initialListSize;
    }

    public V get(K key, int pos) {
        List multiValues = (List)this.getMultiValues(key);
        return (V)multiValues.get(pos);
    }

    public V set(K key, int pos, V value) {
        List multiValues = (List)this.getMultiValues(key);
        return multiValues.set(pos, value);
    }

    @Override
    protected Map<K, List<V>> createMap() {
        return new TreeMap(this.comparator);
    }

    @Override
    protected List<V> createCollection() {
        return new ArrayList(this.initialListSize);
    }

    @Override
    protected List<V> emptyCollection() {
        return Collections.emptyList();
    }

    public Map.Entry<K, List<V>> firstEntry() {
        return ((TreeMap)this.getMap()).firstEntry();
    }

    public Map.Entry<K, List<V>> pollFirstEntry() {
        return ((TreeMap)this.getMap()).pollFirstEntry();
    }
}

