/*
 * Decompiled with CFR 0.152.
 */
package cascading.util;

import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownUtil {
    public static final String SHUTDOWN_EXECUTING = "cascading.jvm.shutdown.executing";
    public static final String SHUTDOWN_FORCE_NON_DAEMON = "cascading.jvm.shutdown.non-daemon";
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownUtil.class);
    private static Queue<Hook> queue = new PriorityBlockingQueue<Hook>(20, new Comparator<Hook>(){

        @Override
        public int compare(Hook lhs, Hook rhs) {
            if (lhs == rhs) {
                return 0;
            }
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            return lhs.priority().compareTo(rhs.priority());
        }
    });
    private static Thread shutdownHook;

    public static void addHook(Hook hook) {
        if (hook == null) {
            throw new IllegalArgumentException("hook may not be null");
        }
        ShutdownUtil.registerShutdownHook();
        queue.add(hook);
    }

    public static boolean removeHook(Hook hook) {
        return queue.remove(hook);
    }

    public static synchronized void registerShutdownHook() {
        if (shutdownHook != null) {
            return;
        }
        final boolean isForceNonDaemon = Boolean.getBoolean(SHUTDOWN_FORCE_NON_DAEMON);
        shutdownHook = new Thread("cascading shutdown hooks"){
            {
                super(x0);
                if (isForceNonDaemon) {
                    this.setDaemon(false);
                }
            }

            @Override
            public void run() {
                block7: {
                    System.setProperty(ShutdownUtil.SHUTDOWN_EXECUTING, "true");
                    block5: while (true) {
                        while (!queue.isEmpty()) {
                            Hook hook = null;
                            try {
                                hook = (Hook)queue.poll();
                                if (hook == null) continue;
                                hook.execute();
                                continue block5;
                            }
                            catch (Exception exception) {
                                LOG.error("failed executing hook: {}, with exception: {}", (Object)hook, (Object)exception.getMessage());
                                LOG.debug("with exception trace", (Throwable)exception);
                            }
                        }
                        break block7;
                        {
                            continue block5;
                            break;
                        }
                        break;
                    }
                    finally {
                        System.setProperty(ShutdownUtil.SHUTDOWN_EXECUTING, "false");
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public static void deregisterShutdownHook() {
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
    }

    public static abstract class Hook {
        public abstract Priority priority();

        public abstract void execute();

        public static enum Priority {
            FIRST,
            WORK_PARENT,
            WORK_CHILD,
            SERVICE_CONSUMER,
            SERVICE_PROVIDER,
            LAST;

        }
    }
}

