/*
 * Decompiled with CFR 0.152.
 */
package cascading.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class MultiMap<C extends Collection<V>, K, V>
implements Serializable {
    private Map<K, C> map = null;

    protected Map<K, C> getMap() {
        if (this.map == null) {
            this.map = this.createMap();
        }
        return this.map;
    }

    protected abstract Map<K, C> createMap();

    protected abstract C createCollection();

    protected abstract C emptyCollection();

    public boolean containsKey(K key) {
        return this.getMap().containsKey(key);
    }

    public Set<K> getKeys() {
        return this.getMap().keySet();
    }

    public Set<Map.Entry<K, C>> getEntries() {
        return this.getMap().entrySet();
    }

    public void addAll(MultiMap<C, K, V> sourceMap) {
        if (sourceMap == null) {
            return;
        }
        Map<K, C> destinationMap = sourceMap.getMap();
        for (Map.Entry<K, C> entry : destinationMap.entrySet()) {
            this.addAll(entry.getKey(), (Collection)entry.getValue());
        }
    }

    public void put(K key, V value) {
        this.getMultiValues(key).add(value);
    }

    public C remove(K key) {
        return (C)((Collection)this.getMap().remove(key));
    }

    protected C getMultiValues(K key) {
        Map<K, C> map = this.getMap();
        Collection<Object> values = (Collection)map.get(key);
        if (values == null) {
            values = this.createCollection();
            map.put(key, values);
        }
        return (C)values;
    }

    public void addAll(K key, V ... values) {
        this.addAll(key, (Collection<V>)Arrays.asList(values));
    }

    public void addAll(K key, Collection<V> values) {
        this.getMultiValues(key).addAll(values);
    }

    public C getValues() {
        if (this.getMap().isEmpty()) {
            return this.emptyCollection();
        }
        C results = this.createCollection();
        for (Collection values : this.getMap().values()) {
            results.addAll(values);
        }
        return results;
    }

    public C getValues(K key) {
        Collection values = (Collection)this.getMap().get(key);
        if (values == null) {
            return this.emptyCollection();
        }
        return (C)values;
    }

    public C getAllValues(K ... keys) {
        if (keys.length == 0) {
            return this.emptyCollection();
        }
        if (keys.length == 1) {
            return this.getValues(keys[0]);
        }
        C values = this.createCollection();
        for (K key : keys) {
            Collection current = (Collection)this.getMap().get(key);
            if (current == null) continue;
            values.addAll(current);
        }
        return values;
    }

    public Set<K> getKeysFor(V value) {
        HashSet<K> results = new HashSet<K>();
        for (Map.Entry<K, C> entry : this.getMap().entrySet()) {
            if (!((Collection)entry.getValue()).contains(value)) continue;
            results.add(entry.getKey());
        }
        return results;
    }

    public boolean hasKey(V value) {
        Set<K> keys = this.getKeysFor(value);
        return keys != null && !keys.isEmpty();
    }

    public boolean hadKey(K key, V value) {
        Collection values = (Collection)this.getMap().get(key);
        return values != null && values.contains(value);
    }

    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MultiMap{");
        sb.append("map=").append(this.getMap());
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MultiMap)) {
            return false;
        }
        MultiMap multiMap = (MultiMap)object;
        return !(this.map != null ? !this.map.equals(multiMap.map) : multiMap.map != null);
    }

    public int hashCode() {
        return this.map != null ? this.map.hashCode() : 0;
    }
}

