/*
 * Decompiled with CFR 0.152.
 */
package cascading.util;

import cascading.flow.FlowProcess;
import cascading.util.Util;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;

public class LogUtil {
    static Set<String> cache = new HashSet<String>();

    public static String[] setLog4jLevel(String[] contexts, String level) {
        String[] results = new String[contexts.length];
        for (int i = 0; i < contexts.length; ++i) {
            results[i] = LogUtil.setLog4jLevel(contexts[i], level);
        }
        return results;
    }

    public static String[] setLog4jLevel(String[] contexts, String[] levels) {
        String[] results = new String[contexts.length];
        for (int i = 0; i < contexts.length; ++i) {
            results[i] = LogUtil.setLog4jLevel(contexts[i], levels[i]);
        }
        return results;
    }

    public static void setLog4jLevel(String[] logger) {
        LogUtil.setLog4jLevel(logger[0], logger[1]);
    }

    public static String setLog4jLevel(String logger, String level) {
        Object loggerObject = Util.invokeStaticMethod("org.apache.log4j.Logger", "getLogger", new Object[]{logger}, new Class[]{String.class});
        Object levelObject = null;
        if (level != null) {
            levelObject = Util.invokeStaticMethod("org.apache.log4j.Level", "toLevel", new Object[]{level}, new Class[]{String.class});
        }
        Object oldLevel = Util.invokeInstanceMethod(loggerObject, "getLevel", new Object[0], new Class[0]);
        Util.invokeInstanceMethod(loggerObject, "setLevel", new Object[]{levelObject}, new Class[]{Util.loadClass("org.apache.log4j.Level")});
        if (oldLevel == null) {
            return null;
        }
        return oldLevel.toString();
    }

    public static void logMemory(Logger logger, String message) {
        Runtime runtime = Runtime.getRuntime();
        long freeMem = runtime.freeMemory() / 1024L / 1024L;
        long maxMem = runtime.maxMemory() / 1024L / 1024L;
        long totalMem = runtime.totalMemory() / 1024L / 1024L;
        logger.info(message + " (mb), free: " + freeMem + ", total: " + totalMem + ", max: " + maxMem);
    }

    public static void logCounters(Logger logger, String message, FlowProcess flowProcess) {
        String[] split;
        String counters = flowProcess.getStringProperty("cascading.flow.runtime.log.counters");
        if (counters == null) {
            return;
        }
        for (String value : split = counters.split(",")) {
            String[] counter = value.split(":");
            logger.info("{} {}.{}={}", new Object[]{message, counter[0], counter[1], flowProcess.getCounterValue(counter[0], counter[1])});
        }
    }

    public static void logWarnOnce(Logger log, String message, Object arg) {
        if (cache.add(log.getName() + message)) {
            log.warn(message, arg);
        }
    }
}

