/*
 * Decompiled with CFR 0.152.
 */
package cascading.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class LazyIterable<V, T>
implements Iterable<T> {
    LinkedList<T> cache;
    Iterable<V> iterable;

    public LazyIterable(V ... values) {
        this((Iterable<V>)Arrays.asList(values));
    }

    public LazyIterable(boolean enableCache, V ... values) {
        this(enableCache, (Iterable<V>)Arrays.asList(values));
    }

    public LazyIterable(Iterable<V> iterable) {
        this(true, iterable);
    }

    public LazyIterable(boolean enableCache, Iterable<V> iterable) {
        if (enableCache) {
            this.cache = new LinkedList();
        }
        this.iterable = iterable;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.cache != null && !this.cache.isEmpty()) {
            return this.cache.iterator();
        }
        final Iterator<V> iterator = this.iterable.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                Object converted = LazyIterable.this.convert(iterator.next());
                if (LazyIterable.this.cache != null) {
                    LazyIterable.this.cache.add(converted);
                }
                return converted;
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    protected abstract T convert(V var1);
}

