/*
 * Decompiled with CFR 0.152.
 */
package cascading.util;

import cascading.flow.FlowElement;
import cascading.flow.planner.Scope;
import cascading.flow.planner.graph.ElementGraph;
import cascading.flow.planner.graph.Extent;
import cascading.flow.planner.process.ProcessGraph;
import cascading.flow.planner.process.ProcessModel;
import cascading.flow.planner.process.ProcessModels;
import cascading.tap.Tap;
import cascading.util.Pair;
import cascading.util.Util;
import cascading.util.jgrapht.ComponentAttributeProvider;
import cascading.util.jgrapht.EdgeNameProvider;
import cascading.util.jgrapht.VertexNameProvider;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DOTProcessGraphWriter {
    public static final String INDENT = "  ";
    public static final String CONNECTOR = " -> ";
    private VertexNameProvider<Pair<ElementGraph, FlowElement>> vertexIDProvider;
    private VertexNameProvider<FlowElement> vertexLabelProvider;
    private EdgeNameProvider<Scope> edgeLabelProvider;
    private ComponentAttributeProvider<FlowElement> vertexAttributeProvider;
    private ComponentAttributeProvider<Scope> edgeAttributeProvider;
    private VertexNameProvider<ProcessModel> clusterIDProvider;
    private VertexNameProvider<ProcessModel> clusterLabelProvider;
    Map<FlowElement, String> colors = new HashMap<FlowElement, String>();
    float hue = 0.3f;

    public DOTProcessGraphWriter(VertexNameProvider<Pair<ElementGraph, FlowElement>> vertexIDProvider, VertexNameProvider<FlowElement> vertexLabelProvider, EdgeNameProvider<Scope> edgeLabelProvider, ComponentAttributeProvider<FlowElement> vertexAttributeProvider, ComponentAttributeProvider<Scope> edgeAttributeProvider, VertexNameProvider<ProcessModel> clusterIDProvider, VertexNameProvider<ProcessModel> clusterLabelProvider) {
        this.vertexIDProvider = vertexIDProvider;
        this.vertexLabelProvider = vertexLabelProvider;
        this.edgeLabelProvider = edgeLabelProvider;
        this.vertexAttributeProvider = vertexAttributeProvider;
        this.edgeAttributeProvider = edgeAttributeProvider;
        this.clusterIDProvider = clusterIDProvider;
        this.clusterLabelProvider = clusterLabelProvider;
    }

    public void writeGraph(Writer writer, ElementGraph parentGraph, ProcessGraph<? extends ProcessModel> processGraph) {
        PrintWriter out = new PrintWriter(writer);
        out.println("digraph G {");
        Set<FlowElement> spanElements = this.getSpanElements(processGraph);
        Set<FlowElement> identityElements = this.getIdentityElements(processGraph);
        Set<FlowElement> duplicatedElements = processGraph.getDuplicatedElements(parentGraph);
        this.writeVertexSet(null, parentGraph, parentGraph, out, spanElements, true, duplicatedElements, identityElements);
        this.writeEdgeSet(processGraph, parentGraph, parentGraph, out, spanElements, true, identityElements);
        Iterator<? extends ProcessModel> topologicalIterator = processGraph.getOrdinalTopologicalIterator();
        while (topologicalIterator.hasNext()) {
            ProcessModel processModel = topologicalIterator.next();
            out.println();
            out.print("subgraph cluster_");
            out.print(this.clusterIDProvider.getVertexName(processModel));
            out.println(" {");
            out.print(INDENT);
            out.print("label = \"");
            out.print(this.clusterLabelProvider.getVertexName(processModel));
            out.println("\";");
            out.println();
            this.writeVertexSet(processModel, parentGraph, processModel.getElementGraph(), out, spanElements, false, duplicatedElements, identityElements);
            this.writeEdgeSet(processGraph, parentGraph, processModel.getElementGraph(), out, spanElements, false, identityElements);
            out.println("}");
        }
        out.println("}");
        out.flush();
    }

    protected Set<FlowElement> getIdentityElements(ProcessGraph<? extends ProcessModel> processGraph) {
        HashSet<FlowElement> candidates = new HashSet<FlowElement>();
        for (ElementGraph elementGraph : processGraph.getIdentityElementGraphs()) {
            if (Util.contains(Tap.class, elementGraph.vertexSet())) continue;
            candidates.addAll(elementGraph.vertexSet());
        }
        candidates.remove(Extent.head);
        candidates.remove(Extent.tail);
        HashSet<FlowElement> identityElements = new HashSet<FlowElement>();
        for (FlowElement identityElement : candidates) {
            if (processGraph.getElementProcesses(identityElement).size() != 1) continue;
            identityElements.add(identityElement);
        }
        return identityElements;
    }

    protected Set<FlowElement> getSpanElements(ProcessGraph<? extends ProcessModel> processGraph) {
        HashSet<FlowElement> spanElements = new HashSet<FlowElement>();
        spanElements.add(Extent.head);
        spanElements.add(Extent.tail);
        spanElements.addAll(processGraph.getAllSourceElements());
        spanElements.addAll(processGraph.getAllSinkElements());
        spanElements.removeAll(processGraph.getSourceTaps());
        spanElements.removeAll(processGraph.getSinkTaps());
        return spanElements;
    }

    protected void writeEdgeSet(ProcessGraph<? extends ProcessModel> processGraph, ElementGraph parentGraph, ElementGraph currentGraph, PrintWriter out, Set<FlowElement> spansClusters, boolean renderSpans, Set<FlowElement> identityElements) {
        out.println();
        for (Scope scope : currentGraph.edgeSet()) {
            FlowElement edgeSource = currentGraph.getEdgeSource(scope);
            FlowElement edgeTarget = currentGraph.getEdgeTarget(scope);
            boolean sourceSpans = spansClusters.contains(edgeSource);
            boolean targetSpans = spansClusters.contains(edgeTarget);
            boolean spans = sourceSpans || targetSpans;
            boolean sourceIdentity = identityElements.contains(edgeSource);
            boolean targetIdentity = identityElements.contains(edgeTarget);
            if (sourceIdentity && targetIdentity) {
                spans = false;
            }
            if (spans != renderSpans) continue;
            List<ElementGraph> sourceGraphs = Arrays.asList(currentGraph);
            List<ElementGraph> targetGraphs = Arrays.asList(currentGraph);
            if (sourceIdentity && targetIdentity) {
                sourceGraphs = Arrays.asList(parentGraph);
                targetGraphs = Arrays.asList(parentGraph);
            } else if (sourceSpans && targetSpans) {
                sourceGraphs = Arrays.asList(currentGraph);
                targetGraphs = Arrays.asList(currentGraph);
            } else if (sourceSpans) {
                sourceGraphs = Arrays.asList(parentGraph);
                targetGraphs = processGraph.getElementGraphs(edgeTarget);
            } else if (targetSpans) {
                sourceGraphs = processGraph.getElementGraphs(edgeSource);
                targetGraphs = Arrays.asList(parentGraph);
            }
            for (ElementGraph sourceGraph : sourceGraphs) {
                for (ElementGraph targetGraph : targetGraphs) {
                    this.writeEdge(out, scope, edgeSource, edgeTarget, sourceGraph, targetGraph);
                }
            }
        }
    }

    private void writeEdge(PrintWriter out, Scope scope, FlowElement edgeSource, FlowElement edgeTarget, ElementGraph sourceGraph, ElementGraph targetGraph) {
        String source = this.getVertexID(sourceGraph, edgeSource);
        String target = this.getVertexID(targetGraph, edgeTarget);
        out.print(INDENT + source + CONNECTOR + target);
        String labelName = null;
        if (this.edgeLabelProvider != null) {
            labelName = this.edgeLabelProvider.getEdgeName(scope);
        }
        Map<String, String> attributes = null;
        if (this.edgeAttributeProvider != null) {
            attributes = this.edgeAttributeProvider.getComponentAttributes(scope);
        }
        this.renderAttributes(out, labelName, attributes);
        out.println(";");
    }

    protected void writeVertexSet(ProcessModel processModel, ElementGraph parentGraph, ElementGraph currentGraph, PrintWriter out, Set<FlowElement> spansClusters, boolean onlySpans, Set<FlowElement> duplicatedElements, Set<FlowElement> identityElements) {
        boolean isIdentityGraph = false;
        if (processModel != null) {
            isIdentityGraph = ProcessModels.isIdentity(processModel, Tap.class);
        }
        for (FlowElement flowElement : currentGraph.vertexSet()) {
            boolean spans = spansClusters.contains(flowElement);
            boolean isIdentity = identityElements.contains(flowElement);
            if (isIdentity && isIdentityGraph) continue;
            if (isIdentity) {
                spans = false;
            }
            if (spans != onlySpans) continue;
            out.print(INDENT + this.getVertexID(isIdentity ? parentGraph : currentGraph, flowElement));
            String labelName = null;
            if (this.vertexLabelProvider != null) {
                labelName = this.vertexLabelProvider.getVertexName(flowElement);
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (duplicatedElements.contains(flowElement)) {
                attributes.put("color", this.getHSBColorFor(flowElement));
            }
            if (this.vertexAttributeProvider != null) {
                attributes.putAll(this.vertexAttributeProvider.getComponentAttributes(flowElement));
            }
            this.renderAttributes(out, labelName, attributes);
            out.println(";");
        }
    }

    private void renderAttributes(PrintWriter out, String labelName, Map<String, String> attributes) {
        if (labelName == null && attributes == null) {
            return;
        }
        out.print(" [ ");
        if (labelName == null) {
            labelName = attributes.get("label");
        }
        if (labelName != null) {
            out.print("label=\"" + labelName + "\" ");
        }
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String name = entry.getKey();
                if (name.equals("label")) continue;
                out.print(name + "=\"" + entry.getValue() + "\" ");
            }
        }
        out.print("]");
    }

    private String getVertexID(ElementGraph elementGraph, FlowElement flowElement) {
        return this.vertexIDProvider.getVertexName(new Pair<ElementGraph, FlowElement>(elementGraph, flowElement));
    }

    private String getHSBColorFor(FlowElement flowElement) {
        if (this.colors.containsKey(flowElement)) {
            return this.colors.get(flowElement);
        }
        String result = String.format("%f,%f,%f", 1.0 - (double)this.hue % 1.0, 1.0, 0.9);
        this.colors.put(flowElement, result);
        this.hue = (float)((double)this.hue + (0.075 + 0.025 * Math.floor(this.hue)));
        return result;
    }
}

