/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.util;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.Tuples;
import cascading.tuple.util.CompositeTupleList;
import cascading.tuple.util.NarrowTupleList;
import cascading.tuple.util.ObjectArrayList;
import cascading.tuple.util.OverrideTupleList;
import cascading.tuple.util.Resettable;

public class TupleViews {
    public static Tuple createComposite(Tuple ... tuples) {
        return Tuples.create(new CompositeTupleList(tuples));
    }

    public static Tuple createComposite(Fields ... fields) {
        return Tuples.create(new CompositeTupleList(fields));
    }

    public static Tuple createComposite(Fields[] fields, Tuple[] tuples) {
        return Tuples.create(new CompositeTupleList(fields, tuples));
    }

    public static Tuple createNarrow(int[] basePos) {
        return Tuples.create(new NarrowTupleList(basePos));
    }

    public static Tuple createNarrow(int[] basePos, Tuple tuple) {
        return Tuples.create(new NarrowTupleList(basePos, tuple));
    }

    public static Tuple createOverride(Fields base, Fields override) {
        return Tuples.create(new OverrideTupleList(base, override));
    }

    public static Tuple createOverride(Fields base, Tuple baseTuple, Fields override, Tuple overrideTuple) {
        return Tuples.create(new OverrideTupleList(base, baseTuple, override, overrideTuple));
    }

    public static Tuple createOverride(int[] basePos, Tuple baseTuple, int[] overridePos, Tuple overrideTuple) {
        return Tuples.create(new OverrideTupleList(basePos, baseTuple, overridePos, overrideTuple));
    }

    public static Tuple createObjectArray() {
        return Tuples.create(new ObjectArrayList());
    }

    public static Tuple createObjectArray(Object ... values) {
        return Tuples.create(new ObjectArrayList(values));
    }

    public static <V> Tuple reset(Tuple tuple, V ... values) {
        ((Resettable)((Object)Tuple.elements(tuple))).reset(values);
        return tuple;
    }
}

