/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.util;

import cascading.tuple.Fields;
import cascading.tuple.Hasher;
import cascading.tuple.Tuple;
import cascading.util.Murmur3;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleHasher
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(TupleHasher.class);
    private static HashFunction DEFAULT_HASH_FUNCTION = new HashFunction();
    private static Hasher DEFAULT_HASHER = new ObjectHasher();
    protected HashFunction hashFunction = DEFAULT_HASH_FUNCTION;
    private Hasher[] hashers;

    public TupleHasher() {
    }

    public TupleHasher(Comparator defaultComparator, Comparator[] comparators) {
        this.initialize(defaultComparator, comparators);
    }

    public static Comparator[] merge(Fields[] keyFields) {
        Comparator[] comparators = new Comparator[keyFields[0].size()];
        for (Fields keyField : keyFields) {
            if (keyField == null) continue;
            for (int i = 0; i < keyField.getComparators().length; ++i) {
                Comparator comparator = keyField.getComparators()[i];
                if (!(comparator instanceof Hasher)) continue;
                if (comparators[i] != null && !comparators[i].equals(comparator)) {
                    LOG.warn("two unequal Hasher instances for the same key field position found: {}, and: {}", (Object)comparators[i], (Object)comparator);
                }
                comparators[i] = comparator;
            }
        }
        return comparators;
    }

    public static boolean isNull(Comparator[] comparators) {
        int count = 0;
        for (Comparator comparator : comparators) {
            if (comparator != null) continue;
            ++count;
        }
        return count == comparators.length;
    }

    protected void initialize(Comparator defaultComparator, Comparator[] comparators) {
        Hasher defaultHasher = DEFAULT_HASHER;
        if (defaultComparator instanceof Hasher) {
            defaultHasher = (Hasher)((Object)defaultComparator);
        }
        this.hashers = new Hasher[comparators.length];
        for (int i = 0; i < comparators.length; ++i) {
            Comparator comparator = comparators[i];
            this.hashers[i] = comparator instanceof Hasher ? (Hasher)((Object)comparator) : defaultHasher;
        }
    }

    public final int hashCode(Tuple tuple) {
        return this.getHashFunction().hash(tuple, this.hashers);
    }

    protected HashFunction getHashFunction() {
        return this.hashFunction;
    }

    public static Tuple wrapTuple(TupleHasher tupleHasher, Tuple input) {
        if (tupleHasher == null) {
            return input;
        }
        return new WrappedTuple(tupleHasher, input);
    }

    public static class HashFunction
    implements Serializable {
        public int hash(Tuple tuple, Hasher[] hashers) {
            int hash = -1756908916;
            List<Object> elements = Tuple.elements(tuple);
            for (int i = 0; i < elements.size(); ++i) {
                Object element = elements.get(i);
                int hashCode = hashers[i % hashers.length].hashCode(element);
                hash = Murmur3.mixH1(hash, Murmur3.mixK1(hashCode));
            }
            return Murmur3.fmix(hash, elements.size());
        }
    }

    static class WrappedTuple
    extends Tuple {
        private final TupleHasher tupleHasher;

        public WrappedTuple(TupleHasher tupleHasher, Tuple input) {
            super(Tuple.elements(input));
            this.tupleHasher = tupleHasher;
        }

        @Override
        public int hashCode() {
            return this.tupleHasher.hashCode(this);
        }
    }

    private static class ObjectHasher
    implements Hasher<Object>,
    Serializable {
        private ObjectHasher() {
        }

        @Override
        public int hashCode(Object value) {
            if (value == null) {
                return 0;
            }
            return value.hashCode();
        }
    }
}

