/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.util;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.util.Resettable;
import java.util.AbstractList;
import java.util.Arrays;

class OverrideTupleList
extends AbstractList<Object>
implements Resettable<Tuple> {
    private int[] basePos;
    private Tuple base;
    private int[] overridePos;
    private Tuple override;

    public OverrideTupleList(Fields baseFields, Fields overrideFields) {
        this(baseFields.getPos(), baseFields.getPos(overrideFields));
    }

    public OverrideTupleList(int[] basePos, int[] overridePos) {
        this(basePos, null, overridePos, null);
    }

    public OverrideTupleList(Fields baseFields, Tuple baseTuple, Fields overrideFields, Tuple overrideTuple) {
        this(baseFields.getPos(), baseTuple, overrideFields.getPos(), overrideTuple);
    }

    public OverrideTupleList(int[] basePos, Tuple baseTuple, int[] overridePos, Tuple overrideTuple) {
        this.basePos = basePos;
        this.base = baseTuple;
        this.overridePos = new int[basePos.length];
        Arrays.fill(this.overridePos, -1);
        for (int i = 0; i < overridePos.length; ++i) {
            this.overridePos[overridePos[i]] = i;
        }
        this.override = overrideTuple;
    }

    public void reset(Tuple ... tuples) {
        this.base = tuples[0];
        this.override = tuples[1];
    }

    @Override
    public Object get(int index) {
        if (index >= this.basePos.length) {
            throw new IllegalArgumentException("invalid index: " + index + ", length: " + this.basePos.length);
        }
        if (this.overridePos[index] != -1) {
            return this.override.getObject(this.overridePos[index]);
        }
        return this.base.getObject(this.basePos[index]);
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.get(i);
        }
        return a;
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("OverrideTupleList");
        sb.append("{basePos=").append(this.basePos == null ? "null" : "");
        for (i = 0; this.basePos != null && i < this.basePos.length; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.basePos[i]);
        }
        sb.append(", base=").append(this.base);
        sb.append(", overridePos=").append(this.overridePos == null ? "null" : "");
        for (i = 0; this.overridePos != null && i < this.overridePos.length; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.overridePos[i]);
        }
        sb.append(", override=").append(this.override);
        sb.append('}');
        return sb.toString();
    }
}

