/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.util;

import cascading.tuple.util.Resettable;
import java.util.AbstractList;
import java.util.Arrays;

class ObjectArrayList
extends AbstractList<Object>
implements Resettable<Object> {
    Object[] array;

    ObjectArrayList() {
        this.array = new Object[0];
    }

    ObjectArrayList(Object[] array) {
        this.array = array;
    }

    @Override
    public Object get(int index) {
        if (index >= this.array.length) {
            throw new IllegalArgumentException("invalid index: " + index + ", length: " + this.array.length);
        }
        return this.array[index];
    }

    @Override
    public Object set(int index, Object element) {
        if (index >= this.array.length) {
            throw new IllegalArgumentException("invalid index: " + index + ", length: " + this.array.length);
        }
        this.array[index] = element;
        return this.array[index];
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.get(i);
        }
        return a;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public void reset(Object ... values) {
        this.array = values;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectArrayList");
        sb.append("{array=").append(this.array == null ? "null" : Arrays.asList(this.array).toString());
        sb.append('}');
        return sb.toString();
    }
}

