/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.util;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.util.Resettable;
import java.util.AbstractList;

class NarrowTupleList
extends AbstractList<Object>
implements Resettable<Tuple> {
    private int[] basePos;
    private Tuple base;

    public NarrowTupleList(Fields fields) {
        this(fields.getPos(), null);
    }

    public NarrowTupleList(int[] basePos) {
        this(basePos, null);
    }

    public NarrowTupleList(Fields fields, Tuple base) {
        this(fields.getPos(), base);
    }

    public NarrowTupleList(int[] basePos, Tuple base) {
        this.basePos = basePos;
        this.base = base;
    }

    public void reset(Tuple ... bases) {
        if (bases.length != 1) {
            throw new IllegalArgumentException("wrong number of arguments, only expected one Tuple");
        }
        this.base = bases[0];
    }

    @Override
    public Object get(int index) {
        if (index >= this.basePos.length) {
            throw new IllegalArgumentException("invalid index: " + index + ", length: " + this.basePos.length);
        }
        return this.base.getObject(this.basePos[index]);
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.get(i);
        }
        return a;
    }

    @Override
    public int size() {
        return this.basePos.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NarrowTupleList");
        sb.append("{basePos=").append(this.basePos == null ? "null" : "");
        for (int i = 0; this.basePos != null && i < this.basePos.length; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.basePos[i]);
        }
        sb.append(", base=").append(this.base);
        sb.append('}');
        return sb.toString();
    }
}

