/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.util;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.util.Resettable;
import java.util.AbstractList;
import java.util.Arrays;

class CompositeTupleList
extends AbstractList<Object>
implements Resettable<Tuple> {
    private int[][] basePos;
    private Tuple[] bases;
    private int[] skip;
    private int length;

    private static int[][] makePos(Tuple[] bases) {
        int[][] pos = new int[bases.length][];
        for (int i = 0; i < bases.length; ++i) {
            Tuple base = bases[i];
            pos[i] = Fields.size(base.size()).getPos();
        }
        return pos;
    }

    private static int[][] makePos(Fields[] fields) {
        int[][] pos = new int[fields.length][];
        for (int i = 0; i < fields.length; ++i) {
            pos[i] = fields[i].getPos();
        }
        return pos;
    }

    public CompositeTupleList(Fields ... fields) {
        this(CompositeTupleList.makePos(fields), new Tuple[fields.length]);
    }

    public CompositeTupleList(int[] ... basePos) {
        this(basePos, new Tuple[basePos.length]);
    }

    public CompositeTupleList(Tuple ... bases) {
        this(CompositeTupleList.makePos(bases), bases);
    }

    public CompositeTupleList(Fields[] fields, Tuple[] bases) {
        this(CompositeTupleList.makePos(fields), bases);
    }

    protected CompositeTupleList(Fields fields, Tuple base) {
        this((int[][])new int[][]{fields.getPos()}, new Tuple[]{base});
    }

    protected CompositeTupleList(int[] basePos, Tuple base) {
        this((int[][])new int[][]{basePos}, new Tuple[]{base});
    }

    public CompositeTupleList(int[][] basePos, Tuple[] bases) {
        this.basePos = basePos;
        this.bases = bases;
        this.skip = new int[basePos.length + 1];
        for (int i = 0; i < basePos.length; ++i) {
            this.skip[i + 1] = this.skip[i] + basePos[i].length;
            this.length += basePos[i].length;
        }
    }

    public void reset(Tuple ... bases) {
        if (this.basePos.length != bases.length) {
            throw new IllegalArgumentException("bases is wrong length, expects: " + this.basePos.length + ", got: " + bases.length);
        }
        this.bases = bases;
    }

    @Override
    public Object get(int index) {
        for (int i = 0; i < this.basePos.length; ++i) {
            if (index >= this.skip[i + 1]) continue;
            return this.bases[i].getObject(this.basePos[i][index - this.skip[i]]);
        }
        throw new IllegalArgumentException("invalid index: " + index + ", length: " + this.basePos.length);
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.get(i);
        }
        return a;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompositeTupleList");
        sb.append("{basePos=").append(this.basePos == null ? "null" : Arrays.asList(this.basePos).toString());
        sb.append(", bases=").append(this.bases == null ? "null" : Arrays.asList(this.bases).toString());
        sb.append(", skip=").append(this.skip == null ? "null" : "");
        for (int i = 0; this.skip != null && i < this.skip.length; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.skip[i]);
        }
        sb.append(", length=").append(this.length);
        sb.append('}');
        return sb.toString();
    }
}

