/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.type;

import cascading.CascadingException;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import cascading.tuple.type.CoercionFrom;
import cascading.tuple.type.ToCanonical;
import cascading.util.Util;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;

public class DateType
implements CoercibleType<Long> {
    protected TimeZone zone;
    protected Locale locale;
    protected String dateFormatString;
    private transient SimpleDateFormat dateFormat;

    public DateType(String dateFormatString, TimeZone zone, Locale locale) {
        this.zone = zone;
        this.locale = locale;
        this.dateFormatString = dateFormatString;
    }

    public DateType(String dateFormatString, TimeZone zone) {
        this.zone = zone;
        this.dateFormatString = dateFormatString;
    }

    public DateType(String dateFormatString) {
        this.dateFormatString = dateFormatString;
    }

    @Override
    public Class getCanonicalType() {
        return Long.TYPE;
    }

    public SimpleDateFormat getDateFormat() {
        if (this.dateFormat != null) {
            return this.dateFormat;
        }
        this.dateFormat = new SimpleDateFormat(this.dateFormatString, this.getLocale());
        this.dateFormat.setTimeZone(this.getZone());
        return this.dateFormat;
    }

    private Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return Locale.getDefault();
    }

    private TimeZone getZone() {
        if (this.zone != null) {
            return this.zone;
        }
        return TimeZone.getTimeZone("UTC");
    }

    protected Calendar getCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"), this.getLocale());
    }

    @Override
    public <T> ToCanonical<T, Long> from(Type from) {
        if (from == Long.class) {
            return v -> (Long)v;
        }
        if (from == String.class) {
            return v -> v == null ? null : Long.valueOf(this.parse((String)v).getTime());
        }
        if (from == Date.class) {
            return v -> v == null ? null : Long.valueOf(((Date)v).getTime());
        }
        return this::canonical;
    }

    @Override
    public Long canonical(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> from = value.getClass();
        if (from == Long.class) {
            return (Long)value;
        }
        if (from == String.class) {
            return this.parse((String)value).getTime();
        }
        if (from == Date.class) {
            return ((Date)value).getTime();
        }
        throw new CascadingException("unknown type coercion requested from: " + Util.getTypeName(from));
    }

    @Override
    public <T> CoercionFrom<Long, T> to(Type to) {
        boolean returnZero = Coercions.primitives.containsKey(to);
        if (to == Long.class || to == Long.TYPE || to == Object.class || DateType.class == to.getClass()) {
            return v -> v == null ? this.nullCoercion(returnZero) : v;
        }
        if (to == String.class) {
            return v -> v == null ? this.nullCoercion(returnZero) : this.toString((Long)v);
        }
        return CoercibleType.super.to(to);
    }

    @Override
    public Object coerce(Object value, Type to) {
        if (value == null) {
            return this.nullCoercion(Coercions.primitives.containsKey(to));
        }
        Class<?> from = value.getClass();
        if (from != Long.class) {
            throw new IllegalStateException("was not normalized");
        }
        if (to == Long.class || to == Long.TYPE || to == Object.class || DateType.class == to.getClass()) {
            return value;
        }
        if (to == String.class) {
            return this.toString((Long)value);
        }
        Coercions.Coerce coerce = Coercions.coercions.get(to);
        if (coerce != null) {
            return coerce.coerce(value);
        }
        throw new CascadingException("unknown type coercion requested, from: " + Util.getTypeName(from) + " to: " + Util.getTypeName(to));
    }

    private Object nullCoercion(boolean returnZero) {
        if (returnZero) {
            return 0;
        }
        return null;
    }

    protected String toString(Long value) {
        Calendar calendar = this.getCalendar();
        calendar.setTimeInMillis(value);
        return this.getDateFormat().format(calendar.getTime());
    }

    protected Date parse(String value) {
        try {
            return this.getDateFormat().parse(value);
        }
        catch (ParseException exception) {
            throw new CascadingException("unable to parse value: " + value + " with format: " + this.dateFormatString);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DateType)) {
            return false;
        }
        DateType dateType = (DateType)object;
        return Objects.equals(this.zone, dateType.zone) && Objects.equals(this.locale, dateType.locale) && Objects.equals(this.dateFormatString, dateType.dateFormatString);
    }

    public int hashCode() {
        return Objects.hash(this.zone, this.locale, this.dateFormatString);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DateType{");
        sb.append("dateFormatString='").append(this.dateFormatString).append('\'');
        sb.append(",");
        sb.append("canonicalType='").append(this.getCanonicalType()).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

