/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.io;

import cascading.tuple.Tuple;
import cascading.tuple.io.IndexTuple;
import cascading.tuple.io.TuplePair;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TupleOutputStream
extends DataOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(TupleOutputStream.class);
    private final Map<Class, TupleElementWriter> tupleUnTypedElementWriters;
    private final Map<Class, TupleElementWriter> tupleTypedElementWriters;
    final ElementWriter elementWriter;

    public TupleOutputStream(Map<Class, TupleElementWriter> tupleUnTypedElementWriters, Map<Class, TupleElementWriter> tupleTypedElementWriters, OutputStream outputStream, ElementWriter elementWriter) {
        super(outputStream);
        this.tupleUnTypedElementWriters = tupleUnTypedElementWriters;
        this.tupleTypedElementWriters = tupleTypedElementWriters;
        this.elementWriter = elementWriter;
    }

    public final TupleElementWriter getWriterFor(final Class type) throws IOException {
        TupleElementWriter tupleElementWriter = this.tupleTypedElementWriters.get(type);
        if (tupleElementWriter != null) {
            return tupleElementWriter;
        }
        return new TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                TupleOutputStream.this.elementWriter.write(stream, type, element);
            }
        };
    }

    public void writeTuple(Tuple tuple) throws IOException {
        this.write(tuple);
    }

    public void writeTuplePair(TuplePair tuplePair) throws IOException {
        Tuple[] tuples = TuplePair.tuples(tuplePair);
        this.write(tuples[0]);
        this.write(tuples[1]);
    }

    public abstract void writeIndexTuple(IndexTuple var1) throws IOException;

    private void write(Tuple tuple) throws IOException {
        this.writeUnTyped(tuple);
    }

    public void writeWith(TupleElementWriter[] writers, Tuple tuple) throws IOException {
        List<Object> elements = Tuple.elements(tuple);
        for (int i = 0; i < writers.length; ++i) {
            writers[i].write(this, elements.get(i));
        }
    }

    public void writeTyped(Class[] classes, Tuple tuple) throws IOException {
        List<Object> elements = Tuple.elements(tuple);
        for (int i = 0; i < classes.length; ++i) {
            Class type = classes[i];
            this.writeTypedElement(type, elements.get(i));
        }
    }

    public void writeUnTyped(Tuple tuple) throws IOException {
        List<Object> elements = Tuple.elements(tuple);
        this.writeIntInternal(elements.size());
        for (Object element : elements) {
            this.writeElement(element);
        }
    }

    public void writeElementArray(Object[] elements) throws IOException {
        this.writeIntInternal(elements.length);
        for (Object element : elements) {
            this.writeElement(element);
        }
    }

    public final void writeTypedElement(Class type, Object element) throws IOException {
        TupleElementWriter tupleElementWriter = this.tupleTypedElementWriters.get(type);
        if (tupleElementWriter != null) {
            tupleElementWriter.write(this, element);
        } else {
            this.elementWriter.write(this, type, element);
        }
    }

    public final void writeElement(Object element) throws IOException {
        if (element == null) {
            this.writeIntInternal(0);
            return;
        }
        Class<?> type = element.getClass();
        TupleElementWriter tupleElementWriter = this.tupleUnTypedElementWriters.get(type);
        if (tupleElementWriter != null) {
            tupleElementWriter.write(this, element);
        } else {
            this.elementWriter.write(this, element);
        }
    }

    protected abstract void writeIntInternal(int var1) throws IOException;

    @Override
    public void close() throws IOException {
        LOG.debug("closing tuple output stream");
        try {
            super.close();
        }
        finally {
            if (this.elementWriter != null) {
                this.elementWriter.close();
            }
        }
    }

    public static interface ElementWriter {
        public void write(DataOutputStream var1, Object var2) throws IOException;

        public void write(DataOutputStream var1, Class<?> var2, Object var3) throws IOException;

        public void close();
    }

    public static interface TupleElementWriter {
        public void write(TupleOutputStream var1, Object var2) throws IOException;
    }
}

