/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.collect;

import cascading.flow.FlowProcess;
import cascading.tuple.Tuple;
import cascading.tuple.collect.Spillable;
import java.util.Collection;
import java.util.HashMap;

public abstract class SpillableTupleMap
extends HashMap<Tuple, Collection<Tuple>>
implements Spillable {
    private int mapThreshold;
    private int initListThreshold;
    private Spillable.SpillListener spillListener = Spillable.SpillListener.NULL;

    public static int getMapThreshold(FlowProcess flowProcess, int defaultValue) {
        String value = (String)flowProcess.getProperty("cascading.spill.map.threshold");
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static int getMapCapacity(FlowProcess flowProcess, int defaultValue) {
        String value = (String)flowProcess.getProperty("cascading.spill.map.capacity");
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static float getMapLoadFactor(FlowProcess flowProcess, float defaultValue) {
        String value = (String)flowProcess.getProperty("cascading.spill.map.loadfactor");
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Float.parseFloat(value);
    }

    public SpillableTupleMap(int mapThreshold, int initListThreshold) {
        super(100000, 0.75f);
        this.mapThreshold = mapThreshold;
        this.initListThreshold = initListThreshold;
    }

    public SpillableTupleMap(int initialCapacity, float loadFactor, int mapThreshold, int initListThreshold) {
        super(initialCapacity, loadFactor);
        this.mapThreshold = mapThreshold;
        this.initListThreshold = initListThreshold;
    }

    protected int getMapThreshold() {
        return this.mapThreshold;
    }

    public int getInitListThreshold() {
        return this.initListThreshold;
    }

    @Override
    public Collection<Tuple> get(Object object) {
        Collection<Tuple> value = (Collection<Tuple>)super.get(object);
        if (value == null) {
            value = this.createTupleCollection((Tuple)object);
            super.put((Tuple)object, value);
        }
        return value;
    }

    protected abstract Collection<Tuple> createTupleCollection(Tuple var1);

    @Override
    public void setGrouping(Tuple group) {
    }

    @Override
    public Tuple getGrouping() {
        return null;
    }

    @Override
    public void setSpillStrategy(Spillable.SpillStrategy spillStrategy) {
    }

    @Override
    public int spillCount() {
        return 0;
    }

    public Spillable.SpillListener getSpillListener() {
        return this.spillListener;
    }

    @Override
    public void setSpillListener(Spillable.SpillListener spillListener) {
        this.spillListener = spillListener;
    }
}

