/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.collect;

import cascading.flow.FlowProcess;
import cascading.tuple.Tuple;
import cascading.tuple.TupleException;
import cascading.tuple.collect.Spillable;
import cascading.tuple.io.TupleInputStream;
import cascading.tuple.io.TupleOutputStream;
import cascading.tuple.util.TupleViews;
import cascading.util.CloseableIterator;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpillableTupleList
implements Collection<Tuple>,
Spillable {
    private static final Logger LOG = LoggerFactory.getLogger(SpillableTupleList.class);
    private Spillable.SpillStrategy spillStrategy;
    private List<File> files = Collections.EMPTY_LIST;
    private final List<Object[]> current = new LinkedList<Object[]>();
    private int size = 0;
    private Spillable.SpillListener spillListener = Spillable.SpillListener.NULL;
    private Tuple group;

    public static int getThreshold(FlowProcess flowProcess, int defaultValue) {
        String value = (String)flowProcess.getProperty("cascading.spill.list.threshold");
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    protected static Class getCodecClass(FlowProcess flowProcess, String defaultCodecs, Class subClass) {
        String compress = (String)flowProcess.getProperty("cascading.spill.compress");
        if (compress != null && !Boolean.parseBoolean(compress)) {
            return null;
        }
        String codecs = (String)flowProcess.getProperty("cascading.spill.codecs");
        if (codecs == null || codecs.length() == 0) {
            codecs = defaultCodecs;
        }
        Class codecClass = null;
        for (String codec : codecs.split("[,\\s]+")) {
            try {
                LOG.info("attempting to load codec: {}", (Object)codec);
                codecClass = Thread.currentThread().getContextClassLoader().loadClass(codec).asSubclass(subClass);
                if (codecClass == null) continue;
                LOG.info("found codec: {}", (Object)codec);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (codecClass == null) {
            LOG.warn("codecs set, but unable to load any: {}", (Object)codecs);
            return null;
        }
        return codecClass;
    }

    protected SpillableTupleList(final int threshold) {
        this(new Spillable.SpillStrategy(){

            @Override
            public boolean doSpill(Spillable spillable, int size) {
                return size >= threshold;
            }

            @Override
            public String getSpillReason(Spillable spillable) {
                return "met threshold: " + threshold;
            }
        });
    }

    protected SpillableTupleList(Spillable.SpillStrategy spillStrategy) {
        this.spillStrategy = spillStrategy;
    }

    @Override
    public void setGrouping(Tuple group) {
        this.group = group;
    }

    @Override
    public Tuple getGrouping() {
        return this.group;
    }

    @Override
    public void setSpillStrategy(Spillable.SpillStrategy spillStrategy) {
        this.spillStrategy = spillStrategy;
    }

    @Override
    public void setSpillListener(Spillable.SpillListener spillListener) {
        this.spillListener = spillListener;
    }

    @Override
    public int spillCount() {
        return this.files.size();
    }

    @Override
    public boolean add(Tuple tuple) {
        this.doSpill();
        this.current.add(Tuple.elements(tuple).toArray(new Object[tuple.size()]));
        ++this.size;
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.files.isEmpty() && this.current.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doSpill() {
        if (!this.spillStrategy.doSpill(this, this.current.size())) {
            return false;
        }
        long start = System.currentTimeMillis();
        this.spillListener.notifyWriteSpillBegin(this, this.current.size(), this.spillStrategy.getSpillReason(this));
        File file = this.createTempFile();
        TupleOutputStream dataOutputStream = this.createTupleOutputStream(file);
        try {
            this.writeList(dataOutputStream, this.current);
        }
        finally {
            this.flushSilent(dataOutputStream);
            this.closeSilent(dataOutputStream);
        }
        this.spillListener.notifyWriteSpillEnd(this, System.currentTimeMillis() - start);
        if (this.files == Collections.EMPTY_LIST) {
            this.files = new LinkedList<File>();
        }
        this.files.add(file);
        this.current.clear();
        return true;
    }

    private void flushSilent(Flushable flushable) {
        try {
            flushable.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeSilent(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeList(TupleOutputStream dataOutputStream, List<Object[]> list) {
        try {
            dataOutputStream.writeLong(list.size());
            for (Object[] elements : list) {
                dataOutputStream.writeElementArray(elements);
            }
        }
        catch (IOException exception) {
            throw new TupleException("unable to write tuple collection to file output stream", exception);
        }
    }

    protected abstract TupleOutputStream createTupleOutputStream(File var1);

    private Iterator<Tuple> createIterator(final TupleInputStream tupleInputStream) {
        long size;
        try {
            size = tupleInputStream.readLong();
        }
        catch (IOException exception) {
            throw new TupleException("unable to read 'size' of collection from file input stream", exception);
        }
        return new CloseableIterator<Tuple>(){
            Tuple tuple = new Tuple();
            long count = 0L;

            @Override
            public boolean hasNext() {
                return this.count < size;
            }

            @Override
            public Tuple next() {
                try {
                    Tuple tuple = tupleInputStream.readTuple(this.tuple);
                    return tuple;
                }
                catch (IOException exception) {
                    throw new TupleException("unable to read next tuple from file input stream containing: " + size + " tuples, successfully read tuples: " + this.count, exception);
                }
                finally {
                    ++this.count;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported");
            }

            @Override
            public void close() throws IOException {
                tupleInputStream.close();
            }
        };
    }

    protected abstract TupleInputStream createTupleInputStream(File var1);

    private File createTempFile() {
        try {
            File file = File.createTempFile("cascading-spillover", null);
            file.deleteOnExit();
            return file;
        }
        catch (IOException exception) {
            throw new TupleException("unable to create temporary file", exception);
        }
    }

    @Override
    public void clear() {
        this.files.clear();
        this.current.clear();
        this.size = 0;
    }

    @Override
    public Iterator<Tuple> iterator() {
        if (this.files.isEmpty()) {
            return this.asTupleIterator();
        }
        return new SpilledListIterator();
    }

    private Iterator<Tuple> asTupleIterator() {
        final Tuple tuple = TupleViews.createObjectArray();
        final Iterator<Object[]> iterator = this.current.iterator();
        return new Iterator<Tuple>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Tuple next() {
                return TupleViews.reset(tuple, (Object[])iterator.next());
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public boolean contains(Object object) {
        return false;
    }

    @Override
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return null;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends Tuple> tuples) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        return false;
    }

    private class SpilledListIterator
    implements Iterator<Tuple> {
        int fileIndex = 0;
        private Iterator<Tuple> lastIterator;
        private Iterator<Tuple> iterator;

        private SpilledListIterator() {
            this.lastIterator = SpillableTupleList.this.asTupleIterator();
            this.getNextIterator();
        }

        private void getNextIterator() {
            if (this.iterator instanceof Closeable) {
                SpillableTupleList.this.closeSilent((Closeable)((Object)this.iterator));
            }
            this.iterator = this.fileIndex < SpillableTupleList.this.files.size() ? this.getIteratorFor((File)SpillableTupleList.this.files.get(this.fileIndex++)) : this.lastIterator;
        }

        private Iterator<Tuple> getIteratorFor(File file) {
            SpillableTupleList.this.spillListener.notifyReadSpillBegin(SpillableTupleList.this);
            return SpillableTupleList.this.createIterator(SpillableTupleList.this.createTupleInputStream(file));
        }

        @Override
        public boolean hasNext() {
            if (this.isLastCollection()) {
                return this.iterator.hasNext();
            }
            if (this.iterator.hasNext()) {
                return true;
            }
            this.getNextIterator();
            return this.hasNext();
        }

        @Override
        public Tuple next() {
            if (this.isLastCollection() || this.iterator.hasNext()) {
                return this.iterator.next();
            }
            this.getNextIterator();
            return this.next();
        }

        private boolean isLastCollection() {
            return this.iterator == this.lastIterator;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }
    }
}

