/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.coerce;

import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import cascading.tuple.type.CoercionFrom;
import cascading.tuple.type.ToCanonical;
import java.lang.reflect.Type;
import java.util.Map;

public abstract class NumberCoerce<Canonical>
extends Coercions.Coerce<Canonical> {
    public NumberCoerce(Map<Type, Coercions.Coerce> map) {
        super(map);
    }

    @Override
    public <T> ToCanonical<T, Canonical> from(Type from) {
        Class fromAsNonPrimitive = Coercions.asNonPrimitiveOrNull(from);
        if (fromAsNonPrimitive == Coercions.asNonPrimitive(this.getCanonicalType())) {
            return new ToCanonical<T, Canonical>(){

                @Override
                public Canonical canonical(T f) {
                    return f == null ? NumberCoerce.this.forNull() : f;
                }
            };
        }
        if (fromAsNonPrimitive != null && Number.class.isAssignableFrom(fromAsNonPrimitive)) {
            return new ToCanonical<T, Canonical>(){

                @Override
                public Canonical canonical(T f) {
                    return f == null ? NumberCoerce.this.forNull() : NumberCoerce.this.asType((Number)f);
                }
            };
        }
        if (fromAsNonPrimitive != null && Boolean.class.isAssignableFrom(fromAsNonPrimitive)) {
            return new ToCanonical<T, Canonical>(){

                @Override
                public Canonical canonical(T f) {
                    return f == null ? NumberCoerce.this.forNull() : NumberCoerce.this.forBoolean((Boolean)f);
                }
            };
        }
        if (from instanceof CoercibleType) {
            final CoercionFrom to = ((CoercibleType)from).to(this.getCanonicalType());
            return new ToCanonical<T, Canonical>(){

                @Override
                public Canonical canonical(T f) {
                    return to.coerce(f);
                }
            };
        }
        return new ToCanonical<T, Canonical>(){

            @Override
            public Canonical canonical(T f) {
                return f == null ? NumberCoerce.this.forNull() : NumberCoerce.this.parseType(f);
            }
        };
    }

    @Override
    public Canonical coerce(Object value) {
        if (value instanceof Number) {
            return this.asType((Number)value);
        }
        if (value == null || value.toString().isEmpty()) {
            return this.forNull();
        }
        if (value instanceof Boolean) {
            return this.forBoolean((Boolean)value);
        }
        return this.parseType(value);
    }

    protected abstract Canonical forNull();

    protected abstract <T> Canonical parseType(T var1);

    protected abstract <T> Canonical asType(Number var1);

    protected abstract Canonical forBoolean(Boolean var1);
}

