/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.coerce;

import cascading.tuple.coerce.Coercions;
import cascading.tuple.coerce.NumberCoerce;
import java.lang.reflect.Type;
import java.util.Map;

public class FloatObjectCoerce
extends NumberCoerce<Float> {
    protected FloatObjectCoerce(Map<Type, Coercions.Coerce> map) {
        super(map);
    }

    @Override
    public Class<Float> getCanonicalType() {
        return Float.class;
    }

    @Override
    protected Float forNull() {
        return null;
    }

    @Override
    protected Float forBoolean(Boolean f) {
        return Float.valueOf(f != false ? 1.0f : 0.0f);
    }

    @Override
    protected <T> Float parseType(T f) {
        return Float.valueOf(Float.parseFloat(f.toString()));
    }

    @Override
    protected Float asType(Number f) {
        return Float.valueOf(f.floatValue());
    }
}

