/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.coerce;

import cascading.cascade.CascadeException;
import cascading.tuple.Fields;
import cascading.tuple.coerce.BigDecimalCoerce;
import cascading.tuple.coerce.BooleanCoerce;
import cascading.tuple.coerce.BooleanObjectCoerce;
import cascading.tuple.coerce.CharacterCoerce;
import cascading.tuple.coerce.CharacterObjectCoerce;
import cascading.tuple.coerce.DoubleCoerce;
import cascading.tuple.coerce.DoubleObjectCoerce;
import cascading.tuple.coerce.FloatCoerce;
import cascading.tuple.coerce.FloatObjectCoerce;
import cascading.tuple.coerce.IntegerCoerce;
import cascading.tuple.coerce.IntegerObjectCoerce;
import cascading.tuple.coerce.LongCoerce;
import cascading.tuple.coerce.LongObjectCoerce;
import cascading.tuple.coerce.ObjectCoerce;
import cascading.tuple.coerce.ShortCoerce;
import cascading.tuple.coerce.ShortObjectCoerce;
import cascading.tuple.coerce.StringCoerce;
import cascading.tuple.type.CoercibleType;
import cascading.tuple.type.CoercionFrom;
import cascading.tuple.type.ToCanonical;
import cascading.util.Util;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public final class Coercions {
    private static final Map<Type, Coerce> coercionsPrivate = new IdentityHashMap<Type, Coerce>();
    public static final Map<Type, Coerce> coercions = Collections.unmodifiableMap(coercionsPrivate);
    private static final Map<String, Type> typesPrivate = new HashMap<String, Type>();
    public static final Map<String, Type> types = Collections.unmodifiableMap(typesPrivate);
    public static final Coerce<Object> OBJECT = new ObjectCoerce(coercionsPrivate);
    public static final Coerce<String> STRING = new StringCoerce(coercionsPrivate);
    public static final Coerce<Character> CHARACTER = new CharacterCoerce(coercionsPrivate);
    public static final Coerce<Character> CHARACTER_OBJECT = new CharacterObjectCoerce(coercionsPrivate);
    public static final Coerce<Short> SHORT = new ShortCoerce(coercionsPrivate);
    public static final Coerce<Short> SHORT_OBJECT = new ShortObjectCoerce(coercionsPrivate);
    public static final Coerce<Integer> INTEGER = new IntegerCoerce(coercionsPrivate);
    public static final Coerce<Integer> INTEGER_OBJECT = new IntegerObjectCoerce(coercionsPrivate);
    public static final Coerce<Double> DOUBLE = new DoubleCoerce(coercionsPrivate);
    public static final Coerce<Double> DOUBLE_OBJECT = new DoubleObjectCoerce(coercionsPrivate);
    public static final Coerce<Long> LONG = new LongCoerce(coercionsPrivate);
    public static final Coerce<Long> LONG_OBJECT = new LongObjectCoerce(coercionsPrivate);
    public static final Coerce<Float> FLOAT = new FloatCoerce(coercionsPrivate);
    public static final Coerce<Float> FLOAT_OBJECT = new FloatObjectCoerce(coercionsPrivate);
    public static final Coerce<Boolean> BOOLEAN = new BooleanCoerce(coercionsPrivate);
    public static final Coerce<Boolean> BOOLEAN_OBJECT = new BooleanObjectCoerce(coercionsPrivate);
    public static final Coerce<BigDecimal> BIG_DECIMAL = new BigDecimalCoerce(coercionsPrivate);
    private static final Map<Class, Class> primitivesPrivate;
    public static final Map<Class, Class> primitives;

    public static Class asNonPrimitiveOrNull(Type type) {
        if (type instanceof Class) {
            return Coercions.asNonPrimitive((Class)type);
        }
        return null;
    }

    public static Class asNonPrimitive(Class type) {
        if (type.isPrimitive()) {
            return primitives.get(type);
        }
        return type;
    }

    public static Class[] asNonPrimitive(Class[] types) {
        Class[] results = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            results[i] = Coercions.asNonPrimitive(types[i]);
        }
        return results;
    }

    public static CoercibleType coercibleTypeFor(Type type) {
        if (type == null) {
            return OBJECT;
        }
        if (CoercibleType.class.isInstance(type)) {
            return (CoercibleType)type;
        }
        Coerce coerce = coercionsPrivate.get(type);
        if (coerce == null) {
            return OBJECT;
        }
        return coerce;
    }

    public static final <T> T coerce(Object value, Type type) {
        Coerce coerce = coercionsPrivate.get(type);
        if (coerce == null) {
            if (type instanceof CoercibleType) {
                return (T)((CoercibleType)type).canonical(value);
            }
            return (T)OBJECT.coerce(value);
        }
        return (T)coerce.coerce(value);
    }

    public static final Object coerce(CoercibleType currentType, Object canonical, Type type) {
        if (currentType.equals(type)) {
            return canonical;
        }
        return currentType.coerce(canonical, type);
    }

    public static CoercibleType[] coercibleArray(Fields fields) {
        return Coercions.coercibleArray(fields.size(), fields.getTypes());
    }

    public static CoercibleType[] coercibleArray(int size, Type[] types) {
        Object[] coercions = new CoercibleType[size];
        if (types == null || types.length == 0) {
            Arrays.fill(coercions, OBJECT);
            return coercions;
        }
        for (int i = 0; i < types.length; ++i) {
            coercions[i] = Coercions.coercibleTypeFor(types[i]);
        }
        return coercions;
    }

    public static ToCanonical<?, ?>[] canonicalArray(Type from, int size, Type[] types) {
        Object[] canonicals = new ToCanonical[size];
        if (types == null || types.length == 0) {
            Arrays.fill(canonicals, OBJECT.from(from));
            return canonicals;
        }
        for (int i = 0; i < types.length; ++i) {
            canonicals[i] = Coercions.coercibleTypeFor(types[i]).from(from);
        }
        return canonicals;
    }

    public static CoercionFrom<?, ?>[] coercionsArray(Type to, Type[] types) {
        return Coercions.coercionsArray(to, types.length, types);
    }

    public static CoercionFrom<?, ?>[] coercionsArray(Type to, int size, Type[] types) {
        Object[] canonicals = new CoercionFrom[size];
        if (types == null || types.length == 0) {
            Arrays.fill(canonicals, OBJECT.to(to));
            return canonicals;
        }
        for (int i = 0; i < types.length; ++i) {
            canonicals[i] = Coercions.coercibleTypeFor(types[i]).to(to);
        }
        return canonicals;
    }

    public static Class asClass(Type type) {
        if (Class.class.isInstance(type)) {
            return (Class)type;
        }
        return Object.class;
    }

    public static Type asType(String typeName) {
        Type type = typesPrivate.get(typeName);
        if (type != null) {
            return type;
        }
        Class<CoercibleType> typeClass = Coercions.getType(typeName);
        if (CoercibleType.class.isAssignableFrom(typeClass)) {
            return Coercions.getInstance(typeClass);
        }
        return typeClass;
    }

    public static String[] getTypeNames(Type[] types) {
        String[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            names[i] = Class.class.isInstance(types[i]) ? ((Class)types[i]).getName() : types[i].getClass().getName();
        }
        return names;
    }

    public static Type[] getTypes(String[] names) {
        Type[] types = new Type[names.length];
        for (int i = 0; i < names.length; ++i) {
            types[i] = Coercions.asType(names[i]);
        }
        return types;
    }

    public static Class[] getCanonicalTypes(Type[] types) {
        Class[] canonicalTypes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            canonicalTypes[i] = CoercibleType.class.isInstance(types[i]) ? ((CoercibleType)types[i]).getCanonicalType() : (Class)types[i];
        }
        return canonicalTypes;
    }

    private static CoercibleType getInstance(Class<CoercibleType> typeClass) {
        try {
            return typeClass.newInstance();
        }
        catch (Exception exception) {
            throw new CascadeException("unable to instantiate class: " + Util.getTypeName(typeClass));
        }
    }

    private static Class<?> getType(String typeName) {
        try {
            return Coercions.class.getClassLoader().loadClass(typeName);
        }
        catch (ClassNotFoundException exception) {
            throw new CascadeException("unable to load class: " + typeName);
        }
    }

    static {
        for (Type type : coercionsPrivate.keySet()) {
            typesPrivate.put(Util.getTypeName(type), type);
        }
        primitivesPrivate = new IdentityHashMap<Class, Class>();
        primitives = Collections.unmodifiableMap(primitivesPrivate);
        primitivesPrivate.put(Boolean.TYPE, Boolean.class);
        primitivesPrivate.put(Byte.TYPE, Byte.class);
        primitivesPrivate.put(Short.TYPE, Short.class);
        primitivesPrivate.put(Integer.TYPE, Integer.class);
        primitivesPrivate.put(Long.TYPE, Long.class);
        primitivesPrivate.put(Float.TYPE, Float.class);
        primitivesPrivate.put(Double.TYPE, Double.class);
    }

    public static abstract class Coerce<Canonical>
    implements CoercibleType<Canonical> {
        protected Coerce(Map<Type, Coerce> map) {
            if (map.containsKey(this.getCanonicalType())) {
                throw new IllegalStateException("type already exists in map: " + this.getCanonicalType());
            }
            map.put(this.getCanonicalType(), this);
        }

        @Override
        public Canonical canonical(Object value) {
            return this.coerce(value);
        }

        @Override
        public <Coerce> Coerce coerce(Object value, Type to) {
            return (Coerce)Coercions.coerce(value, to);
        }

        public abstract Canonical coerce(Object var1);

        @Override
        public <T> CoercionFrom<Canonical, T> to(Type to) {
            if (to == this.getCanonicalType()) {
                return t -> t;
            }
            CoercibleType coercibleType = Coercions.coercibleTypeFor(to);
            if (coercibleType == null) {
                return t -> this.coerce(t, to);
            }
            ToCanonical from = coercibleType.from(this.getCanonicalType());
            return t -> from.canonical(t);
        }

        public int hashCode() {
            return this.getCanonicalType().hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CoercibleType)) {
                return false;
            }
            return this.getCanonicalType().equals(((CoercibleType)object).getCanonicalType());
        }
    }
}

