/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.coerce;

import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.ToCanonical;
import java.lang.reflect.Type;
import java.util.Map;

public class BooleanObjectCoerce
extends Coercions.Coerce<Boolean> {
    protected BooleanObjectCoerce(Map<Type, Coercions.Coerce> map) {
        super(map);
    }

    @Override
    public Class<Boolean> getCanonicalType() {
        return Boolean.class;
    }

    @Override
    public <T> ToCanonical<T, Boolean> from(Type from) {
        if (from == this.getCanonicalType()) {
            return f -> f == null ? null : (Boolean)f;
        }
        if (from instanceof Class && Number.class.isAssignableFrom((Class)from)) {
            return f -> f == null ? null : (Boolean)f;
        }
        return f -> f == null ? null : Boolean.valueOf(Boolean.parseBoolean(f.toString()));
    }

    @Override
    public Boolean coerce(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null || value.toString().isEmpty()) {
            return null;
        }
        return Boolean.parseBoolean(value.toString());
    }
}

