/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.coerce;

import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.ToCanonical;
import java.lang.reflect.Type;
import java.util.Map;

public class BooleanCoerce
extends Coercions.Coerce<Boolean> {
    protected BooleanCoerce(Map<Type, Coercions.Coerce> map) {
        super(map);
    }

    @Override
    public Class<Boolean> getCanonicalType() {
        return Boolean.TYPE;
    }

    @Override
    public <T> ToCanonical<T, Boolean> from(Type from) {
        if (from == this.getCanonicalType()) {
            return f -> f != null && (Boolean)f != false;
        }
        if (from instanceof Class && Boolean.class.isAssignableFrom((Class)from)) {
            return f -> f != null && (Boolean)f != false;
        }
        return f -> f != null && Boolean.parseBoolean(f.toString());
    }

    @Override
    public Boolean coerce(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null || value.toString().isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(value.toString());
    }
}

