/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.coerce;

import cascading.tuple.coerce.Coercions;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Map;

public class BigDecimalCoerce
extends Coercions.Coerce<BigDecimal> {
    protected BigDecimalCoerce(Map<Type, Coercions.Coerce> map) {
        super(map);
    }

    @Override
    public Class<BigDecimal> getCanonicalType() {
        return BigDecimal.class;
    }

    @Override
    public BigDecimal coerce(Object value) {
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value);
        }
        if (value instanceof Long) {
            return BigDecimal.valueOf((Long)value);
        }
        if (value == null || value.toString().isEmpty()) {
            return null;
        }
        return new BigDecimal(value.toString());
    }
}

