/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.operation.OperationException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleException;
import cascading.tuple.type.CoercibleType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Tuples {
    public static Tuple tuple(Object a) {
        return new Tuple(a);
    }

    public static Tuple tuple(Object a, Object b) {
        return new Tuple(a, b);
    }

    public static Tuple tuple(Object a, Object b, Object c) {
        return new Tuple(a, b, c);
    }

    public static Tuple tuple(Object a, Object b, Object c, Object d) {
        return new Tuple(a, b, c, d);
    }

    public static Tuple tuple(Object a, Object b, Object c, Object d, Object e) {
        return new Tuple(a, b, c, d, e);
    }

    public static Tuple tuple(Object a, Object b, Object c, Object d, Object e, Object f) {
        return new Tuple(a, b, c, d, e, f);
    }

    public static Tuple tuple(Object a, Object b, Object c, Object d, Object e, Object f, Object g) {
        return new Tuple(a, b, c, d, e, f, g);
    }

    public static Tuple tuple(Object a, Object b, Object c, Object d, Object e, Object f, Object g, Object h) {
        return new Tuple(a, b, c, d, e, f, g, h);
    }

    public static <T> T[] asArray(Tuple tuple, T[] destination) {
        if (tuple.size() != destination.length) {
            throw new OperationException("number of input tuple values: " + tuple.size() + ", does not match destination array size: " + destination.length);
        }
        return tuple.elements(destination);
    }

    public static Object[] asArray(Tuple tuple, CoercibleType[] coercions, Class[] types, Object[] destination) {
        if (tuple.size() != types.length) {
            throw new OperationException("number of input tuple values: " + tuple.size() + ", does not match number of coercion types: " + types.length);
        }
        for (int i = 0; i < types.length; ++i) {
            destination[i] = coercions[i].coerce(tuple.getObject(i), types[i]);
        }
        return destination;
    }

    public static Map<String, Object> asMap(Fields fields, TupleEntry arguments) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Comparable comparable : fields) {
            result.put(comparable.toString(), arguments.getObject(comparable));
        }
        return result;
    }

    public static Map<Comparable, Object> asComparableMap(Fields fields, TupleEntry arguments) {
        HashMap<Comparable, Object> result = new HashMap<Comparable, Object>();
        for (Comparable comparable : fields) {
            result.put(comparable, arguments.getObject(comparable));
        }
        return result;
    }

    public static Collection asCollection(Tuple tuple) {
        return Collections.unmodifiableCollection(tuple.elements);
    }

    public static int frequency(Tuple tuple, Object value) {
        return Collections.frequency(tuple.elements, value);
    }

    public static int frequency(TupleEntry tupleEntry, Object value) {
        return Collections.frequency(tupleEntry.getTuple().elements, value);
    }

    public static Tuple extractTuple(TupleEntry tupleEntry, Fields selector) {
        if (selector == null || selector.isAll()) {
            Tuple result = tupleEntry.tuple;
            tupleEntry.setTuple(Tuple.size(result.size()));
            return result;
        }
        try {
            return Tuples.extract(tupleEntry, selector);
        }
        catch (Exception exception) {
            throw new TupleException("unable to select from: " + tupleEntry.getFields().printVerbose() + ", using selector: " + selector.printVerbose(), exception);
        }
    }

    public static Tuple extract(TupleEntry tupleEntry, Fields selector) {
        return tupleEntry.tuple.extract(tupleEntry.getFields().getPos(selector, tupleEntry.getFields().size()));
    }

    public static Tuple nulledCopy(TupleEntry tupleEntry, Fields selector) {
        return tupleEntry.tuple.nulledCopy(tupleEntry.getFields().getPos(selector, tupleEntry.getFields().size()));
    }

    public static Tuple nulledCopy(Fields declarator, Tuple tuple, Fields selector) {
        return tuple.nulledCopy(declarator.getPos(selector, tuple.size()));
    }

    public static Tuple setOnEmpty(TupleEntry baseEntry, TupleEntry valuesEntry) {
        Tuple emptyTuple = Tuple.size(baseEntry.getFields().size());
        emptyTuple.set(baseEntry.getFields(), valuesEntry.getFields(), valuesEntry.getTuple());
        return emptyTuple;
    }

    public static <T extends Tuple> T asUnmodifiable(T tuple) {
        tuple.isUnmodifiable = true;
        return tuple;
    }

    public static <T extends Tuple> T asModifiable(T tuple) {
        tuple.isUnmodifiable = false;
        return tuple;
    }

    public static <T extends Tuple> T setUnmodifiable(T tuple, boolean isUnmodifiable) {
        tuple.isUnmodifiable = isUnmodifiable;
        return tuple;
    }

    public static Tuple create(List<Object> arrayList) {
        return new Tuple(arrayList);
    }
}

