/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.flow.FlowProcess;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntryCollector;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class TupleStream {
    public static Stream<Tuple> tupleStream(Tap tap, FlowProcess flowProcess) {
        Objects.requireNonNull(tap);
        return tap.tupleStream(flowProcess);
    }

    public static Stream<Tuple> tupleStreamCopy(Tap tap, FlowProcess flowProcess) {
        Objects.requireNonNull(tap);
        return tap.tupleStreamCopy(flowProcess);
    }

    public static Stream<Tuple> tupleStream(Tap tap, FlowProcess flowProcess, Fields selector) {
        Objects.requireNonNull(tap);
        Objects.requireNonNull(selector);
        return tap.tupleStream(flowProcess, selector);
    }

    public static Stream<Tuple> tupleStreamCopy(Tap tap, FlowProcess flowProcess, Fields selector) {
        Objects.requireNonNull(tap);
        Objects.requireNonNull(selector);
        return tap.tupleStreamCopy(flowProcess, selector);
    }

    public static <R> Function<Tuple, ? extends R> posToObject(int pos) {
        return value -> value.getObject(pos);
    }

    public static ToIntFunction<Tuple> posToInt(int pos) {
        return value -> value.getInteger(pos);
    }

    public static ToLongFunction<Tuple> posToLong(int pos) {
        return value -> value.getLong(pos);
    }

    public static ToDoubleFunction<Tuple> posToDouble(int pos) {
        return value -> value.getDouble(pos);
    }

    public static Tap writeTuple(Stream<Tuple> stream, Supplier<Tap> into, FlowProcess flowProcess) {
        return TupleStream.writeTuple(stream, into.get(), flowProcess);
    }

    public static Tap writeTuple(Stream<Tuple> stream, Tap into, FlowProcess flowProcess) {
        Objects.requireNonNull(into);
        Objects.requireNonNull(stream);
        try {
            TupleEntryCollector collector = into.openForWrite(flowProcess);
            stream.forEach(collector::add);
            collector.close();
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
        return into;
    }

    public static Tap writeInt(IntStream stream, Supplier<Tap> into, FlowProcess flowProcess) {
        return TupleStream.writeInt(stream, into.get(), flowProcess);
    }

    public static Tap writeInt(IntStream stream, Tap into, FlowProcess flowProcess) {
        Objects.requireNonNull(into);
        Objects.requireNonNull(stream);
        Tuple tuple = Tuple.size(1);
        try {
            TupleEntryCollector collector = into.openForWrite(flowProcess);
            stream.forEach(i -> collector.add(TupleStream.reset(tuple, i)));
            collector.close();
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
        return into;
    }

    public static Tap writeLong(LongStream stream, Supplier<Tap> into, FlowProcess flowProcess) {
        return TupleStream.writeLong(stream, into.get(), flowProcess);
    }

    public static Tap writeLong(LongStream stream, Tap into, FlowProcess flowProcess) {
        Objects.requireNonNull(into);
        Objects.requireNonNull(stream);
        Tuple tuple = Tuple.size(1);
        try {
            TupleEntryCollector collector = into.openForWrite(flowProcess);
            stream.forEach(i -> collector.add(TupleStream.reset(tuple, i)));
            collector.close();
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
        return into;
    }

    public static Tap writeDouble(DoubleStream stream, Supplier<Tap> into, FlowProcess flowProcess) {
        return TupleStream.writeDouble(stream, into.get(), flowProcess);
    }

    public static Tap writeDouble(DoubleStream stream, Tap into, FlowProcess flowProcess) {
        Objects.requireNonNull(into);
        Objects.requireNonNull(stream);
        Tuple tuple = Tuple.size(1);
        try {
            TupleEntryCollector collector = into.openForWrite(flowProcess);
            stream.forEach(i -> collector.add(TupleStream.reset(tuple, i)));
            collector.close();
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
        return into;
    }

    private static Tuple reset(Tuple tuple, Object value) {
        tuple.set(0, value);
        return tuple;
    }
}

