/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.flow.FlowProcess;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.type.CoercibleType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;

public class TupleEntryStream {
    public static Stream<TupleEntry> entryStream(Tap tap, FlowProcess flowProcess) {
        Objects.requireNonNull(tap);
        return tap.entryStream(flowProcess);
    }

    public static Stream<TupleEntry> entryStreamCopy(Tap tap, FlowProcess flowProcess) {
        Objects.requireNonNull(tap);
        return tap.entryStreamCopy(flowProcess);
    }

    public static Stream<TupleEntry> entryStream(Tap tap, FlowProcess flowProcess, Fields selector) {
        Objects.requireNonNull(tap);
        Objects.requireNonNull(selector);
        return tap.entryStream(flowProcess, selector);
    }

    public static Stream<TupleEntry> entryStreamCopy(Tap tap, FlowProcess flowProcess, Fields selector) {
        Objects.requireNonNull(tap);
        Objects.requireNonNull(selector);
        return tap.entryStreamCopy(flowProcess, selector);
    }

    public static <R> Function<TupleEntry, ? extends R> fieldToObject(Fields fields) {
        Objects.requireNonNull(fields);
        return value -> value.getObject(fields);
    }

    public static <R> Function<TupleEntry, R> fieldToObject(Fields fields, CoercibleType<R> type) {
        Objects.requireNonNull(fields);
        Objects.requireNonNull(type);
        return value -> value.getObject(fields, (Type)type);
    }

    public static <R> Function<TupleEntry, R> fieldToObject(Fields fields, Class<R> type) {
        Objects.requireNonNull(fields);
        Objects.requireNonNull(type);
        return value -> value.getObject(fields, (Type)type);
    }

    public static ToIntFunction<TupleEntry> fieldToInt(Fields fields) {
        Objects.requireNonNull(fields);
        return value -> value.getInteger(fields);
    }

    public static ToIntFunction<TupleEntry> fieldToInt(Comparable name) {
        Objects.requireNonNull(name);
        return value -> value.getInteger(name);
    }

    public static ToLongFunction<TupleEntry> fieldToLong(Fields fields) {
        Objects.requireNonNull(fields);
        return value -> value.getLong(fields);
    }

    public static ToLongFunction<TupleEntry> fieldToLong(Comparable name) {
        Objects.requireNonNull(name);
        return value -> value.getLong(name);
    }

    public static ToDoubleFunction<TupleEntry> fieldToDouble(Fields fields) {
        Objects.requireNonNull(fields);
        return value -> value.getDouble(fields);
    }

    public static ToDoubleFunction<TupleEntry> fieldToDouble(Comparable name) {
        Objects.requireNonNull(name);
        return value -> value.getDouble(name);
    }

    public static Tap writeEntry(Stream<TupleEntry> stream, Supplier<Tap> into, FlowProcess flowProcess) {
        return TupleEntryStream.writeEntry(stream, into.get(), flowProcess);
    }

    public static Tap writeEntry(Stream<TupleEntry> stream, Tap into, FlowProcess flowProcess) {
        Objects.requireNonNull(into);
        Objects.requireNonNull(stream);
        try {
            TupleEntryCollector collector = into.openForWrite(flowProcess);
            stream.forEach(collector::add);
            collector.close();
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
        return into;
    }

    public static Tap writeEntry(Iterable<TupleEntry> iterable, Supplier<Tap> into, FlowProcess flowProcess) {
        return TupleEntryStream.writeEntry(iterable, into.get(), flowProcess);
    }

    public static Tap writeEntry(Iterable<TupleEntry> iterable, Tap into, FlowProcess flowProcess) {
        Objects.requireNonNull(into);
        Objects.requireNonNull(iterable);
        try {
            TupleEntryCollector collector = into.openForWrite(flowProcess);
            iterable.forEach(collector::add);
            collector.close();
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
        return into;
    }
}

