/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.flow.FlowProcess;
import cascading.scheme.ConcreteCall;
import cascading.scheme.Scheme;
import cascading.tap.Tap;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleException;
import cascading.tuple.Tuples;
import cascading.util.CloseableIterator;
import cascading.util.SingleCloseableInputIterator;
import cascading.util.Util;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleEntrySchemeIterator<Config, Input>
extends TupleEntryIterator {
    private static final Logger LOG = LoggerFactory.getLogger(TupleEntrySchemeIterator.class);
    private final FlowProcess<? extends Config> flowProcess;
    private final Scheme<Config, Input, ?, Object, ?> scheme;
    private final CloseableIterator<Input> inputIterator;
    private final Set<Class<? extends Exception>> permittedExceptions;
    private ConcreteCall sourceCall;
    private Supplier<String> loggableIdentifier = () -> "'unknown'";
    private boolean isComplete = false;
    private boolean hasWaiting = false;
    private TupleException currentException;

    @Deprecated
    public TupleEntrySchemeIterator(FlowProcess<? extends Config> flowProcess, Scheme scheme, Input input) {
        this(flowProcess, scheme, input, null);
    }

    @Deprecated
    public TupleEntrySchemeIterator(FlowProcess<? extends Config> flowProcess, Scheme scheme, Input input, String loggableIdentifier) {
        this(flowProcess, scheme, new SingleCloseableInputIterator((Closeable)input), loggableIdentifier);
    }

    @Deprecated
    public TupleEntrySchemeIterator(FlowProcess<? extends Config> flowProcess, Scheme scheme, CloseableIterator<Input> inputIterator) {
        this(flowProcess, scheme, inputIterator, (String)null);
    }

    @Deprecated
    public TupleEntrySchemeIterator(FlowProcess<? extends Config> flowProcess, Scheme scheme, CloseableIterator<Input> inputIterator, String loggableIdentifier) {
        this(flowProcess, (Tap)null, scheme, inputIterator, loggableIdentifier);
    }

    public TupleEntrySchemeIterator(FlowProcess<? extends Config> flowProcess, Tap tap, Scheme scheme, Input input) {
        this(flowProcess, tap, scheme, input, (Supplier<String>)null);
    }

    public TupleEntrySchemeIterator(FlowProcess<? extends Config> flowProcess, Tap tap, Scheme scheme, Input input, String loggableIdentifier) {
        this(flowProcess, tap, scheme, new SingleCloseableInputIterator((Closeable)input), loggableIdentifier);
    }

    public TupleEntrySchemeIterator(FlowProcess<? extends Config> flowProcess, Tap tap, Scheme scheme, Input input, Supplier<String> loggableIdentifier) {
        this(flowProcess, tap, scheme, new SingleCloseableInputIterator((Closeable)input), loggableIdentifier);
    }

    public TupleEntrySchemeIterator(FlowProcess<? extends Config> flowProcess, Tap tap, Scheme scheme, CloseableIterator<Input> inputIterator) {
        this(flowProcess, tap, scheme, inputIterator, (Supplier<String>)null);
    }

    public TupleEntrySchemeIterator(FlowProcess<? extends Config> flowProcess, Tap tap, Scheme scheme, CloseableIterator<Input> inputIterator, String loggableIdentifier) {
        this(flowProcess, tap, scheme, inputIterator, loggableIdentifier == null ? null : () -> loggableIdentifier);
    }

    public TupleEntrySchemeIterator(FlowProcess<? extends Config> flowProcess, Tap tap, Scheme scheme, CloseableIterator<Input> inputIterator, Supplier<String> loggableIdentifier) {
        super(scheme.getSourceFields());
        this.flowProcess = flowProcess;
        this.scheme = scheme;
        this.inputIterator = inputIterator;
        Object permittedExceptions = flowProcess.getProperty("cascading.tuple.tupleentryiterator.exceptions.permit");
        this.permittedExceptions = permittedExceptions != null ? Util.asClasses(permittedExceptions.toString(), "unable to load permitted exception class") : Collections.emptySet();
        if (tap != null && loggableIdentifier == null) {
            this.loggableIdentifier = tap::getIdentifier;
        } else if (loggableIdentifier != null) {
            this.loggableIdentifier = loggableIdentifier;
        }
        if (!inputIterator.hasNext()) {
            this.isComplete = true;
            return;
        }
        this.sourceCall = this.createSourceCall();
        this.sourceCall.setTap(tap);
        this.sourceCall.setIncomingEntry(this.getTupleEntry());
        this.sourceCall.setInput(this.wrapInput(inputIterator.next()));
        try {
            this.scheme.sourcePrepare(flowProcess, this.sourceCall);
        }
        catch (IOException exception) {
            throw new TupleException("unable to prepare source for input identifier: " + this.loggableIdentifier.get(), exception);
        }
    }

    protected <Context, IO> ConcreteCall<Context, IO> createSourceCall() {
        return new ConcreteCall();
    }

    protected FlowProcess<? extends Config> getFlowProcess() {
        return this.flowProcess;
    }

    protected Input wrapInput(Input input) {
        try {
            return this.scheme.sourceWrap(this.flowProcess, input);
        }
        catch (IOException exception) {
            throw new TupleException("unable to wrap source for input identifier: " + this.loggableIdentifier.get(), exception);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentException != null) {
            return true;
        }
        if (this.isComplete) {
            return false;
        }
        if (this.hasWaiting) {
            return true;
        }
        try {
            this.getNext();
        }
        catch (Exception exception) {
            if (this.permittedExceptions.contains(exception.getClass())) {
                LOG.warn("Caught permitted exception while reading {}", (Object)this.loggableIdentifier.get(), (Object)exception);
                return false;
            }
            this.currentException = new TupleException("unable to read from input identifier: " + this.loggableIdentifier.get(), exception);
            return true;
        }
        if (!this.hasWaiting) {
            this.isComplete = true;
        }
        return !this.isComplete;
    }

    private TupleEntry getNext() throws IOException {
        Tuples.asModifiable(this.sourceCall.getIncomingEntry().getTuple());
        this.hasWaiting = this.scheme.source(this.flowProcess, this.sourceCall);
        while (!this.hasWaiting && this.inputIterator.hasNext()) {
            this.sourceCall.setInput(this.wrapInput(this.inputIterator.next()));
            try {
                this.scheme.sourceRePrepare(this.flowProcess, this.sourceCall);
            }
            catch (IOException exception) {
                throw new TupleException("unable to prepare source for input identifier: " + this.loggableIdentifier.get(), exception);
            }
            Tuples.asModifiable(this.sourceCall.getIncomingEntry().getTuple());
            this.hasWaiting = this.scheme.source(this.flowProcess, this.sourceCall);
        }
        return this.getTupleEntry();
    }

    @Override
    public TupleEntry next() {
        try {
            if (this.currentException != null) {
                throw this.currentException;
            }
        }
        finally {
            this.currentException = null;
        }
        if (this.isComplete) {
            throw new IllegalStateException("no next element");
        }
        try {
            if (this.hasWaiting) {
                TupleEntry tupleEntry = this.getTupleEntry();
                return tupleEntry;
            }
            TupleEntry tupleEntry = this.getNext();
            return tupleEntry;
        }
        catch (Exception exception) {
            throw new TupleException("unable to source from input identifier: " + this.loggableIdentifier.get(), exception);
        }
        finally {
            this.hasWaiting = false;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("may not remove elements from this iterator");
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.sourceCall != null) {
                this.scheme.sourceCleanup(this.flowProcess, this.sourceCall);
            }
        }
        finally {
            this.inputIterator.close();
        }
    }
}

