/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.flow.FlowProcess;
import cascading.scheme.ConcreteCall;
import cascading.scheme.Scheme;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleException;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.function.Supplier;

public class TupleEntrySchemeCollector<Config, Output>
extends TupleEntryCollector {
    private final FlowProcess<? extends Config> flowProcess;
    private final Scheme<Config, ?, Output, ?, Object> scheme;
    protected final ConcreteCall<Object, Output> sinkCall;
    private Supplier<String> loggableIdentifier = () -> "'unknown'";
    private boolean prepared = false;

    @Deprecated
    public TupleEntrySchemeCollector(FlowProcess<? extends Config> flowProcess, Scheme scheme) {
        this(flowProcess, scheme, null, null);
    }

    @Deprecated
    public TupleEntrySchemeCollector(FlowProcess<? extends Config> flowProcess, Scheme scheme, String loggableIdentifier) {
        this(flowProcess, scheme, null, loggableIdentifier);
    }

    @Deprecated
    public TupleEntrySchemeCollector(FlowProcess<? extends Config> flowProcess, Scheme scheme, Output output) {
        this(flowProcess, scheme, output, null);
    }

    public TupleEntrySchemeCollector(FlowProcess<? extends Config> flowProcess, Tap tap, Output output) {
        this(flowProcess, tap, tap.getScheme(), output, tap.getIdentifier());
    }

    @Deprecated
    public TupleEntrySchemeCollector(FlowProcess<? extends Config> flowProcess, Scheme scheme, Output output, String loggableIdentifier) {
        this(flowProcess, null, scheme, output, loggableIdentifier);
    }

    public TupleEntrySchemeCollector(FlowProcess<? extends Config> flowProcess, Tap tap, Scheme scheme) {
        this(flowProcess, tap, scheme, null, (Supplier<String>)null);
    }

    public TupleEntrySchemeCollector(FlowProcess<? extends Config> flowProcess, Tap tap, Scheme scheme, String loggableIdentifier) {
        this(flowProcess, tap, scheme, null, loggableIdentifier);
    }

    public TupleEntrySchemeCollector(FlowProcess<? extends Config> flowProcess, Tap tap, Scheme scheme, Output output) {
        this(flowProcess, tap, scheme, output, (Supplier<String>)null);
    }

    public TupleEntrySchemeCollector(FlowProcess<? extends Config> flowProcess, Tap tap, Scheme scheme, Output output, String loggableIdentifier) {
        this(flowProcess, tap, scheme, output, loggableIdentifier == null ? null : () -> loggableIdentifier);
    }

    public TupleEntrySchemeCollector(FlowProcess<? extends Config> flowProcess, Tap tap, Scheme scheme, Output output, Supplier<String> loggableIdentifier) {
        super(Fields.asDeclaration(scheme.getSinkFields()));
        this.flowProcess = flowProcess;
        this.scheme = scheme;
        if (loggableIdentifier != null) {
            this.loggableIdentifier = loggableIdentifier;
        }
        this.sinkCall = this.createSinkCall();
        this.sinkCall.setTap(tap);
        this.sinkCall.setOutgoingEntry(this.tupleEntry);
        if (output != null) {
            this.setOutput(output);
        }
    }

    protected <Context, IO> ConcreteCall<Context, IO> createSinkCall() {
        return new ConcreteCall();
    }

    protected FlowProcess<? extends Config> getFlowProcess() {
        return this.flowProcess;
    }

    @Override
    public void setFields(Fields declared) {
        super.setFields(declared);
        if (this.sinkCall != null) {
            this.sinkCall.setOutgoingEntry(this.tupleEntry);
        }
    }

    protected Output getOutput() {
        return this.sinkCall.getOutput();
    }

    protected void setOutput(Output output) {
        this.sinkCall.setOutput(this.wrapOutput(output));
    }

    protected Output wrapOutput(Output output) {
        try {
            return this.scheme.sinkWrap(this.flowProcess, output);
        }
        catch (IOException exception) {
            throw new TapException("could not wrap scheme", exception);
        }
    }

    protected void prepare() {
        try {
            this.scheme.sinkPrepare(this.flowProcess, this.sinkCall);
        }
        catch (IOException exception) {
            throw new TapException("could not prepare scheme", exception);
        }
        this.prepared = true;
    }

    @Override
    public void add(TupleEntry tupleEntry) {
        if (!this.prepared) {
            this.prepare();
        }
        super.add(tupleEntry);
    }

    @Override
    public void add(Tuple tuple) {
        if (!this.prepared) {
            this.prepare();
        }
        super.add(tuple);
    }

    @Override
    protected void collect(TupleEntry tupleEntry) throws IOException {
        this.sinkCall.setOutgoingEntry(tupleEntry);
        try {
            this.scheme.sink(this.flowProcess, this.sinkCall);
        }
        catch (Exception exception) {
            throw new TupleException("unable to sink into output identifier: " + this.loggableIdentifier.get(), exception);
        }
    }

    @Override
    public void close() {
        try {
            if (this.sinkCall == null) {
                return;
            }
            try {
                if (this.prepared) {
                    this.scheme.sinkCleanup(this.flowProcess, this.sinkCall);
                }
            }
            catch (IOException exception) {
                throw new TupleException("unable to cleanup sink for output identifier: " + this.loggableIdentifier.get(), exception);
            }
        }
        finally {
            try {
                if (this.getOutput() instanceof Flushable) {
                    ((Flushable)this.getOutput()).flush();
                }
            }
            catch (IOException iOException) {}
            try {
                if (this.getOutput() instanceof Closeable) {
                    ((Closeable)this.getOutput()).close();
                }
            }
            catch (IOException iOException) {}
            super.close();
        }
    }
}

