/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;

public class TupleEntryIterableChainIterator
extends TupleEntryIterator {
    Iterator<Iterator<Tuple>> iterators;
    Iterator<Tuple> currentIterator = null;

    public TupleEntryIterableChainIterator(Fields fields) {
        super(fields);
    }

    public TupleEntryIterableChainIterator(Fields fields, Iterable<Iterator<Tuple>> iterable) {
        super(fields);
        this.iterators = iterable.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == null && !this.iterators.hasNext()) {
            return false;
        }
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            return true;
        }
        this.closeCurrent();
        this.currentIterator = null;
        if (this.iterators.hasNext()) {
            this.currentIterator = this.iterators.next();
        }
        return this.hasNext();
    }

    public void reset(Iterable<Iterator<Tuple>> iterable) {
        this.currentIterator = null;
        this.iterators = iterable.iterator();
    }

    @Override
    public TupleEntry next() {
        this.hasNext();
        this.entry.setTuple(this.currentIterator.next());
        return this.entry;
    }

    @Override
    public void remove() {
        this.currentIterator.remove();
    }

    @Override
    public void close() {
        if (this.currentIterator != null) {
            this.closeCurrent();
        }
    }

    protected void closeCurrent() {
        this.close(this.currentIterator);
    }

    private void close(Iterator iterator) {
        if (iterator instanceof Closeable) {
            try {
                ((Closeable)((Object)iterator)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

