/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleException;
import cascading.tuple.Tuples;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import cascading.tuple.type.CoercionFrom;
import cascading.util.ForeverValueIterator;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public class TupleEntry {
    private static final CoercibleType[] EMPTY_COERCIONS = new CoercibleType[0];
    public static final TupleEntry NULL = new TupleEntry(Fields.NONE, Tuple.NULL);
    private Fields fields;
    private Map<Class, CoercionFrom[]> iterableCache;
    private CoercibleType[] coercions = EMPTY_COERCIONS;
    private boolean isUnmodifiable = false;
    Tuple tuple;

    public static Tuple select(Fields selector, TupleEntry ... entries) {
        Tuple result = null;
        if (selector.isAll()) {
            for (TupleEntry entry : entries) {
                result = result == null ? entry.getTuple() : result.append(entry.getTuple());
            }
            return result;
        }
        int size = 0;
        for (TupleEntry entry : entries) {
            size += entry.size();
        }
        result = Tuple.size(selector.size());
        int offset = 0;
        for (TupleEntry entry : entries) {
            for (int i = 0; i < selector.size(); ++i) {
                int pos;
                Comparable field = selector.get(i);
                if (field instanceof String ? (pos = entry.fields.indexOfSafe(field)) == -1 : (pos = entry.fields.translatePos((Integer)field, size) - offset) >= entry.size() || pos < 0) continue;
                result.set(i, entry.getObject(pos));
            }
            offset += entry.size();
        }
        return result;
    }

    public TupleEntry() {
        this.fields = Fields.NONE;
        this.setCoercions();
    }

    @ConstructorProperties(value={"isUnmodifiable"})
    public TupleEntry(boolean isUnmodifiable) {
        this.fields = Fields.NONE;
        this.isUnmodifiable = isUnmodifiable;
        this.setCoercions();
    }

    @ConstructorProperties(value={"fields"})
    public TupleEntry(Fields fields) {
        if (fields == null) {
            throw new IllegalArgumentException("fields may not be null");
        }
        this.fields = fields;
        this.setCoercions();
    }

    @ConstructorProperties(value={"fields", "isUnmodifiable"})
    public TupleEntry(Fields fields, boolean isUnmodifiable) {
        if (fields == null) {
            throw new IllegalArgumentException("fields may not be null");
        }
        this.fields = fields;
        this.isUnmodifiable = isUnmodifiable;
        this.setCoercions();
    }

    @ConstructorProperties(value={"fields", "tuple", "isUnmodifiable"})
    public TupleEntry(Fields fields, Tuple tuple, boolean isUnmodifiable) {
        if (fields == null) {
            throw new IllegalArgumentException("fields may not be null");
        }
        this.fields = fields;
        this.isUnmodifiable = isUnmodifiable;
        this.setTuple(tuple);
        this.setCoercions();
    }

    @ConstructorProperties(value={"fields", "tuple"})
    public TupleEntry(Fields fields, Tuple tuple) {
        if (fields == null) {
            throw new IllegalArgumentException("fields may not be null");
        }
        this.fields = fields;
        this.tuple = tuple;
        this.setCoercions();
    }

    @ConstructorProperties(value={"tupleEntry"})
    public TupleEntry(TupleEntry tupleEntry) {
        if (tupleEntry == null) {
            throw new IllegalArgumentException("tupleEntry may not be null");
        }
        this.fields = tupleEntry.getFields();
        this.tuple = tupleEntry.getTupleCopy();
        this.setCoercions();
    }

    @ConstructorProperties(value={"tuple"})
    public TupleEntry(Tuple tuple) {
        if (tuple == null) {
            throw new IllegalArgumentException("tuple may not be null");
        }
        this.fields = Fields.size(tuple.size());
        this.tuple = tuple;
        this.setCoercions();
    }

    private void setCoercions() {
        if (this.coercions != EMPTY_COERCIONS) {
            return;
        }
        this.coercions = TupleEntry.getCoercions(this.getFields(), this.tuple);
    }

    static CoercibleType[] getCoercions(Fields fields, Tuple tuple) {
        Type[] types = fields.types;
        int size = fields.size();
        int n = size = size == 0 && tuple != null ? tuple.size() : size;
        if (size == 0) {
            return EMPTY_COERCIONS;
        }
        return Coercions.coercibleArray(size, types);
    }

    public boolean isUnmodifiable() {
        return this.isUnmodifiable;
    }

    public Fields getFields() {
        return this.fields;
    }

    public boolean hasTypes() {
        return this.fields.hasTypes();
    }

    public Tuple getTuple() {
        return this.tuple;
    }

    public Tuple getTupleCopy() {
        return new Tuple(this.tuple);
    }

    public Tuple getCoercedTuple(Type[] types) {
        return this.getCoercedTuple(types, Tuple.size(types.length));
    }

    public Tuple getCoercedTuple(Type[] types, Tuple into) {
        if (into == null) {
            throw new IllegalArgumentException("into argument Tuple may not be null");
        }
        if (this.coercions.length != types.length || types.length != into.size()) {
            throw new IllegalArgumentException("current entry and given tuple and types must be same length");
        }
        for (int i = 0; i < this.coercions.length; ++i) {
            Object element = this.tuple.getObject(i);
            into.set(i, Coercions.coerce(this.coercions[i], element, types[i]));
        }
        return into;
    }

    public void setTuple(Tuple tuple) {
        if (!this.isUnmodifiable && tuple != null && tuple.isUnmodifiable()) {
            throw new IllegalArgumentException("current entry is modifiable but given tuple is not modifiable, make copy of given Tuple first");
        }
        this.tuple = tuple != null && this.isUnmodifiable ? Tuples.asUnmodifiable(tuple) : tuple;
        this.setCoercions();
    }

    public void setCanonicalTuple(Tuple tuple) {
        if (tuple == null) {
            this.tuple = null;
            return;
        }
        if (this.isUnmodifiable) {
            tuple = Tuples.asUnmodifiable(tuple);
        }
        if (this.fields.size() != tuple.size()) {
            throw new IllegalArgumentException("current entry and given tuple must be same length");
        }
        for (int i = 0; i < this.coercions.length; ++i) {
            Object element = tuple.getObject(i);
            this.tuple.set(i, this.coercions[i].canonical(element));
        }
    }

    public void setCanonicalValues(Object[] values) {
        this.setCanonicalValues(values, 0, values.length);
    }

    public void setCanonicalValues(Object[] values, int offset, int length) {
        if (this.fields.size() != length) {
            throw new IllegalArgumentException("current entry and given array must be same length");
        }
        for (int i = offset; i < this.coercions.length; ++i) {
            Object element = values[i];
            this.tuple.set(i, this.coercions[i].canonical(element));
        }
    }

    public int size() {
        return this.tuple.size();
    }

    public Object getObject(int pos) {
        return this.tuple.getObject(pos);
    }

    public Object getObject(int pos, Type type) {
        if (pos > this.coercions.length - 1) {
            throw new TupleException("position value is too large: " + pos + ", positions in field: " + this.tuple.size());
        }
        return Coercions.coerce(this.coercions[pos], this.tuple.getObject(pos), type);
    }

    public Object getObject(Comparable fieldName) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        return this.tuple.getObject(pos);
    }

    public Object getObject(Comparable fieldName, Type type) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        if (pos > this.coercions.length - 1) {
            throw new TupleException("position value is too large: " + pos + ", positions in field: " + this.tuple.size());
        }
        return Coercions.coerce(this.coercions[pos], this.tuple.getObject(pos), type);
    }

    public void setRaw(int pos, Object value) {
        this.tuple.set(pos, value);
    }

    public void setRaw(Comparable fieldName, Object value) {
        this.tuple.set(this.fields.getPos(this.asFieldName(fieldName)), value);
    }

    public void setObject(Comparable fieldName, Object value) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        if (pos > this.coercions.length - 1) {
            throw new TupleException("position value is too large: " + pos + ", positions in field: " + this.tuple.size());
        }
        this.tuple.set(pos, this.coercions[pos].canonical(value));
    }

    public void setBoolean(Comparable fieldName, boolean value) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        if (pos > this.coercions.length - 1) {
            throw new TupleException("position value is too large: " + pos + ", positions in field: " + this.tuple.size());
        }
        this.tuple.set(pos, this.coercions[pos].canonical(value));
    }

    public void setShort(Comparable fieldName, short value) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        if (pos > this.coercions.length - 1) {
            throw new TupleException("position value is too large: " + pos + ", positions in field: " + this.tuple.size());
        }
        this.tuple.set(pos, this.coercions[pos].canonical(value));
    }

    public void setInteger(Comparable fieldName, int value) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        if (pos > this.coercions.length - 1) {
            throw new TupleException("position value is too large: " + pos + ", positions in field: " + this.tuple.size());
        }
        this.tuple.set(pos, this.coercions[pos].canonical(value));
    }

    public void setLong(Comparable fieldName, long value) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        if (pos > this.coercions.length - 1) {
            throw new TupleException("position value is too large: " + pos + ", positions in field: " + this.tuple.size());
        }
        this.tuple.set(pos, this.coercions[pos].canonical(value));
    }

    public void setFloat(Comparable fieldName, float value) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        if (pos > this.coercions.length - 1) {
            throw new TupleException("position value is too large: " + pos + ", positions in field: " + this.tuple.size());
        }
        this.tuple.set(pos, this.coercions[pos].canonical(Float.valueOf(value)));
    }

    public void setDouble(Comparable fieldName, double value) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        if (pos > this.coercions.length - 1) {
            throw new TupleException("position value is too large: " + pos + ", positions in field: " + this.tuple.size());
        }
        this.tuple.set(pos, this.coercions[pos].canonical(value));
    }

    public void setString(Comparable fieldName, String value) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        if (pos > this.coercions.length - 1) {
            throw new TupleException("position value is too large: " + pos + ", positions in field: " + this.tuple.size());
        }
        this.tuple.set(pos, this.coercions[pos].canonical(value));
    }

    public String getString(Comparable fieldName) {
        return (String)this.getObject(fieldName, (Type)((Object)String.class));
    }

    public float getFloat(Comparable fieldName) {
        return ((Float)this.getObject(fieldName, Float.TYPE)).floatValue();
    }

    public double getDouble(Comparable fieldName) {
        return (Double)this.getObject(fieldName, Double.TYPE);
    }

    public int getInteger(Comparable fieldName) {
        return (Integer)this.getObject(fieldName, Integer.TYPE);
    }

    public long getLong(Comparable fieldName) {
        return (Long)this.getObject(fieldName, Long.TYPE);
    }

    public short getShort(Comparable fieldName) {
        return (Short)this.getObject(fieldName, Short.TYPE);
    }

    public boolean getBoolean(Comparable fieldName) {
        return (Boolean)this.getObject(fieldName, Boolean.TYPE);
    }

    private Comparable asFieldName(Comparable fieldName) {
        return Fields.asFieldName(fieldName);
    }

    public TupleEntry selectEntry(Fields selector) {
        if (selector == null || selector.isAll() || this.fields == selector) {
            return this;
        }
        if (selector.isNone()) {
            return this.isUnmodifiable ? NULL : new TupleEntry();
        }
        return new TupleEntry(Fields.asDeclaration(selector), this.tuple.get(this.fields, selector), this.isUnmodifiable);
    }

    public TupleEntry selectEntryCopy(Fields selector) {
        if (selector == null || selector.isAll() || this.fields == selector) {
            return new TupleEntry(this);
        }
        if (selector.isNone()) {
            return new TupleEntry();
        }
        return new TupleEntry(Fields.asDeclaration(selector), this.tuple.get(this.fields, selector));
    }

    public Tuple selectTuple(Fields selector) {
        if (selector == null || selector.isAll() || this.fields == selector) {
            return this.tuple;
        }
        if (selector.isNone()) {
            return this.isUnmodifiable ? Tuple.NULL : new Tuple();
        }
        Tuple result = this.tuple.get(this.fields, selector);
        if (this.isUnmodifiable) {
            Tuples.asUnmodifiable(result);
        }
        return result;
    }

    public Tuple selectTupleCopy(Fields selector) {
        if (selector == null || selector.isAll() || this.fields == selector) {
            return new Tuple(this.tuple);
        }
        if (selector.isNone()) {
            return new Tuple();
        }
        return this.tuple.get(this.fields, selector);
    }

    public Tuple selectInto(Fields selector, Tuple tuple) {
        if (selector.isNone()) {
            return tuple;
        }
        int[] pos = this.tuple.getPos(this.fields, selector);
        if (pos == null || pos.length == 0) {
            tuple.addAll(this.tuple);
        } else {
            for (int i : pos) {
                tuple.add(this.tuple.getObject(i));
            }
        }
        return tuple;
    }

    public void setTuple(Fields selector, Tuple tuple) {
        if (selector == null || selector.isAll()) {
            this.tuple.setAll(tuple);
        } else {
            this.tuple.set(this.fields, selector, tuple);
        }
    }

    public void set(TupleEntry tupleEntry) {
        this.tuple.set(this.fields, tupleEntry.getFields(), tupleEntry.getTuple(), tupleEntry.coercions);
    }

    public TupleEntry appendNew(TupleEntry entry) {
        Fields appendedFields = this.fields.append(entry.fields.isUnknown() ? Fields.size(entry.tuple.size()) : entry.fields);
        Tuple appendedTuple = this.tuple.append(entry.tuple);
        return new TupleEntry(appendedFields, appendedTuple);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TupleEntry)) {
            return false;
        }
        TupleEntry that = (TupleEntry)object;
        if (this.fields != null ? !this.fields.equals(that.fields) : that.fields != null) {
            return false;
        }
        return !(this.tuple != null ? this.fields.compare(this.tuple, that.tuple) != 0 : that.tuple != null);
    }

    public int hashCode() {
        int result = this.fields != null ? this.fields.hashCode() : 0;
        result = 31 * result + (this.tuple != null ? this.tuple.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.fields == null) {
            return "empty";
        }
        if (this.tuple == null) {
            return "fields: " + this.fields.print();
        }
        return "fields: " + this.fields.print() + " tuple: " + this.tuple.print();
    }

    public <T> Iterable<T> asIterableOf(final Class<T> type) {
        if (this.iterableCache == null) {
            this.iterableCache = new IdentityHashMap<Class, CoercionFrom[]>();
        }
        final CoercionFrom[] coerce = this.coercions.length == 0 ? null : this.iterableCache.computeIfAbsent(type, t -> Coercions.coercionsArray(type, this.coercions));
        return () -> new Iterator<T>(){
            final Iterator valuesIterator;
            final Iterator coercionsIterator;
            {
                this.coercionsIterator = coerce == null ? new ForeverValueIterator(Coercions.OBJECT.to(type)) : Arrays.asList(coerce).iterator();
                this.valuesIterator = TupleEntry.this.tuple.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.valuesIterator.hasNext();
            }

            @Override
            public T next() {
                Object next = this.valuesIterator.next();
                return ((CoercionFrom)this.coercionsIterator.next()).coerce(next);
            }

            @Override
            public void remove() {
                this.valuesIterator.remove();
            }
        };
    }

    public Iterable<String[]> asPairwiseIterable() {
        return () -> {
            final Iterator fieldsIterator = this.fields.iterator();
            final Iterator<String> valuesIterator = this.asIterableOf(String.class).iterator();
            return new Iterator<String[]>(){

                @Override
                public boolean hasNext() {
                    return valuesIterator.hasNext();
                }

                @Override
                public String[] next() {
                    String field = ((Comparable)fieldsIterator.next()).toString();
                    String next = (String)valuesIterator.next();
                    return new String[]{field, next};
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove is unsupported");
                }
            };
        };
    }
}

