/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.Tuple;
import cascading.tuple.util.Resettable;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;

public class TupleChainIterator
implements Iterator<Tuple>,
Closeable,
Resettable<Iterator<Tuple>> {
    Iterator<Tuple>[] iterators;
    int currentIterator = 0;

    public TupleChainIterator(Iterator<Tuple> ... iterators) {
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        if (this.iterators.length < this.currentIterator + 1) {
            return false;
        }
        if (this.iterators[this.currentIterator].hasNext()) {
            return true;
        }
        this.closeCurrent();
        ++this.currentIterator;
        return this.iterators.length != this.currentIterator && this.hasNext();
    }

    public void reset(Iterator<Tuple> ... iterators) {
        this.currentIterator = 0;
        this.iterators = iterators;
    }

    @Override
    public Tuple next() {
        this.hasNext();
        return this.iterators[this.currentIterator].next();
    }

    @Override
    public void remove() {
        this.iterators[this.currentIterator].remove();
    }

    @Override
    public void close() {
        if (this.iterators.length != this.currentIterator) {
            this.closeCurrent();
        }
    }

    protected void closeCurrent() {
        this.close(this.iterators[this.currentIterator]);
    }

    private void close(Iterator iterator) {
        if (iterator instanceof Closeable) {
            try {
                ((Closeable)((Object)iterator)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

