/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleException;
import cascading.tuple.Tuples;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Tuple
implements Comparable<Object>,
Iterable<Object>,
Serializable {
    public static final Tuple NULL = Tuples.asUnmodifiable(new Tuple());
    private static final String printDelim = "\t";
    protected transient boolean isUnmodifiable = false;
    protected List<Object> elements;

    protected Tuple(List<Object> elements) {
        this.elements = elements;
    }

    public Tuple() {
        this(new ArrayList<Object>());
    }

    @ConstructorProperties(value={"tuple"})
    public Tuple(Tuple tuple) {
        this(new ArrayList<Object>(tuple.elements));
    }

    @ConstructorProperties(value={"values"})
    public Tuple(Object ... values) {
        this(new ArrayList<Object>(values.length));
        Collections.addAll(this.elements, values);
    }

    public static Tuple size(int size) {
        return Tuple.size(size, null);
    }

    public static Tuple size(int size, Comparable value) {
        Tuple result = new Tuple(new ArrayList<Object>(size));
        for (int i = 0; i < size; ++i) {
            result.elements.add(value);
        }
        return result;
    }

    public static List<Object> elements(Tuple tuple) {
        return tuple.elements;
    }

    public boolean isUnmodifiable() {
        return this.isUnmodifiable;
    }

    public Object getObject(int pos) {
        return this.elements.get(pos);
    }

    public char getChar(int pos) {
        return Coercions.CHARACTER.coerce(this.getObject(pos)).charValue();
    }

    public String getString(int pos) {
        return Coercions.STRING.coerce(this.getObject(pos));
    }

    public float getFloat(int pos) {
        return Coercions.FLOAT.coerce(this.getObject(pos)).floatValue();
    }

    public double getDouble(int pos) {
        return Coercions.DOUBLE.coerce(this.getObject(pos));
    }

    public int getInteger(int pos) {
        return Coercions.INTEGER.coerce(this.getObject(pos));
    }

    public long getLong(int pos) {
        return Coercions.LONG.coerce(this.getObject(pos));
    }

    public short getShort(int pos) {
        return Coercions.SHORT.coerce(this.getObject(pos));
    }

    public boolean getBoolean(int pos) {
        return Coercions.BOOLEAN.coerce(this.getObject(pos));
    }

    public Tuple get(int[] pos) {
        if (pos == null || pos.length == 0) {
            return new Tuple(this);
        }
        Tuple results = new Tuple(new ArrayList<Object>(pos.length));
        for (int i : pos) {
            results.elements.add(this.elements.get(i));
        }
        return results;
    }

    public Tuple get(Fields declarator, Fields selector) {
        try {
            return this.get(this.getPos(declarator, selector));
        }
        catch (Exception exception) {
            throw new TupleException("unable to select from: " + declarator.print() + ", using selector: " + selector.print(), exception);
        }
    }

    public int[] getPos(Fields declarator, Fields selector) {
        if (!declarator.isUnknown() && this.elements.size() != declarator.size()) {
            throw new TupleException("field declaration: " + declarator.print() + ", does not match tuple: " + this.print());
        }
        return declarator.getPos(selector, this.size());
    }

    public Tuple leave(int[] pos) {
        this.verifyModifiable();
        Tuple results = this.remove(pos);
        List<Object> temp = results.elements;
        results.elements = this.elements;
        this.elements = temp;
        return results;
    }

    public void clear() {
        this.verifyModifiable();
        this.elements.clear();
    }

    public void add(Comparable value) {
        this.add((Object)value);
    }

    public void add(Object value) {
        this.verifyModifiable();
        this.elements.add(value);
    }

    public void addBoolean(boolean value) {
        this.verifyModifiable();
        this.elements.add(value);
    }

    public void addShort(short value) {
        this.verifyModifiable();
        this.elements.add(value);
    }

    public void addInteger(int value) {
        this.verifyModifiable();
        this.elements.add(value);
    }

    public void addLong(long value) {
        this.verifyModifiable();
        this.elements.add(value);
    }

    public void addFloat(float value) {
        this.verifyModifiable();
        this.elements.add(Float.valueOf(value));
    }

    public void addDouble(double value) {
        this.verifyModifiable();
        this.elements.add(value);
    }

    public void addString(String value) {
        this.verifyModifiable();
        this.elements.add(value);
    }

    public void addAll(Object ... values) {
        this.verifyModifiable();
        if (values.length == 1 && values[0] instanceof Tuple) {
            this.addAll((Tuple)values[0]);
        } else {
            Collections.addAll(this.elements, values);
        }
    }

    public void addAll(Tuple tuple) {
        this.verifyModifiable();
        if (tuple != null) {
            this.elements.addAll(tuple.elements);
        }
    }

    public void setAll(Tuple tuple) {
        this.verifyModifiable();
        if (tuple == null) {
            return;
        }
        for (int i = 0; i < tuple.elements.size(); ++i) {
            this.internalSet(i, tuple.elements.get(i));
        }
    }

    public void setAll(Tuple ... tuples) {
        this.verifyModifiable();
        if (tuples.length == 0) {
            return;
        }
        int pos = 0;
        for (int i = 0; i < tuples.length; ++i) {
            Tuple tuple = tuples[i];
            if (tuple == null) continue;
            for (int j = 0; j < tuple.elements.size(); ++j) {
                this.internalSet(pos++, tuple.elements.get(j));
            }
        }
    }

    public void setAll(Iterable<Tuple> tuples) {
        this.verifyModifiable();
        int pos = 0;
        for (Tuple tuple : tuples) {
            if (tuple == null) continue;
            for (int j = 0; j < tuple.elements.size(); ++j) {
                this.internalSet(pos++, tuple.elements.get(j));
            }
        }
    }

    public void setAllTo(Object value) {
        this.verifyModifiable();
        for (int i = 0; i < this.elements.size(); ++i) {
            this.internalSet(i, value);
        }
    }

    public void set(int index, Object value) {
        this.verifyModifiable();
        this.internalSet(index, value);
    }

    public void setBoolean(int index, boolean value) {
        this.verifyModifiable();
        this.internalSet(index, value);
    }

    public void setShort(int index, short value) {
        this.verifyModifiable();
        this.internalSet(index, value);
    }

    public void setInteger(int index, int value) {
        this.verifyModifiable();
        this.internalSet(index, value);
    }

    public void setLong(int index, long value) {
        this.verifyModifiable();
        this.internalSet(index, value);
    }

    public void setFloat(int index, float value) {
        this.verifyModifiable();
        this.internalSet(index, Float.valueOf(value));
    }

    public void setDouble(int index, double value) {
        this.verifyModifiable();
        this.internalSet(index, value);
    }

    public void setString(int index, String value) {
        this.verifyModifiable();
        this.internalSet(index, value);
    }

    protected final void internalSet(int index, Object value) {
        try {
            this.elements.set(index, value);
        }
        catch (IndexOutOfBoundsException exception) {
            if (this.elements.size() != 0) {
                throw new TupleException("failed to set a value beyond the end of the tuple elements array, size: " + this.size() + " , index: " + index);
            }
            throw new TupleException("failed to set a value, tuple may not be initialized with values, is zero length");
        }
    }

    public void put(Fields declarator, Fields fields, Tuple tuple) {
        this.verifyModifiable();
        int[] pos = this.getPos(declarator, fields);
        for (int i = 0; i < pos.length; ++i) {
            this.internalSet(pos[i], tuple.getObject(i));
        }
    }

    public Tuple remove(int[] pos) {
        this.verifyModifiable();
        int[] offset = new int[pos.length];
        for (int i = 0; i < pos.length; ++i) {
            offset[i] = 0;
            for (int j = 0; j < i; ++j) {
                if (pos[j] >= pos[i]) continue;
                int n = i;
                offset[n] = offset[n] + 1;
            }
        }
        Tuple results = new Tuple();
        for (int i = 0; i < pos.length; ++i) {
            results.add(this.elements.remove(pos[i] - offset[i]));
        }
        return results;
    }

    public Tuple remove(Fields declarator, Fields selector) {
        return this.remove(this.getPos(declarator, selector));
    }

    Tuple extract(int[] pos) {
        Tuple results = new Tuple();
        for (int i : pos) {
            results.add((Object)this.elements.set(i, null));
        }
        return results;
    }

    Tuple nulledCopy(int[] pos) {
        if (pos == null) {
            return Tuple.size(this.size());
        }
        Tuple results = new Tuple(this);
        for (int i : pos) {
            results.set(i, null);
        }
        return results;
    }

    void set(int[] pos, Tuple tuple) {
        this.verifyModifiable();
        if (pos.length != tuple.size()) {
            throw new TupleException("given tuple not same size as position array: " + pos.length + ", tuple: " + tuple.print());
        }
        int count = 0;
        for (int i : pos) {
            this.elements.set(i, tuple.elements.get(count++));
        }
    }

    private void set(int[] pos, Type[] types, Tuple tuple, CoercibleType[] coercions) {
        this.verifyModifiable();
        if (pos.length != tuple.size()) {
            throw new TupleException("given tuple not same size as position array: " + pos.length + ", tuple: " + tuple.print());
        }
        int count = 0;
        for (int i : pos) {
            Object element = tuple.elements.get(count);
            if (types != null) {
                Type type = types[i];
                element = coercions[count].coerce(element, type);
            }
            this.elements.set(i, element);
            ++count;
        }
    }

    public void set(Fields declarator, Fields selector, Tuple tuple) {
        try {
            this.set(declarator.getPos(selector), declarator.getTypes(), tuple, TupleEntry.getCoercions(declarator, tuple));
        }
        catch (Exception exception) {
            throw new TupleException("unable to set into: " + declarator.print() + ", using selector: " + selector.print(), exception);
        }
    }

    protected void set(Fields declarator, Fields selector, Tuple tuple, CoercibleType[] coercions) {
        try {
            this.set(declarator.getPos(selector), declarator.getTypes(), tuple, coercions);
        }
        catch (Exception exception) {
            throw new TupleException("unable to set into: " + declarator.print() + ", using selector: " + selector.print(), exception);
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return this.elements.iterator();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public int size() {
        return this.elements.size();
    }

    private Object[] elements() {
        return this.elements.toArray();
    }

    <T> T[] elements(T[] destination) {
        return this.elements.toArray(destination);
    }

    public Class[] getTypes() {
        Class[] types = new Class[this.elements.size()];
        for (int i = 0; i < this.elements.size(); ++i) {
            Object value = this.elements.get(i);
            if (value == null) continue;
            types[i] = value.getClass();
        }
        return types;
    }

    public Tuple append(Tuple ... tuples) {
        Tuple result = new Tuple(this);
        for (Tuple tuple : tuples) {
            result.addAll(tuple);
        }
        return result;
    }

    @Override
    public int compareTo(Tuple other) {
        if (other == null || other.elements == null) {
            return 1;
        }
        if (other.elements.size() != this.elements.size()) {
            return this.elements.size() - other.elements.size();
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            Comparable lhs = (Comparable)this.elements.get(i);
            Comparable rhs = (Comparable)other.elements.get(i);
            if (lhs == null && rhs == null) continue;
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            int c = lhs.compareTo(rhs);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public int compareTo(Comparator[] comparators, Tuple other) {
        if (comparators == null) {
            return this.compareTo(other);
        }
        if (other == null || other.elements == null) {
            return 1;
        }
        if (other.elements.size() != this.elements.size()) {
            return this.elements.size() - other.elements.size();
        }
        if (comparators.length != this.elements.size()) {
            throw new IllegalArgumentException("comparator array not same size as tuple elements");
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            int c;
            Object lhs = this.elements.get(i);
            Object rhs = other.elements.get(i);
            if (comparators[i] != null) {
                c = comparators[i].compare(lhs, rhs);
            } else if (lhs == null && rhs == null) {
                c = 0;
            } else {
                if (lhs == null) {
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                c = ((Comparable)lhs).compareTo(rhs);
            }
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public int compareTo(Object other) {
        if (other instanceof Tuple) {
            return this.compareTo((Tuple)other);
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Tuple)) {
            return false;
        }
        Tuple other = (Tuple)object;
        if (this.elements.size() != other.elements.size()) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            Object lhs = this.elements.get(i);
            Object rhs = other.elements.get(i);
            if (lhs == null && rhs == null) continue;
            if (lhs == null || rhs == null) {
                return false;
            }
            if (lhs.equals(rhs)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        for (Object element : this.elements) {
            hash = 31 * hash + (element != null ? element.hashCode() : 0);
        }
        return hash;
    }

    public String toString() {
        return Util.join(this.elements, printDelim, true);
    }

    public String toString(String delim) {
        return Util.join(this.elements, delim, true);
    }

    public String toString(String delim, boolean printNull) {
        return Util.join(this.elements, delim, printNull);
    }

    public String format(String format) {
        return String.format(format, this.elements());
    }

    public String print() {
        return this.printTo(new StringBuffer()).toString();
    }

    public StringBuffer printTo(StringBuffer buffer) {
        buffer.append("[");
        if (this.elements != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                Object element = this.elements.get(i);
                if (element instanceof Tuple) {
                    ((Tuple)element).printTo(buffer);
                } else if (element == null) {
                    buffer.append(element);
                } else {
                    buffer.append("'").append(element).append("'");
                }
                if (i >= this.elements.size() - 1) continue;
                buffer.append(", ");
            }
        }
        buffer.append("]");
        return buffer;
    }

    private final void verifyModifiable() {
        if (this.isUnmodifiable) {
            throw new UnsupportedOperationException("this tuple is unmodifiable");
        }
    }
}

