/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.FieldsResolverException;
import cascading.tuple.Tuple;
import cascading.tuple.TupleException;
import cascading.tuple.type.CoercibleType;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;

public class Fields
implements Comparable,
Iterable<Comparable>,
Serializable,
Comparator<Tuple> {
    public static final Fields UNKNOWN = new Fields(Kind.UNKNOWN);
    public static final Fields NONE = new Fields(Kind.NONE);
    public static final Fields ALL = new Fields(Kind.ALL);
    public static final Fields GROUP = new Fields(Kind.GROUP);
    public static final Fields VALUES = new Fields(Kind.VALUES);
    public static final Fields ARGS = new Fields(Kind.ARGS);
    public static final Fields RESULTS = new Fields(Kind.RESULTS);
    public static final Fields REPLACE = new Fields(Kind.REPLACE);
    public static final Fields SWAP = new Fields(Kind.SWAP);
    public static final Fields FIRST = new Fields(Integer.valueOf(0));
    public static final Fields LAST = new Fields(Integer.valueOf(-1));
    private static final int[] EMPTY_INT = new int[0];
    Comparable[] fields = new Comparable[0];
    boolean isOrdered = true;
    Kind kind;
    Type[] types;
    Comparator[] comparators;
    transient int[] thisPos;
    transient Map<Comparable, Integer> index;
    transient Map<Fields, int[]> posCache;
    transient int hashCode;

    public static Fields[] fields(Fields ... fields) {
        return fields;
    }

    public static Comparable[] names(Comparable ... names) {
        return names;
    }

    public static Type[] types(Type ... types) {
        return types;
    }

    public static Fields size(int size) {
        if (size == 0) {
            return NONE;
        }
        Fields fields = new Fields();
        fields.kind = null;
        fields.fields = Fields.expand(size, 0);
        return fields;
    }

    public static Fields size(int size, Type type) {
        if (size == 0) {
            return NONE;
        }
        Fields fields = new Fields();
        fields.kind = null;
        fields.fields = Fields.expand(size, 0);
        for (Comparable field : fields) {
            fields = fields.applyType(field, type);
        }
        return fields;
    }

    public static Fields join(Fields ... fields) {
        return Fields.join(false, fields);
    }

    public static Fields join(boolean maskDuplicateNames, Fields ... fields) {
        Type[] types;
        int size = 0;
        for (Fields field : fields) {
            if (field.isSubstitution() || field.isUnknown()) {
                throw new TupleException("cannot join fields if one is a substitution or is unknown");
            }
            size += field.size();
        }
        if (size == 0) {
            return NONE;
        }
        Comparable[] elements = Fields.join(size, fields);
        if (maskDuplicateNames) {
            HashSet<String> names = new HashSet<String>();
            for (int i = elements.length - 1; i >= 0; --i) {
                Comparable element = elements[i];
                if (names.contains(element)) {
                    elements[i] = Integer.valueOf(i);
                    continue;
                }
                if (!(element instanceof String)) continue;
                names.add((String)((Object)element));
            }
        }
        if ((types = Fields.joinTypes(size, fields)) == null) {
            return new Fields(elements);
        }
        return new Fields(elements, types);
    }

    private static Comparable[] join(int size, Fields ... fields) {
        Comparable[] elements = Fields.expand(size, 0);
        int pos = 0;
        for (Fields field : fields) {
            System.arraycopy(field.fields, 0, elements, pos, field.size());
            pos += field.size();
        }
        return elements;
    }

    private static Type[] joinTypes(int size, Fields ... fields) {
        Type[] elements = new Type[size];
        int pos = 0;
        for (Fields field : fields) {
            if (field.isNone()) continue;
            if (field.types == null) {
                return null;
            }
            System.arraycopy(field.types, 0, elements, pos, field.size());
            pos += field.size();
        }
        return elements;
    }

    public static Fields mask(Fields fields, Fields mask) {
        Comparable[] elements = Fields.expand(fields.size(), 0);
        System.arraycopy(fields.fields, 0, elements, 0, elements.length);
        for (int i = elements.length - 1; i >= 0; --i) {
            Comparable element = elements[i];
            if (element instanceof Integer || !mask.getIndex().containsKey(element)) continue;
            elements[i] = Integer.valueOf(i);
        }
        return new Fields(elements);
    }

    public static Fields merge(Fields ... fields) {
        ArrayList<Comparable> elements = new ArrayList<Comparable>();
        ArrayList<Type> elementTypes = new ArrayList<Type>();
        for (Fields field : fields) {
            Type[] types = field.getTypes();
            int i = 0;
            for (Comparable comparable : field) {
                if (!elements.contains(comparable)) {
                    elements.add(comparable);
                    elementTypes.add(types == null ? null : types[i]);
                }
                ++i;
            }
        }
        Comparable[] comparables = elements.toArray(new Comparable[elements.size()]);
        Object[] types = elementTypes.toArray(new Type[elementTypes.size()]);
        if (Util.containsNull(types)) {
            return new Fields(comparables);
        }
        return new Fields(comparables, (Type[])types);
    }

    public static Fields copyComparators(Fields toFields, Fields ... fromFields) {
        for (Fields fromField : fromFields) {
            for (Comparable field : fromField) {
                Comparator comparator = fromField.getComparator(field);
                if (comparator == null) continue;
                toFields.setComparator(field, comparator);
            }
        }
        return toFields;
    }

    public static Fields offsetSelector(int size, int startPos) {
        Fields fields = new Fields();
        fields.kind = null;
        fields.isOrdered = startPos == 0;
        fields.fields = Fields.expand(size, startPos);
        return fields;
    }

    private static Comparable[] expand(int size, int startPos) {
        if (size < 1) {
            throw new TupleException("invalid size for fields: " + size);
        }
        if (startPos < 0) {
            throw new TupleException("invalid start position for fields: " + startPos);
        }
        Comparable[] fields = new Comparable[size];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = Integer.valueOf(i + startPos);
        }
        return fields;
    }

    public static Fields resolve(Fields selector, Fields ... fields) {
        int i;
        boolean hasUnknowns = false;
        int size = 0;
        for (Fields field : fields) {
            if (field.isUnknown()) {
                hasUnknowns = true;
            }
            if (!field.isDefined() && field.isUnOrdered()) {
                throw new TupleException("unable to select from field set: " + field.printVerbose());
            }
            size += field.size();
        }
        if (selector.isAll()) {
            Fields result = fields[0];
            for (i = 1; i < fields.length; ++i) {
                result = result.append(fields[i]);
            }
            return result;
        }
        if (selector.isReplace()) {
            if (fields[1].isUnknown()) {
                throw new TupleException("cannot replace fields with unknown field declaration");
            }
            if (!fields[0].contains(fields[1])) {
                throw new TupleException("could not find all fields to be replaced, available: " + fields[0].printVerbose() + ",  declared: " + fields[1].printVerbose());
            }
            Type[] types = fields[0].getTypes();
            if (types != null) {
                for (i = 1; i < fields.length; ++i) {
                    Type[] fieldTypes = fields[i].getTypes();
                    if (fieldTypes == null) {
                        fields[0] = fields[0].applyTypes((Type[])null);
                        continue;
                    }
                    for (int j = 0; j < fieldTypes.length; ++j) {
                        fields[0] = fields[0].applyType(fields[i].get(j), fieldTypes[j]);
                    }
                }
            }
            return fields[0];
        }
        if (!selector.isDefined()) {
            throw new TupleException("unable to use given selector: " + selector);
        }
        LinkedHashSet<String> notFound = new LinkedHashSet<String>();
        HashSet<String> found = new HashSet<String>();
        Fields result = Fields.size(selector.size());
        if (hasUnknowns) {
            size = -1;
        }
        Object[] types = null;
        if (size != -1) {
            types = new Type[result.size()];
        }
        int offset = 0;
        for (Fields current : fields) {
            if (current.isNone()) continue;
            Fields.resolveInto(notFound, found, selector, current, result, (Type[])types, offset, size);
            offset += current.size();
        }
        if (types != null && !Util.containsNull(types)) {
            result = result.applyTypes((Type[])types);
        }
        notFound.removeAll(found);
        if (!notFound.isEmpty()) {
            throw new FieldsResolverException(new Fields(Fields.join(size, fields)), new Fields(notFound.toArray(new Comparable[notFound.size()])));
        }
        if (hasUnknowns) {
            return selector;
        }
        return result;
    }

    private static void resolveInto(Set<String> notFound, Set<String> found, Fields selector, Fields current, Fields result, Type[] types, int offset, int size) {
        for (int i = 0; i < selector.size(); ++i) {
            Comparable field = selector.get(i);
            if (field instanceof String) {
                int index = current.indexOfSafe(field);
                if (index == -1) {
                    notFound.add((String)((Object)field));
                } else {
                    result.set(i, Fields.handleFound(found, field));
                }
                if (index == -1 || types == null || current.getType(index) == null) continue;
                types[i] = current.getType(index);
                continue;
            }
            int pos = current.translatePos((Integer)field, size) - offset;
            if (pos >= current.size() || pos < 0) continue;
            Comparable thisField = current.get(pos);
            if (types != null && current.getType(pos) != null) {
                types[i] = current.getType(pos);
            }
            if (thisField instanceof String) {
                result.set(i, Fields.handleFound(found, thisField));
                continue;
            }
            result.set(i, field);
        }
    }

    private static Comparable handleFound(Set<String> found, Comparable field) {
        if (found.contains(field)) {
            throw new TupleException("field name already exists: " + field);
        }
        found.add((String)((Object)field));
        return field;
    }

    public static Fields asDeclaration(Fields fields) {
        if (fields == null) {
            return null;
        }
        if (fields.isNone()) {
            return fields;
        }
        if (!fields.isDefined()) {
            return UNKNOWN;
        }
        if (fields.isOrdered()) {
            return fields;
        }
        Fields result = Fields.size(fields.size());
        Fields.copy(null, result, fields, 0);
        result.types = Fields.copyTypes(fields.types, result.size());
        result.comparators = fields.comparators;
        return result;
    }

    private static Fields asSelector(Fields fields) {
        if (!fields.isDefined()) {
            return UNKNOWN;
        }
        return fields;
    }

    protected Fields(Kind kind) {
        this.kind = kind;
    }

    public Fields() {
        this.kind = Kind.NONE;
    }

    @ConstructorProperties(value={"fields"})
    public Fields(Comparable ... fields) {
        if (fields.length == 0) {
            this.kind = Kind.NONE;
        } else {
            this.fields = this.validate(fields);
        }
    }

    @ConstructorProperties(value={"field", "type"})
    public Fields(Comparable field, Type type) {
        this(Fields.names(field), Fields.types(type));
    }

    @ConstructorProperties(value={"fields", "types"})
    public Fields(Comparable[] fields, Type[] types) {
        this(fields);
        if (this.isDefined() && types != null) {
            if (this.fields.length != types.length) {
                throw new IllegalArgumentException("given types array must be same length as fields");
            }
            if (Util.containsNull(types)) {
                throw new IllegalArgumentException("given types array contains null");
            }
            this.types = Fields.copyTypes(types, this.fields.length);
        }
    }

    @ConstructorProperties(value={"types"})
    public Fields(Type ... types) {
        if (types.length == 0) {
            this.kind = Kind.NONE;
            return;
        }
        this.fields = Fields.expand(types.length, 0);
        if (this.fields.length != types.length) {
            throw new IllegalArgumentException("given types array must be same length as fields");
        }
        if (Util.containsNull(types)) {
            throw new IllegalArgumentException("given types array contains null");
        }
        this.types = Fields.copyTypes(types, this.fields.length);
    }

    public boolean isUnOrdered() {
        return !this.isOrdered || this.kind == Kind.ALL;
    }

    public boolean isOrdered() {
        return this.isOrdered || this.kind == Kind.UNKNOWN;
    }

    public boolean isDefined() {
        return this.kind == null;
    }

    public boolean isOutSelector() {
        return this.isAll() || this.isResults() || this.isReplace() || this.isSwap() || this.isDefined();
    }

    public boolean isArgSelector() {
        return this.isAll() || this.isNone() || this.isGroup() || this.isValues() || this.isDefined();
    }

    public boolean isDeclarator() {
        return this.isUnknown() || this.isNone() || this.isAll() || this.isArguments() || this.isGroup() || this.isValues() || this.isDefined();
    }

    public boolean isNone() {
        return this.kind == Kind.NONE;
    }

    public boolean isAll() {
        return this.kind == Kind.ALL;
    }

    public boolean isUnknown() {
        return this.kind == Kind.UNKNOWN;
    }

    public boolean isArguments() {
        return this.kind == Kind.ARGS;
    }

    public boolean isValues() {
        return this.kind == Kind.VALUES;
    }

    public boolean isResults() {
        return this.kind == Kind.RESULTS;
    }

    public boolean isReplace() {
        return this.kind == Kind.REPLACE;
    }

    public boolean isSwap() {
        return this.kind == Kind.SWAP;
    }

    public boolean isGroup() {
        return this.kind == Kind.GROUP;
    }

    public boolean isSubstitution() {
        return this.isAll() || this.isArguments() || this.isGroup() || this.isValues();
    }

    private Comparable[] validate(Comparable[] fields) {
        this.isOrdered = true;
        HashSet<Comparable> names = new HashSet<Comparable>();
        for (int i = 0; i < fields.length; ++i) {
            Comparable field = fields[i];
            if (!(field instanceof String) && !(field instanceof Integer)) {
                throw new IllegalArgumentException(String.format("invalid field type (%s); must be String or Integer: ", field));
            }
            if (names.contains(field)) {
                throw new IllegalArgumentException("duplicate field name found: " + field);
            }
            names.add(field);
            if (!(field instanceof Number) || (Integer)field == i) continue;
            this.isOrdered = false;
        }
        return fields;
    }

    final Comparable[] get() {
        return this.fields;
    }

    public final Comparable get(int i) {
        return this.fields[i];
    }

    final void set(int i, Comparable comparable) {
        this.fields[i] = comparable;
        if (this.isOrdered() && comparable instanceof Integer) {
            this.isOrdered = i == (Integer)comparable;
        }
    }

    public int[] getPos() {
        if (this.thisPos != null) {
            return this.thisPos;
        }
        this.thisPos = this.isAll() || this.isUnknown() ? EMPTY_INT : this.makeThisPos();
        return this.thisPos;
    }

    public boolean hasRelativePos() {
        for (int i : this.getPos()) {
            if (i >= 0) continue;
            return true;
        }
        return false;
    }

    private int[] makeThisPos() {
        int[] pos = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            Comparable field = this.get(i);
            pos[i] = field instanceof Number ? (Integer)field : i;
        }
        return pos;
    }

    private Map<Fields, int[]> getPosCache() {
        if (this.posCache == null) {
            this.posCache = new WeakHashMap<Fields, int[]>();
        }
        return this.posCache;
    }

    private final int[] putReturn(Fields fields, int[] pos) {
        this.getPosCache().put(fields, pos);
        return pos;
    }

    public final int[] getPos(Fields fields) {
        return this.getPos(fields, -1);
    }

    final int[] getPos(Fields fields, int tupleSize) {
        int[] pos = this.getPosCache().get(fields);
        if (!this.isUnknown() && pos != null) {
            return pos;
        }
        if (fields.isAll()) {
            return this.putReturn(fields, null);
        }
        if (this.isAll()) {
            return this.putReturn(fields, fields.getPos());
        }
        if (this.size() == 0 && this.isUnknown()) {
            return this.translatePos(fields, tupleSize);
        }
        pos = this.translatePos(fields, this.size());
        return this.putReturn(fields, pos);
    }

    private int[] translatePos(Fields fields, int fieldSize) {
        int[] pos = new int[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            Comparable field = fields.get(i);
            pos[i] = field instanceof Number ? this.translatePos((Integer)field, fieldSize) : this.indexOf(field);
        }
        return pos;
    }

    final int translatePos(Integer integer) {
        return this.translatePos(integer, this.size());
    }

    final int translatePos(Integer integer, int size) {
        if (size == -1) {
            return integer;
        }
        if (integer < 0) {
            integer = size + integer;
        }
        if (!(this.isUnknown() || integer < size && integer >= 0)) {
            throw new TupleException("position value is too large: " + integer + ", positions in field: " + size);
        }
        return integer;
    }

    public int getPos(Comparable fieldName) {
        if (fieldName instanceof Number) {
            return this.translatePos((Integer)fieldName);
        }
        return this.indexOf(fieldName);
    }

    private final Map<Comparable, Integer> getIndex() {
        if (this.index != null) {
            return this.index;
        }
        HashMap<Comparable, Integer> local = new HashMap<Comparable, Integer>();
        for (int i = 0; i < this.size(); ++i) {
            local.put(this.get(i), i);
        }
        this.index = local;
        return this.index;
    }

    private int indexOf(Comparable fieldName) {
        Integer result = this.getIndex().get(fieldName);
        if (result == null) {
            throw new FieldsResolverException(this, new Fields(fieldName));
        }
        return result;
    }

    int indexOfSafe(Comparable fieldName) {
        Integer result = this.getIndex().get(fieldName);
        if (result == null) {
            return -1;
        }
        return result;
    }

    @Override
    public Iterator iterator() {
        return Arrays.stream(this.fields).iterator();
    }

    public Iterator<Fields> fieldsIterator() {
        if (this.types == null) {
            return Arrays.stream(this.fields).map(xva$0 -> new Fields((Comparable)xva$0)).iterator();
        }
        return IntStream.range(0, this.fields.length).mapToObj(pos -> new Fields(this.fields[pos], this.types[pos])).iterator();
    }

    public Fields select(Fields selector) {
        Comparable field;
        int i;
        if (!this.isOrdered()) {
            throw new TupleException("this fields instance can only be used as a selector");
        }
        if (selector.isAll()) {
            return this;
        }
        if (this.isUnknown()) {
            return Fields.asSelector(selector);
        }
        if (selector.isNone()) {
            return NONE;
        }
        Fields result = Fields.size(selector.size());
        for (i = 0; i < selector.size(); ++i) {
            field = selector.get(i);
            if (field instanceof String) {
                result.set(i, this.get(this.indexOf(field)));
                continue;
            }
            int pos = this.translatePos((Integer)field);
            if (this.get(pos) instanceof String) {
                result.set(i, this.get(pos));
                continue;
            }
            result.set(i, Integer.valueOf(pos));
        }
        if (this.types != null) {
            result.types = new Type[result.size()];
            for (i = 0; i < selector.size(); ++i) {
                field = selector.get(i);
                if (field instanceof String) {
                    result.setType(i, this.getType(this.indexOf(field)));
                    continue;
                }
                result.setType(i, this.getType(this.translatePos((Integer)field)));
            }
        }
        return result;
    }

    public Fields selectPos(Fields selector) {
        return this.selectPos(selector, 0);
    }

    public Fields selectPos(Fields selector, int offset) {
        int[] pos = this.getPos(selector);
        Fields results = Fields.size(pos.length);
        for (int i = 0; i < pos.length; ++i) {
            results.fields[i] = Integer.valueOf(pos[i] + offset);
        }
        return results;
    }

    public Fields subtract(Fields fields) {
        int[] pos;
        if (fields.isAll()) {
            return NONE;
        }
        if (fields.isNone()) {
            return this;
        }
        LinkedList list = new LinkedList();
        Collections.addAll(list, this.get());
        for (int i : pos = this.getPos(fields, -1)) {
            list.set(i, null);
        }
        Util.removeAllNulls(list);
        Type[] newTypes = null;
        if (this.types != null) {
            LinkedList types = new LinkedList();
            Collections.addAll(types, this.types);
            for (int i : pos) {
                types.set(i, null);
            }
            Util.removeAllNulls(types);
            newTypes = types.toArray(new Type[types.size()]);
        }
        return new Fields(list.toArray(new Comparable[list.size()]), newTypes);
    }

    public Fields append(Fields fields) {
        return this.appendInternal(fields, false);
    }

    public Fields appendSelector(Fields fields) {
        return this.appendInternal(fields, true);
    }

    private Fields appendInternal(Fields fields, boolean isSelect) {
        if (fields == null) {
            return this;
        }
        if (this.isAll() || fields.isAll()) {
            throw new TupleException("cannot append fields: " + this.print() + " + " + fields.print());
        }
        if ((this.isUnknown() || this.size() == 0) && fields.isUnknown()) {
            return UNKNOWN;
        }
        if (fields.isNone()) {
            return this;
        }
        if (this.isNone()) {
            return fields;
        }
        HashSet<Comparable> names = new HashSet<Comparable>();
        Fields result = Fields.size(this.size() + fields.size());
        Fields.copyRetain(names, result, this, 0, isSelect);
        Fields.copyRetain(names, result, fields, this.size(), isSelect);
        if (this.isUnknown() || fields.isUnknown()) {
            result.kind = Kind.UNKNOWN;
        }
        if ((this.isNone() || this.types != null) && fields.types != null) {
            result.types = new Type[this.size() + fields.size()];
            if (this.types != null) {
                System.arraycopy(this.types, 0, result.types, 0, this.size());
            }
            System.arraycopy(fields.types, 0, result.types, this.size(), fields.size());
        }
        return result;
    }

    public Fields rename(Fields from, Fields to) {
        if (this.isSubstitution() || this.isUnknown()) {
            throw new TupleException("cannot rename fields in a substitution or unknown Fields instance: " + this.print());
        }
        if (from.size() != to.size()) {
            throw new TupleException("from and to fields must be the same size");
        }
        if (from.isSubstitution() || from.isUnknown()) {
            throw new TupleException("from fields may not be a substitution or unknown");
        }
        if (to.isSubstitution() || to.isUnknown()) {
            throw new TupleException("to fields may not be a substitution or unknown");
        }
        Comparable[] newFields = Arrays.copyOf(this.fields, this.fields.length);
        int[] pos = this.getPos(from);
        for (int i = 0; i < pos.length; ++i) {
            newFields[pos[i]] = to.fields[i];
        }
        Type[] newTypes = null;
        if (this.types != null && to.types != null) {
            newTypes = Fields.copyTypes(this.types, this.size());
            for (int i = 0; i < pos.length; ++i) {
                newTypes[pos[i]] = to.types[i];
            }
        }
        return new Fields(newFields, newTypes);
    }

    public Fields rename(BiFunction<Comparable, Type, Comparable> function) {
        if (this.isSubstitution() || this.isUnknown()) {
            throw new TupleException("cannot rename fields in a substitution or unknown Fields instance: " + this.print());
        }
        Comparable[] newFields = new Comparable[this.fields.length];
        for (int i = 0; i < newFields.length; ++i) {
            newFields[i] = function.apply(this.fields[i], this.types != null ? this.types[i] : null);
        }
        return new Fields(newFields, this.types);
    }

    public Fields rename(Function<Comparable, Comparable> function) {
        if (this.isSubstitution() || this.isUnknown()) {
            throw new TupleException("cannot rename fields in a substitution or unknown Fields instance: " + this.print());
        }
        Comparable[] newFields = new Comparable[this.fields.length];
        for (int i = 0; i < newFields.length; ++i) {
            newFields[i] = function.apply(this.fields[i]);
        }
        return new Fields(newFields, this.types);
    }

    public Fields renameString(Function<String, Comparable> function) {
        if (this.isSubstitution() || this.isUnknown()) {
            throw new TupleException("cannot rename fields in a substitution or unknown Fields instance: " + this.print());
        }
        Comparable[] newFields = new Comparable[this.fields.length];
        for (int i = 0; i < newFields.length; ++i) {
            newFields[i] = function.apply(this.fields[i].toString());
        }
        return new Fields(newFields, this.types);
    }

    public Fields project(Fields fields) {
        if (fields == null) {
            return this;
        }
        Fields results = Fields.size(fields.size()).applyTypes(fields.getTypes());
        for (int i = 0; i < fields.fields.length; ++i) {
            results.fields[i] = fields.fields[i] instanceof String ? fields.fields[i] : (this.fields[i] instanceof String ? this.fields[i] : Integer.valueOf(i));
        }
        return results;
    }

    private static void copy(Set<String> names, Fields result, Fields fields, int offset) {
        for (int i = 0; i < fields.size(); ++i) {
            Comparable field = fields.get(i);
            if (!(field instanceof String)) continue;
            if (names != null) {
                if (names.contains(field)) {
                    throw new TupleException("field name already exists: " + field);
                }
                names.add((String)((Object)field));
            }
            result.set(i + offset, field);
        }
    }

    private static void copyRetain(Set<Comparable> names, Fields result, Fields fields, int offset, boolean isSelect) {
        for (int i = 0; i < fields.size(); ++i) {
            Comparable field = fields.get(i);
            if (!isSelect && field instanceof Integer) continue;
            if (names != null) {
                if (names.contains(field)) {
                    throw new TupleException("field name already exists: " + field);
                }
                names.add(field);
            }
            result.set(i + offset, field);
        }
    }

    public void verifyContains(Fields fields) {
        if (this.isUnknown()) {
            return;
        }
        try {
            this.getPos(fields);
        }
        catch (TupleException exception) {
            throw new TupleException("these fields " + this.print() + ", do not contain " + fields.print());
        }
    }

    public boolean contains(Fields fields) {
        try {
            this.getPos(fields);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int compareTo(Fields other) {
        if (other.size() != this.size()) {
            return other.size() < this.size() ? 1 : -1;
        }
        for (int i = 0; i < this.size(); ++i) {
            int c = this.get(i).compareTo(other.get(i));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public int compareTo(Object other) {
        if (other instanceof Fields) {
            return this.compareTo((Fields)other);
        }
        return -1;
    }

    public String print() {
        return "[" + this.toString() + "]";
    }

    public String printVerbose() {
        String fieldsString = this.toString();
        return "[{" + (this.isDefined() ? Integer.valueOf(this.size()) : "?") + "}:" + fieldsString + "]";
    }

    public String toString() {
        String string = this.isOrdered() ? this.orderedToString() : this.unorderedToString();
        if (this.types != null) {
            string = string + " | " + Util.join(Util.simpleTypeNames(this.types), ", ");
        }
        return string;
    }

    private String orderedToString() {
        StringBuffer buffer = new StringBuffer();
        if (this.size() != 0) {
            int startIndex = this.get(0) instanceof Number ? (Integer)this.get(0) : 0;
            for (int i = 0; i < this.size(); ++i) {
                Comparable field = this.get(i);
                if (field instanceof Number) {
                    if (i + 1 != this.size() && this.get(i + 1) instanceof Number) continue;
                    if (buffer.length() != 0) {
                        buffer.append(", ");
                    }
                    if (startIndex != i) {
                        buffer.append(startIndex).append(":").append(field);
                    } else {
                        buffer.append(i);
                    }
                    startIndex = i;
                    continue;
                }
                if (i != 0) {
                    buffer.append(", ");
                }
                if (field instanceof String) {
                    buffer.append("'").append(field).append("'");
                } else if (field instanceof Fields) {
                    buffer.append(((Fields)field).print());
                }
                startIndex = i + 1;
            }
        }
        if (this.kind != null) {
            if (buffer.length() != 0) {
                buffer.append(", ");
            }
            buffer.append((Object)this.kind);
        }
        return buffer.toString();
    }

    private String unorderedToString() {
        StringBuffer buffer = new StringBuffer();
        for (Comparable field : this.get()) {
            if (buffer.length() != 0) {
                buffer.append(", ");
            }
            if (field instanceof String) {
                buffer.append("'").append(field).append("'");
                continue;
            }
            if (field instanceof Fields) {
                buffer.append(((Fields)field).print());
                continue;
            }
            buffer.append(field);
        }
        if (this.kind != null) {
            if (buffer.length() != 0) {
                buffer.append(", ");
            }
            buffer.append((Object)this.kind);
        }
        return buffer.toString();
    }

    public final int size() {
        return this.fields.length;
    }

    public Fields applyFields(Comparable ... fields) {
        Fields result = new Fields(fields);
        if (this.types == null) {
            return result;
        }
        if (this.types.length != result.size()) {
            throw new IllegalArgumentException("given number of field names must match current fields size");
        }
        result.types = Fields.copyTypes(this.types, this.types.length);
        return result;
    }

    public Fields applyType(Comparable fieldName, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("given type must not be null");
        }
        try {
            int pos = this.getPos(Fields.asFieldName(fieldName));
        }
        catch (FieldsResolverException exception) {
            throw new IllegalArgumentException("given field name was not found: " + fieldName, exception);
        }
        Fields results = new Fields(this.fields);
        results.types = this.types == null ? new Type[this.size()] : Fields.copyTypes(this.types, this.types.length);
        results.types[pos] = type;
        return results;
    }

    public Fields applyTypeToAll(Type type) {
        Fields result = new Fields(this.fields);
        if (type == null) {
            return result;
        }
        Object[] copy = new Type[result.size()];
        Arrays.fill(copy, type);
        result.types = copy;
        return result;
    }

    public Fields applyTypes(Fields fields) {
        Fields result = new Fields(this.fields, this.types);
        for (Comparable field : fields) {
            result = result.applyType(field, fields.getType(fields.getPos(field)));
        }
        return result;
    }

    public Fields applyTypes(Type ... types) {
        Fields result = new Fields(this.fields);
        if (types == null || types.length == 0) {
            return result;
        }
        if (types.length != this.size()) {
            throw new IllegalArgumentException("given number of class instances must match fields size");
        }
        for (Type type : types) {
            if (type != null) continue;
            throw new IllegalArgumentException("type must not be null");
        }
        result.types = Fields.copyTypes(types, types.length);
        return result;
    }

    public Fields unApplyTypes() {
        return this.applyTypes(new Type[0]);
    }

    public Type getType(Comparable fieldName) {
        if (!this.hasTypes()) {
            return null;
        }
        return this.getType(this.getPos(fieldName));
    }

    public Type getType(int pos) {
        if (!this.hasTypes()) {
            return null;
        }
        return this.types[pos];
    }

    public Class getTypeClass(Comparable fieldName) {
        if (!this.hasTypes()) {
            return null;
        }
        return this.getTypeClass(this.getPos(fieldName));
    }

    public Class getTypeClass(int pos) {
        Type type = this.getType(pos);
        if (type instanceof CoercibleType) {
            return ((CoercibleType)type).getCanonicalType();
        }
        return (Class)type;
    }

    protected void setType(int pos, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("type may not be null");
        }
        this.types[pos] = type;
    }

    public Type[] getTypes() {
        return Fields.copyTypes(this.types, this.size());
    }

    public Class[] getTypesClasses() {
        if (this.types == null) {
            return null;
        }
        Class[] classes = new Class[this.types.length];
        for (int i = 0; i < this.types.length; ++i) {
            classes[i] = this.types[i] instanceof CoercibleType ? ((CoercibleType)this.types[i]).getCanonicalType() : (Class)this.types[i];
        }
        return classes;
    }

    private static Type[] copyTypes(Type[] types, int size) {
        if (types == null) {
            return null;
        }
        Type[] copy = new Type[size];
        if (types.length != size) {
            throw new IllegalArgumentException("types array must be same size as fields array");
        }
        System.arraycopy(types, 0, copy, 0, size);
        return copy;
    }

    public final boolean hasTypes() {
        return this.types != null;
    }

    public void setComparator(Comparable fieldName, Comparator comparator) {
        if (!(comparator instanceof Serializable)) {
            throw new IllegalArgumentException("given comparator must be serializable");
        }
        if (this.comparators == null) {
            this.comparators = new Comparator[this.size()];
        }
        try {
            this.comparators[this.getPos((Comparable)Fields.asFieldName((Comparable)fieldName))] = comparator;
        }
        catch (FieldsResolverException exception) {
            throw new IllegalArgumentException("given field name was not found: " + fieldName, exception);
        }
    }

    public void setComparators(Comparator ... comparators) {
        if (comparators.length != this.size()) {
            throw new IllegalArgumentException("given number of comparator instances must match fields size");
        }
        for (Comparator comparator : comparators) {
            if (comparator instanceof Serializable) continue;
            throw new IllegalArgumentException("comparators must be serializable");
        }
        this.comparators = comparators;
    }

    protected static Comparable asFieldName(Comparable fieldName) {
        if (fieldName instanceof Fields) {
            Fields fields = (Fields)fieldName;
            if (!fields.isDefined()) {
                throw new TupleException("given Fields instance must explicitly declare one field name or position: " + fields.printVerbose());
            }
            fieldName = fields.get(0);
        }
        return fieldName;
    }

    protected Comparator getComparator(Comparable fieldName) {
        if (this.comparators == null) {
            return null;
        }
        try {
            return this.comparators[this.getPos(Fields.asFieldName(fieldName))];
        }
        catch (FieldsResolverException exception) {
            return null;
        }
    }

    public Comparator[] getComparators() {
        Comparator[] copy = new Comparator[this.size()];
        if (this.comparators != null) {
            System.arraycopy(this.comparators, 0, copy, 0, this.size());
        }
        return copy;
    }

    public boolean hasComparators() {
        return this.comparators != null;
    }

    @Override
    public int compare(Tuple lhs, Tuple rhs) {
        return lhs.compareTo(this.comparators, rhs);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Fields fields = (Fields)object;
        return this.equalsFields(fields) && Arrays.equals(this.types, fields.types);
    }

    public boolean equalsFields(Fields fields) {
        return fields != null && this.kind == fields.kind && Arrays.equals(this.get(), fields.get());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.get());
        }
        return this.hashCode;
    }

    static enum Kind {
        NONE,
        ALL,
        GROUP,
        VALUES,
        ARGS,
        RESULTS,
        UNKNOWN,
        REPLACE,
        SWAP;

    }
}

